/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.MathElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Specifies the fraction object, consisting of a numerator and denominator separated by a fraction bar.")
public class FractionElement
extends MathElement {
    @SerializedName(value="fractionType", alternate={"FractionType"})
    private FractionTypeEnum fractionType;
    @SerializedName(value="numerator", alternate={"Numerator"})
    private MathElement numerator;
    @SerializedName(value="denominator", alternate={"Denominator"})
    private MathElement denominator;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public FractionElement() {
        this.setType(MathElement.TypeEnum.FRACTION);
    }

    public FractionElement fractionType(FractionTypeEnum fractionType) {
        this.fractionType = fractionType;
        return this;
    }

    @ApiModelProperty(value="Fraction type")
    public FractionTypeEnum getFractionType() {
        return this.fractionType;
    }

    public void setFractionType(FractionTypeEnum fractionType) {
        this.fractionType = fractionType;
    }

    public FractionElement numerator(MathElement numerator) {
        this.numerator = numerator;
        return this;
    }

    @ApiModelProperty(value="Numerator")
    public MathElement getNumerator() {
        return this.numerator;
    }

    public void setNumerator(MathElement numerator) {
        this.numerator = numerator;
    }

    public FractionElement denominator(MathElement denominator) {
        this.denominator = denominator;
        return this;
    }

    @ApiModelProperty(value="Denominator")
    public MathElement getDenominator() {
        return this.denominator;
    }

    public void setDenominator(MathElement denominator) {
        this.denominator = denominator;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FractionElement fractionElement = (FractionElement)o;
        return Objects.equals((Object)this.fractionType, (Object)fractionElement.fractionType) && Objects.equals(this.numerator, fractionElement.numerator) && Objects.equals(this.denominator, fractionElement.denominator) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.fractionType, this.numerator, this.denominator, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FractionElement {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    fractionType: ").append(this.toIndentedString((Object)this.fractionType)).append("\n");
        sb.append("    numerator: ").append(this.toIndentedString(this.numerator)).append("\n");
        sb.append("    denominator: ").append(this.toIndentedString(this.denominator)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    static {
        typeDeterminers.put("Type", (Object)MathElement.TypeEnum.FRACTION);
    }

    @JsonAdapter(value=Adapter.class)
    public static enum FractionTypeEnum {
        BAR("Bar"),
        SKEWED("Skewed"),
        LINEAR("Linear"),
        NOBAR("NoBar");

        private String value;

        private FractionTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static FractionTypeEnum fromValue(String text) {
            for (FractionTypeEnum b : FractionTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<FractionTypeEnum> {
            public void write(JsonWriter jsonWriter, FractionTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public FractionTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return FractionTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

