/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.ShapeBase;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Represents GeometryShape resource.")
public class GeometryShape
extends ShapeBase {
    @SerializedName(value="shapeType", alternate={"ShapeType"})
    private ShapeTypeEnum shapeType;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public GeometryShape shapeType(ShapeTypeEnum shapeType) {
        this.shapeType = shapeType;
        return this;
    }

    @ApiModelProperty(required=true, value="Combined shape type.")
    public ShapeTypeEnum getShapeType() {
        return this.shapeType;
    }

    public void setShapeType(ShapeTypeEnum shapeType) {
        this.shapeType = shapeType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeometryShape geometryShape = (GeometryShape)o;
        return Objects.equals((Object)this.shapeType, (Object)geometryShape.shapeType) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.shapeType, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GeometryShape {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    shapeType: ").append(this.toIndentedString((Object)this.shapeType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ShapeTypeEnum {
        CUSTOM("Custom"),
        LINE("Line"),
        LINEINVERSE("LineInverse"),
        TRIANGLE("Triangle"),
        RIGHTTRIANGLE("RightTriangle"),
        RECTANGLE("Rectangle"),
        DIAMOND("Diamond"),
        PARALLELOGRAM("Parallelogram"),
        TRAPEZOID("Trapezoid"),
        NONISOSCELESTRAPEZOID("NonIsoscelesTrapezoid"),
        PENTAGON("Pentagon"),
        HEXAGON("Hexagon"),
        HEPTAGON("Heptagon"),
        OCTAGON("Octagon"),
        DECAGON("Decagon"),
        DODECAGON("Dodecagon"),
        FOURPOINTEDSTAR("FourPointedStar"),
        FIVEPOINTEDSTAR("FivePointedStar"),
        SIXPOINTEDSTAR("SixPointedStar"),
        SEVENPOINTEDSTAR("SevenPointedStar"),
        EIGHTPOINTEDSTAR("EightPointedStar"),
        TENPOINTEDSTAR("TenPointedStar"),
        TWELVEPOINTEDSTAR("TwelvePointedStar"),
        SIXTEENPOINTEDSTAR("SixteenPointedStar"),
        TWENTYFOURPOINTEDSTAR("TwentyFourPointedStar"),
        THIRTYTWOPOINTEDSTAR("ThirtyTwoPointedStar"),
        ROUNDCORNERRECTANGLE("RoundCornerRectangle"),
        ONEROUNDCORNERRECTANGLE("OneRoundCornerRectangle"),
        TWOSAMESIDEROUNDCORNERRECTANGLE("TwoSamesideRoundCornerRectangle"),
        TWODIAGONALROUNDCORNERRECTANGLE("TwoDiagonalRoundCornerRectangle"),
        ONESNIPONEROUNDCORNERRECTANGLE("OneSnipOneRoundCornerRectangle"),
        ONESNIPCORNERRECTANGLE("OneSnipCornerRectangle"),
        TWOSAMESIDESNIPCORNERRECTANGLE("TwoSamesideSnipCornerRectangle"),
        TWODIAGONALSNIPCORNERRECTANGLE("TwoDiagonalSnipCornerRectangle"),
        PLAQUE("Plaque"),
        ELLIPSE("Ellipse"),
        TEARDROP("Teardrop"),
        HOMEPLATE("HomePlate"),
        CHEVRON("Chevron"),
        PIEWEDGE("PieWedge"),
        PIE("Pie"),
        BLOCKARC("BlockArc"),
        DONUT("Donut"),
        NOSMOKING("NoSmoking"),
        RIGHTARROW("RightArrow"),
        LEFTARROW("LeftArrow"),
        UPARROW("UpArrow"),
        DOWNARROW("DownArrow"),
        STRIPEDRIGHTARROW("StripedRightArrow"),
        NOTCHEDRIGHTARROW("NotchedRightArrow"),
        BENTUPARROW("BentUpArrow"),
        LEFTRIGHTARROW("LeftRightArrow"),
        UPDOWNARROW("UpDownArrow"),
        LEFTUPARROW("LeftUpArrow"),
        LEFTRIGHTUPARROW("LeftRightUpArrow"),
        QUADARROW("QuadArrow"),
        CALLOUTLEFTARROW("CalloutLeftArrow"),
        CALLOUTRIGHTARROW("CalloutRightArrow"),
        CALLOUTUPARROW("CalloutUpArrow"),
        CALLOUTDOWNARROW("CalloutDownArrow"),
        CALLOUTLEFTRIGHTARROW("CalloutLeftRightArrow"),
        CALLOUTUPDOWNARROW("CalloutUpDownArrow"),
        CALLOUTQUADARROW("CalloutQuadArrow"),
        BENTARROW("BentArrow"),
        UTURNARROW("UTurnArrow"),
        CIRCULARARROW("CircularArrow"),
        LEFTCIRCULARARROW("LeftCircularArrow"),
        LEFTRIGHTCIRCULARARROW("LeftRightCircularArrow"),
        CURVEDRIGHTARROW("CurvedRightArrow"),
        CURVEDLEFTARROW("CurvedLeftArrow"),
        CURVEDUPARROW("CurvedUpArrow"),
        CURVEDDOWNARROW("CurvedDownArrow"),
        SWOOSHARROW("SwooshArrow"),
        CUBE("Cube"),
        CAN("Can"),
        LIGHTNINGBOLT("LightningBolt"),
        HEART("Heart"),
        SUN("Sun"),
        MOON("Moon"),
        SMILEYFACE("SmileyFace"),
        IRREGULARSEAL1("IrregularSeal1"),
        IRREGULARSEAL2("IrregularSeal2"),
        FOLDEDCORNER("FoldedCorner"),
        BEVEL("Bevel"),
        FRAME("Frame"),
        HALFFRAME("HalfFrame"),
        CORNER("Corner"),
        DIAGONALSTRIPE("DiagonalStripe"),
        CHORD("Chord"),
        CURVEDARC("CurvedArc"),
        LEFTBRACKET("LeftBracket"),
        RIGHTBRACKET("RightBracket"),
        LEFTBRACE("LeftBrace"),
        RIGHTBRACE("RightBrace"),
        BRACKETPAIR("BracketPair"),
        BRACEPAIR("BracePair"),
        STRAIGHTCONNECTOR1("StraightConnector1"),
        BENTCONNECTOR2("BentConnector2"),
        BENTCONNECTOR3("BentConnector3"),
        BENTCONNECTOR4("BentConnector4"),
        BENTCONNECTOR5("BentConnector5"),
        CURVEDCONNECTOR2("CurvedConnector2"),
        CURVEDCONNECTOR3("CurvedConnector3"),
        CURVEDCONNECTOR4("CurvedConnector4"),
        CURVEDCONNECTOR5("CurvedConnector5"),
        CALLOUT1("Callout1"),
        CALLOUT2("Callout2"),
        CALLOUT3("Callout3"),
        CALLOUT1WITHACCENT("Callout1WithAccent"),
        CALLOUT2WITHACCENT("Callout2WithAccent"),
        CALLOUT3WITHACCENT("Callout3WithAccent"),
        CALLOUT1WITHBORDER("Callout1WithBorder"),
        CALLOUT2WITHBORDER("Callout2WithBorder"),
        CALLOUT3WITHBORDER("Callout3WithBorder"),
        CALLOUT1WITHBORDERANDACCENT("Callout1WithBorderAndAccent"),
        CALLOUT2WITHBORDERANDACCENT("Callout2WithBorderAndAccent"),
        CALLOUT3WITHBORDERANDACCENT("Callout3WithBorderAndAccent"),
        CALLOUTWEDGERECTANGLE("CalloutWedgeRectangle"),
        CALLOUTWEDGEROUNDRECTANGLE("CalloutWedgeRoundRectangle"),
        CALLOUTWEDGEELLIPSE("CalloutWedgeEllipse"),
        CALLOUTCLOUD("CalloutCloud"),
        CLOUD("Cloud"),
        RIBBON("Ribbon"),
        RIBBON2("Ribbon2"),
        ELLIPSERIBBON("EllipseRibbon"),
        ELLIPSERIBBON2("EllipseRibbon2"),
        LEFTRIGHTRIBBON("LeftRightRibbon"),
        VERTICALSCROLL("VerticalScroll"),
        HORIZONTALSCROLL("HorizontalScroll"),
        WAVE("Wave"),
        DOUBLEWAVE("DoubleWave"),
        PLUS("Plus"),
        PROCESSFLOW("ProcessFlow"),
        DECISIONFLOW("DecisionFlow"),
        INPUTOUTPUTFLOW("InputOutputFlow"),
        PREDEFINEDPROCESSFLOW("PredefinedProcessFlow"),
        INTERNALSTORAGEFLOW("InternalStorageFlow"),
        DOCUMENTFLOW("DocumentFlow"),
        MULTIDOCUMENTFLOW("MultiDocumentFlow"),
        TERMINATORFLOW("TerminatorFlow"),
        PREPARATIONFLOW("PreparationFlow"),
        MANUALINPUTFLOW("ManualInputFlow"),
        MANUALOPERATIONFLOW("ManualOperationFlow"),
        CONNECTORFLOW("ConnectorFlow"),
        PUNCHEDCARDFLOW("PunchedCardFlow"),
        PUNCHEDTAPEFLOW("PunchedTapeFlow"),
        SUMMINGJUNCTIONFLOW("SummingJunctionFlow"),
        ORFLOW("OrFlow"),
        COLLATEFLOW("CollateFlow"),
        SORTFLOW("SortFlow"),
        EXTRACTFLOW("ExtractFlow"),
        MERGEFLOW("MergeFlow"),
        OFFLINESTORAGEFLOW("OfflineStorageFlow"),
        ONLINESTORAGEFLOW("OnlineStorageFlow"),
        MAGNETICTAPEFLOW("MagneticTapeFlow"),
        MAGNETICDISKFLOW("MagneticDiskFlow"),
        MAGNETICDRUMFLOW("MagneticDrumFlow"),
        DISPLAYFLOW("DisplayFlow"),
        DELAYFLOW("DelayFlow"),
        ALTERNATEPROCESSFLOW("AlternateProcessFlow"),
        OFFPAGECONNECTORFLOW("OffPageConnectorFlow"),
        BLANKBUTTON("BlankButton"),
        HOMEBUTTON("HomeButton"),
        HELPBUTTON("HelpButton"),
        INFORMATIONBUTTON("InformationButton"),
        FORWARDORNEXTBUTTON("ForwardOrNextButton"),
        BACKORPREVIOUSBUTTON("BackOrPreviousButton"),
        ENDBUTTON("EndButton"),
        BEGINNINGBUTTON("BeginningButton"),
        RETURNBUTTON("ReturnButton"),
        DOCUMENTBUTTON("DocumentButton"),
        SOUNDBUTTON("SoundButton"),
        MOVIEBUTTON("MovieButton"),
        GEAR6("Gear6"),
        GEAR9("Gear9"),
        FUNNEL("Funnel"),
        PLUSMATH("PlusMath"),
        MINUSMATH("MinusMath"),
        MULTIPLYMATH("MultiplyMath"),
        DIVIDEMATH("DivideMath"),
        EQUALMATH("EqualMath"),
        NOTEQUALMATH("NotEqualMath"),
        CORNERTABS("CornerTabs"),
        SQUARETABS("SquareTabs"),
        PLAQUETABS("PlaqueTabs"),
        CHARTX("ChartX"),
        CHARTSTAR("ChartStar"),
        CHARTPLUS("ChartPlus"),
        NOTDEFINED("NotDefined");

        private String value;

        private ShapeTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ShapeTypeEnum fromValue(String text) {
            for (ShapeTypeEnum b : ShapeTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ShapeTypeEnum> {
            public void write(JsonWriter jsonWriter, ShapeTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ShapeTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ShapeTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

