/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.FillFormat;
import com.aspose.slides.model.GradientFillStop;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Represents gradient fill format")
public class GradientFill
extends FillFormat {
    @SerializedName(value="direction", alternate={"Direction"})
    private DirectionEnum direction;
    @SerializedName(value="shape", alternate={"Shape"})
    private ShapeEnum shape;
    @SerializedName(value="stops", alternate={"Stops"})
    private List<GradientFillStop> stops = null;
    @SerializedName(value="linearAngle", alternate={"LinearAngle"})
    private Double linearAngle;
    @SerializedName(value="isScaled", alternate={"IsScaled"})
    private Boolean isScaled;
    @SerializedName(value="tileFlip", alternate={"TileFlip"})
    private TileFlipEnum tileFlip;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public GradientFill() {
        this.setType(FillFormat.TypeEnum.GRADIENT);
    }

    public GradientFill direction(DirectionEnum direction) {
        this.direction = direction;
        return this;
    }

    @ApiModelProperty(value="Gradient style.")
    public DirectionEnum getDirection() {
        return this.direction;
    }

    public void setDirection(DirectionEnum direction) {
        this.direction = direction;
    }

    public GradientFill shape(ShapeEnum shape) {
        this.shape = shape;
        return this;
    }

    @ApiModelProperty(value="Gradient shape.")
    public ShapeEnum getShape() {
        return this.shape;
    }

    public void setShape(ShapeEnum shape) {
        this.shape = shape;
    }

    public GradientFill stops(List<GradientFillStop> stops) {
        this.stops = stops;
        return this;
    }

    public GradientFill addStopsItem(GradientFillStop stopsItem) {
        if (this.stops == null) {
            this.stops = new ArrayList<GradientFillStop>();
        }
        this.stops.add(stopsItem);
        return this;
    }

    @ApiModelProperty(value="Gradient stops.")
    public List<GradientFillStop> getStops() {
        return this.stops;
    }

    public void setStops(List<GradientFillStop> stops) {
        this.stops = stops;
    }

    public GradientFill linearAngle(Double linearAngle) {
        this.linearAngle = linearAngle;
        return this;
    }

    @ApiModelProperty(value="Gradient angle.")
    public Double getLinearAngle() {
        return this.linearAngle;
    }

    public void setLinearAngle(Double linearAngle) {
        this.linearAngle = linearAngle;
    }

    public GradientFill isScaled(Boolean isScaled) {
        this.isScaled = isScaled;
        return this;
    }

    @ApiModelProperty(value="True if the gradient is scaled.")
    public Boolean getIsScaled() {
        return this.isScaled;
    }

    public void setIsScaled(Boolean isScaled) {
        this.isScaled = isScaled;
    }

    public GradientFill tileFlip(TileFlipEnum tileFlip) {
        this.tileFlip = tileFlip;
        return this;
    }

    @ApiModelProperty(value="Gradient flipping mode.")
    public TileFlipEnum getTileFlip() {
        return this.tileFlip;
    }

    public void setTileFlip(TileFlipEnum tileFlip) {
        this.tileFlip = tileFlip;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GradientFill gradientFill = (GradientFill)o;
        return Objects.equals((Object)this.direction, (Object)gradientFill.direction) && Objects.equals((Object)this.shape, (Object)gradientFill.shape) && Objects.equals(this.stops, gradientFill.stops) && Objects.equals(this.linearAngle, gradientFill.linearAngle) && Objects.equals(this.isScaled, gradientFill.isScaled) && Objects.equals((Object)this.tileFlip, (Object)gradientFill.tileFlip) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.direction, this.shape, this.stops, this.linearAngle, this.isScaled, this.tileFlip, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GradientFill {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("    shape: ").append(this.toIndentedString((Object)this.shape)).append("\n");
        sb.append("    stops: ").append(this.toIndentedString(this.stops)).append("\n");
        sb.append("    linearAngle: ").append(this.toIndentedString(this.linearAngle)).append("\n");
        sb.append("    isScaled: ").append(this.toIndentedString(this.isScaled)).append("\n");
        sb.append("    tileFlip: ").append(this.toIndentedString((Object)this.tileFlip)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    static {
        typeDeterminers.put("Type", (Object)FillFormat.TypeEnum.GRADIENT);
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TileFlipEnum {
        NOFLIP("NoFlip"),
        FLIPX("FlipX"),
        FLIPY("FlipY"),
        FLIPBOTH("FlipBoth"),
        NOTDEFINED("NotDefined");

        private String value;

        private TileFlipEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TileFlipEnum fromValue(String text) {
            for (TileFlipEnum b : TileFlipEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TileFlipEnum> {
            public void write(JsonWriter jsonWriter, TileFlipEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TileFlipEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TileFlipEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ShapeEnum {
        LINEAR("Linear"),
        RECTANGLE("Rectangle"),
        RADIAL("Radial"),
        PATH("Path"),
        NOTDEFINED("NotDefined");

        private String value;

        private ShapeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ShapeEnum fromValue(String text) {
            for (ShapeEnum b : ShapeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ShapeEnum> {
            public void write(JsonWriter jsonWriter, ShapeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ShapeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ShapeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DirectionEnum {
        FROMCORNER1("FromCorner1"),
        FROMCORNER2("FromCorner2"),
        FROMCORNER3("FromCorner3"),
        FROMCORNER4("FromCorner4"),
        FROMCENTER("FromCenter"),
        NOTDEFINED("NotDefined");

        private String value;

        private DirectionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DirectionEnum fromValue(String text) {
            for (DirectionEnum b : DirectionEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<DirectionEnum> {
            public void write(JsonWriter jsonWriter, DirectionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public DirectionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DirectionEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

