/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.ExportOptions;
import com.aspose.slides.model.SlidesLayoutOptions;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Provides options that control how a presentation is saved in Html format.")
public class HtmlExportOptions
extends ExportOptions {
    @SerializedName(value="saveAsZip", alternate={"SaveAsZip"})
    private Boolean saveAsZip;
    @SerializedName(value="subDirectoryName", alternate={"SubDirectoryName"})
    private String subDirectoryName;
    @SerializedName(value="showHiddenSlides", alternate={"ShowHiddenSlides"})
    private Boolean showHiddenSlides;
    @SerializedName(value="svgResponsiveLayout", alternate={"SvgResponsiveLayout"})
    private Boolean svgResponsiveLayout;
    @SerializedName(value="jpegQuality", alternate={"JpegQuality"})
    private Integer jpegQuality;
    @SerializedName(value="picturesCompression", alternate={"PicturesCompression"})
    private PicturesCompressionEnum picturesCompression;
    @SerializedName(value="deletePicturesCroppedAreas", alternate={"DeletePicturesCroppedAreas"})
    private Boolean deletePicturesCroppedAreas;
    @SerializedName(value="slidesLayoutOptions", alternate={"SlidesLayoutOptions"})
    private SlidesLayoutOptions slidesLayoutOptions;
    @SerializedName(value="disableFontLigatures", alternate={"DisableFontLigatures"})
    private Boolean disableFontLigatures;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public HtmlExportOptions() {
        this.setFormat("HTML");
    }

    public HtmlExportOptions saveAsZip(Boolean saveAsZip) {
        this.saveAsZip = saveAsZip;
        return this;
    }

    @ApiModelProperty(value="Get or sets flag for save presentation as zip file")
    public Boolean isSaveAsZip() {
        return this.saveAsZip;
    }

    public void setSaveAsZip(Boolean saveAsZip) {
        this.saveAsZip = saveAsZip;
    }

    public HtmlExportOptions subDirectoryName(String subDirectoryName) {
        this.subDirectoryName = subDirectoryName;
        return this;
    }

    @ApiModelProperty(value="Get or set name of subdirectory in zip-file for store external files")
    public String getSubDirectoryName() {
        return this.subDirectoryName;
    }

    public void setSubDirectoryName(String subDirectoryName) {
        this.subDirectoryName = subDirectoryName;
    }

    public HtmlExportOptions showHiddenSlides(Boolean showHiddenSlides) {
        this.showHiddenSlides = showHiddenSlides;
        return this;
    }

    @ApiModelProperty(value="Specifies whether the generated document should include hidden slides or not. Default is false. ")
    public Boolean isShowHiddenSlides() {
        return this.showHiddenSlides;
    }

    public void setShowHiddenSlides(Boolean showHiddenSlides) {
        this.showHiddenSlides = showHiddenSlides;
    }

    public HtmlExportOptions svgResponsiveLayout(Boolean svgResponsiveLayout) {
        this.svgResponsiveLayout = svgResponsiveLayout;
        return this;
    }

    @ApiModelProperty(value="True to make layout responsive by excluding width and height attributes from svg container.")
    public Boolean isSvgResponsiveLayout() {
        return this.svgResponsiveLayout;
    }

    public void setSvgResponsiveLayout(Boolean svgResponsiveLayout) {
        this.svgResponsiveLayout = svgResponsiveLayout;
    }

    public HtmlExportOptions jpegQuality(Integer jpegQuality) {
        this.jpegQuality = jpegQuality;
        return this;
    }

    @ApiModelProperty(value="Returns or sets a value determining the quality of the JPEG images inside PDF document.")
    public Integer getJpegQuality() {
        return this.jpegQuality;
    }

    public void setJpegQuality(Integer jpegQuality) {
        this.jpegQuality = jpegQuality;
    }

    public HtmlExportOptions picturesCompression(PicturesCompressionEnum picturesCompression) {
        this.picturesCompression = picturesCompression;
        return this;
    }

    @ApiModelProperty(value="Represents the pictures compression level")
    public PicturesCompressionEnum getPicturesCompression() {
        return this.picturesCompression;
    }

    public void setPicturesCompression(PicturesCompressionEnum picturesCompression) {
        this.picturesCompression = picturesCompression;
    }

    public HtmlExportOptions deletePicturesCroppedAreas(Boolean deletePicturesCroppedAreas) {
        this.deletePicturesCroppedAreas = deletePicturesCroppedAreas;
        return this;
    }

    @ApiModelProperty(value="A boolean flag indicates if the cropped parts remain as part of the document. If true the cropped  parts will removed, if false they will be serialized in the document (which can possible lead to a  larger file)")
    public Boolean isDeletePicturesCroppedAreas() {
        return this.deletePicturesCroppedAreas;
    }

    public void setDeletePicturesCroppedAreas(Boolean deletePicturesCroppedAreas) {
        this.deletePicturesCroppedAreas = deletePicturesCroppedAreas;
    }

    public HtmlExportOptions slidesLayoutOptions(SlidesLayoutOptions slidesLayoutOptions) {
        this.slidesLayoutOptions = slidesLayoutOptions;
        return this;
    }

    @ApiModelProperty(value="Slides layouting options")
    public SlidesLayoutOptions getSlidesLayoutOptions() {
        return this.slidesLayoutOptions;
    }

    public void setSlidesLayoutOptions(SlidesLayoutOptions slidesLayoutOptions) {
        this.slidesLayoutOptions = slidesLayoutOptions;
    }

    public HtmlExportOptions disableFontLigatures(Boolean disableFontLigatures) {
        this.disableFontLigatures = disableFontLigatures;
        return this;
    }

    @ApiModelProperty(value="true to disable ligatures in the rendered output.")
    public Boolean isDisableFontLigatures() {
        return this.disableFontLigatures;
    }

    public void setDisableFontLigatures(Boolean disableFontLigatures) {
        this.disableFontLigatures = disableFontLigatures;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HtmlExportOptions htmlExportOptions = (HtmlExportOptions)o;
        return Objects.equals(this.saveAsZip, htmlExportOptions.saveAsZip) && Objects.equals(this.subDirectoryName, htmlExportOptions.subDirectoryName) && Objects.equals(this.showHiddenSlides, htmlExportOptions.showHiddenSlides) && Objects.equals(this.svgResponsiveLayout, htmlExportOptions.svgResponsiveLayout) && Objects.equals(this.jpegQuality, htmlExportOptions.jpegQuality) && Objects.equals((Object)this.picturesCompression, (Object)htmlExportOptions.picturesCompression) && Objects.equals(this.deletePicturesCroppedAreas, htmlExportOptions.deletePicturesCroppedAreas) && Objects.equals(this.slidesLayoutOptions, htmlExportOptions.slidesLayoutOptions) && Objects.equals(this.disableFontLigatures, htmlExportOptions.disableFontLigatures) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.saveAsZip, this.subDirectoryName, this.showHiddenSlides, this.svgResponsiveLayout, this.jpegQuality, this.picturesCompression, this.deletePicturesCroppedAreas, this.slidesLayoutOptions, this.disableFontLigatures, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HtmlExportOptions {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    saveAsZip: ").append(this.toIndentedString(this.saveAsZip)).append("\n");
        sb.append("    subDirectoryName: ").append(this.toIndentedString(this.subDirectoryName)).append("\n");
        sb.append("    showHiddenSlides: ").append(this.toIndentedString(this.showHiddenSlides)).append("\n");
        sb.append("    svgResponsiveLayout: ").append(this.toIndentedString(this.svgResponsiveLayout)).append("\n");
        sb.append("    jpegQuality: ").append(this.toIndentedString(this.jpegQuality)).append("\n");
        sb.append("    picturesCompression: ").append(this.toIndentedString((Object)this.picturesCompression)).append("\n");
        sb.append("    deletePicturesCroppedAreas: ").append(this.toIndentedString(this.deletePicturesCroppedAreas)).append("\n");
        sb.append("    slidesLayoutOptions: ").append(this.toIndentedString(this.slidesLayoutOptions)).append("\n");
        sb.append("    disableFontLigatures: ").append(this.toIndentedString(this.disableFontLigatures)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PicturesCompressionEnum {
        DPI330("Dpi330"),
        DPI220("Dpi220"),
        DPI150("Dpi150"),
        DPI96("Dpi96"),
        DPI72("Dpi72"),
        DOCUMENTRESOLUTION("DocumentResolution");

        private String value;

        private PicturesCompressionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PicturesCompressionEnum fromValue(String text) {
            for (PicturesCompressionEnum b : PicturesCompressionEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<PicturesCompressionEnum> {
            public void write(JsonWriter jsonWriter, PicturesCompressionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PicturesCompressionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PicturesCompressionEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

