/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Hyperlink")
public class Hyperlink {
    @SerializedName(value="isDisabled", alternate={"IsDisabled"})
    private Boolean isDisabled;
    @SerializedName(value="actionType", alternate={"ActionType"})
    private ActionTypeEnum actionType;
    @SerializedName(value="externalUrl", alternate={"ExternalUrl"})
    private String externalUrl;
    @SerializedName(value="targetSlideIndex", alternate={"TargetSlideIndex"})
    private Integer targetSlideIndex;
    @SerializedName(value="targetFrame", alternate={"TargetFrame"})
    private String targetFrame;
    @SerializedName(value="tooltip", alternate={"Tooltip"})
    private String tooltip;
    @SerializedName(value="history", alternate={"History"})
    private Boolean history;
    @SerializedName(value="highlightClick", alternate={"HighlightClick"})
    private Boolean highlightClick;
    @SerializedName(value="stopSoundOnClick", alternate={"StopSoundOnClick"})
    private Boolean stopSoundOnClick;
    @SerializedName(value="colorSource", alternate={"ColorSource"})
    private ColorSourceEnum colorSource;
    @SerializedName(value="soundBase64", alternate={"SoundBase64"})
    private String soundBase64;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public Hyperlink isDisabled(Boolean isDisabled) {
        this.isDisabled = isDisabled;
        return this;
    }

    @ApiModelProperty(value="If true Hypelink is not applied. ")
    public Boolean getIsDisabled() {
        return this.isDisabled;
    }

    public void setIsDisabled(Boolean isDisabled) {
        this.isDisabled = isDisabled;
    }

    public Hyperlink actionType(ActionTypeEnum actionType) {
        this.actionType = actionType;
        return this;
    }

    @ApiModelProperty(required=true, value="Type of HyperLink action             ")
    public ActionTypeEnum getActionType() {
        return this.actionType;
    }

    public void setActionType(ActionTypeEnum actionType) {
        this.actionType = actionType;
    }

    public Hyperlink externalUrl(String externalUrl) {
        this.externalUrl = externalUrl;
        return this;
    }

    @ApiModelProperty(value="Specifies the external URL")
    public String getExternalUrl() {
        return this.externalUrl;
    }

    public void setExternalUrl(String externalUrl) {
        this.externalUrl = externalUrl;
    }

    public Hyperlink targetSlideIndex(Integer targetSlideIndex) {
        this.targetSlideIndex = targetSlideIndex;
        return this;
    }

    @ApiModelProperty(value="Index of the target slide")
    public Integer getTargetSlideIndex() {
        return this.targetSlideIndex;
    }

    public void setTargetSlideIndex(Integer targetSlideIndex) {
        this.targetSlideIndex = targetSlideIndex;
    }

    public Hyperlink targetFrame(String targetFrame) {
        this.targetFrame = targetFrame;
        return this;
    }

    @ApiModelProperty(value="Target frame")
    public String getTargetFrame() {
        return this.targetFrame;
    }

    public void setTargetFrame(String targetFrame) {
        this.targetFrame = targetFrame;
    }

    public Hyperlink tooltip(String tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    @ApiModelProperty(value="Hyperlink tooltip")
    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public Hyperlink history(Boolean history) {
        this.history = history;
        return this;
    }

    @ApiModelProperty(value="Makes hyperlink viewed when it is invoked.             ")
    public Boolean isHistory() {
        return this.history;
    }

    public void setHistory(Boolean history) {
        this.history = history;
    }

    public Hyperlink highlightClick(Boolean highlightClick) {
        this.highlightClick = highlightClick;
        return this;
    }

    @ApiModelProperty(value="Determines whether the hyperlink should be highlighted on click.")
    public Boolean isHighlightClick() {
        return this.highlightClick;
    }

    public void setHighlightClick(Boolean highlightClick) {
        this.highlightClick = highlightClick;
    }

    public Hyperlink stopSoundOnClick(Boolean stopSoundOnClick) {
        this.stopSoundOnClick = stopSoundOnClick;
        return this;
    }

    @ApiModelProperty(value="Determines whether the sound should be stopped on hyperlink click")
    public Boolean isStopSoundOnClick() {
        return this.stopSoundOnClick;
    }

    public void setStopSoundOnClick(Boolean stopSoundOnClick) {
        this.stopSoundOnClick = stopSoundOnClick;
    }

    public Hyperlink colorSource(ColorSourceEnum colorSource) {
        this.colorSource = colorSource;
        return this;
    }

    @ApiModelProperty(value="Represents the source of hyperlink color")
    public ColorSourceEnum getColorSource() {
        return this.colorSource;
    }

    public void setColorSource(ColorSourceEnum colorSource) {
        this.colorSource = colorSource;
    }

    public Hyperlink soundBase64(String soundBase64) {
        this.soundBase64 = soundBase64;
        return this;
    }

    @ApiModelProperty(value="Audio data encoded in base64. Represents the playing sound of the hyperlink. ")
    public String getSoundBase64() {
        return this.soundBase64;
    }

    public void setSoundBase64(String soundBase64) {
        this.soundBase64 = soundBase64;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Hyperlink hyperlink = (Hyperlink)o;
        return Objects.equals(this.isDisabled, hyperlink.isDisabled) && Objects.equals((Object)this.actionType, (Object)hyperlink.actionType) && Objects.equals(this.externalUrl, hyperlink.externalUrl) && Objects.equals(this.targetSlideIndex, hyperlink.targetSlideIndex) && Objects.equals(this.targetFrame, hyperlink.targetFrame) && Objects.equals(this.tooltip, hyperlink.tooltip) && Objects.equals(this.history, hyperlink.history) && Objects.equals(this.highlightClick, hyperlink.highlightClick) && Objects.equals(this.stopSoundOnClick, hyperlink.stopSoundOnClick) && Objects.equals((Object)this.colorSource, (Object)hyperlink.colorSource) && Objects.equals(this.soundBase64, hyperlink.soundBase64);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.isDisabled, this.actionType, this.externalUrl, this.targetSlideIndex, this.targetFrame, this.tooltip, this.history, this.highlightClick, this.stopSoundOnClick, this.colorSource, this.soundBase64});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Hyperlink {\n");
        sb.append("    isDisabled: ").append(this.toIndentedString(this.isDisabled)).append("\n");
        sb.append("    actionType: ").append(this.toIndentedString((Object)this.actionType)).append("\n");
        sb.append("    externalUrl: ").append(this.toIndentedString(this.externalUrl)).append("\n");
        sb.append("    targetSlideIndex: ").append(this.toIndentedString(this.targetSlideIndex)).append("\n");
        sb.append("    targetFrame: ").append(this.toIndentedString(this.targetFrame)).append("\n");
        sb.append("    tooltip: ").append(this.toIndentedString(this.tooltip)).append("\n");
        sb.append("    history: ").append(this.toIndentedString(this.history)).append("\n");
        sb.append("    highlightClick: ").append(this.toIndentedString(this.highlightClick)).append("\n");
        sb.append("    stopSoundOnClick: ").append(this.toIndentedString(this.stopSoundOnClick)).append("\n");
        sb.append("    colorSource: ").append(this.toIndentedString((Object)this.colorSource)).append("\n");
        sb.append("    soundBase64: ").append(this.toIndentedString(this.soundBase64)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ColorSourceEnum {
        STYLES("Styles"),
        PORTIONFORMAT("PortionFormat");

        private String value;

        private ColorSourceEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ColorSourceEnum fromValue(String text) {
            for (ColorSourceEnum b : ColorSourceEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ColorSourceEnum> {
            public void write(JsonWriter jsonWriter, ColorSourceEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ColorSourceEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ColorSourceEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ActionTypeEnum {
        NOACTION("NoAction"),
        HYPERLINK("Hyperlink"),
        JUMPFIRSTSLIDE("JumpFirstSlide"),
        JUMPPREVIOUSSLIDE("JumpPreviousSlide"),
        JUMPNEXTSLIDE("JumpNextSlide"),
        JUMPLASTSLIDE("JumpLastSlide"),
        JUMPENDSHOW("JumpEndShow"),
        JUMPLASTVIEWEDSLIDE("JumpLastViewedSlide"),
        JUMPSPECIFICSLIDE("JumpSpecificSlide"),
        STARTCUSTOMSLIDESHOW("StartCustomSlideShow"),
        OPENFILE("OpenFile"),
        OPENPRESENTATION("OpenPresentation"),
        STARTSTOPMEDIA("StartStopMedia"),
        STARTMACRO("StartMacro"),
        STARTPROGRAM("StartProgram"),
        UNKNOWN("Unknown");

        private String value;

        private ActionTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ActionTypeEnum fromValue(String text) {
            for (ActionTypeEnum b : ActionTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ActionTypeEnum> {
            public void write(JsonWriter jsonWriter, ActionTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ActionTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ActionTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

