/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.ImageExportOptionsBase;
import com.aspose.slides.model.SlidesLayoutOptions;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Provides options that control how a presentation is saved in an image format.")
public class ImageExportOptions
extends ImageExportOptionsBase {
    @SerializedName(value="showHiddenSlides", alternate={"ShowHiddenSlides"})
    private Boolean showHiddenSlides;
    @SerializedName(value="slidesLayoutOptions", alternate={"SlidesLayoutOptions"})
    private SlidesLayoutOptions slidesLayoutOptions;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public ImageExportOptions() {
        this.setFormat("IMAGE");
    }

    public ImageExportOptions showHiddenSlides(Boolean showHiddenSlides) {
        this.showHiddenSlides = showHiddenSlides;
        return this;
    }

    @ApiModelProperty(value="Show hidden slides. If true, hidden are exported.")
    public Boolean isShowHiddenSlides() {
        return this.showHiddenSlides;
    }

    public void setShowHiddenSlides(Boolean showHiddenSlides) {
        this.showHiddenSlides = showHiddenSlides;
    }

    public ImageExportOptions slidesLayoutOptions(SlidesLayoutOptions slidesLayoutOptions) {
        this.slidesLayoutOptions = slidesLayoutOptions;
        return this;
    }

    @ApiModelProperty(value="Slides layouting options")
    public SlidesLayoutOptions getSlidesLayoutOptions() {
        return this.slidesLayoutOptions;
    }

    public void setSlidesLayoutOptions(SlidesLayoutOptions slidesLayoutOptions) {
        this.slidesLayoutOptions = slidesLayoutOptions;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageExportOptions imageExportOptions = (ImageExportOptions)o;
        return Objects.equals(this.showHiddenSlides, imageExportOptions.showHiddenSlides) && Objects.equals(this.slidesLayoutOptions, imageExportOptions.slidesLayoutOptions) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.showHiddenSlides, this.slidesLayoutOptions, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ImageExportOptions {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    showHiddenSlides: ").append(this.toIndentedString(this.showHiddenSlides)).append("\n");
        sb.append("    slidesLayoutOptions: ").append(this.toIndentedString(this.slidesLayoutOptions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

