/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.ResourceBase;
import com.aspose.slides.model.ResourceUri;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Layout slide.")
public class LayoutSlide
extends ResourceBase {
    @SerializedName(value="name", alternate={"Name"})
    private String name;
    @SerializedName(value="type", alternate={"Type"})
    private TypeEnum type;
    @SerializedName(value="masterSlide", alternate={"MasterSlide"})
    private ResourceUri masterSlide;
    @SerializedName(value="dependingSlides", alternate={"DependingSlides"})
    private List<ResourceUri> dependingSlides = null;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public LayoutSlide name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LayoutSlide type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="Layout slide type.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public LayoutSlide masterSlide(ResourceUri masterSlide) {
        this.masterSlide = masterSlide;
        return this;
    }

    @ApiModelProperty(value="Master slide link.")
    public ResourceUri getMasterSlide() {
        return this.masterSlide;
    }

    public void setMasterSlide(ResourceUri masterSlide) {
        this.masterSlide = masterSlide;
    }

    public LayoutSlide dependingSlides(List<ResourceUri> dependingSlides) {
        this.dependingSlides = dependingSlides;
        return this;
    }

    public LayoutSlide addDependingSlidesItem(ResourceUri dependingSlidesItem) {
        if (this.dependingSlides == null) {
            this.dependingSlides = new ArrayList<ResourceUri>();
        }
        this.dependingSlides.add(dependingSlidesItem);
        return this;
    }

    @ApiModelProperty(value="List of depending slides.")
    public List<ResourceUri> getDependingSlides() {
        return this.dependingSlides;
    }

    public void setDependingSlides(List<ResourceUri> dependingSlides) {
        this.dependingSlides = dependingSlides;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LayoutSlide layoutSlide = (LayoutSlide)o;
        return Objects.equals(this.name, layoutSlide.name) && Objects.equals((Object)this.type, (Object)layoutSlide.type) && Objects.equals(this.masterSlide, layoutSlide.masterSlide) && Objects.equals(this.dependingSlides, layoutSlide.dependingSlides) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.masterSlide, this.dependingSlides, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LayoutSlide {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    masterSlide: ").append(this.toIndentedString(this.masterSlide)).append("\n");
        sb.append("    dependingSlides: ").append(this.toIndentedString(this.dependingSlides)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        TITLE("Title"),
        TEXT("Text"),
        TWOCOLUMNTEXT("TwoColumnText"),
        TABLE("Table"),
        TEXTANDCHART("TextAndChart"),
        CHARTANDTEXT("ChartAndText"),
        DIAGRAM("Diagram"),
        CHART("Chart"),
        TEXTANDCLIPART("TextAndClipArt"),
        CLIPARTANDTEXT("ClipArtAndText"),
        TITLEONLY("TitleOnly"),
        BLANK("Blank"),
        TEXTANDOBJECT("TextAndObject"),
        OBJECTANDTEXT("ObjectAndText"),
        OBJECT("Object"),
        TITLEANDOBJECT("TitleAndObject"),
        TEXTANDMEDIA("TextAndMedia"),
        MEDIAANDTEXT("MediaAndText"),
        OBJECTOVERTEXT("ObjectOverText"),
        TEXTOVEROBJECT("TextOverObject"),
        TEXTANDTWOOBJECTS("TextAndTwoObjects"),
        TWOOBJECTSANDTEXT("TwoObjectsAndText"),
        TWOOBJECTSOVERTEXT("TwoObjectsOverText"),
        FOUROBJECTS("FourObjects"),
        VERTICALTEXT("VerticalText"),
        CLIPARTANDVERTICALTEXT("ClipArtAndVerticalText"),
        VERTICALTITLEANDTEXT("VerticalTitleAndText"),
        VERTICALTITLEANDTEXTOVERCHART("VerticalTitleAndTextOverChart"),
        TWOOBJECTS("TwoObjects"),
        OBJECTANDTWOOBJECT("ObjectAndTwoObject"),
        TWOOBJECTSANDOBJECT("TwoObjectsAndObject"),
        SECTIONHEADER("SectionHeader"),
        TWOTEXTANDTWOOBJECTS("TwoTextAndTwoObjects"),
        TITLEOBJECTANDCAPTION("TitleObjectAndCaption"),
        PICTUREANDCAPTION("PictureAndCaption"),
        CUSTOM("Custom");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

