/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.EffectFormat;
import com.aspose.slides.model.FillFormat;
import com.aspose.slides.model.LineFormat;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Represents a chart legend")
public class Legend {
    @SerializedName(value="position", alternate={"Position"})
    private PositionEnum position;
    @SerializedName(value="x", alternate={"X"})
    private Double x;
    @SerializedName(value="y", alternate={"Y"})
    private Double y;
    @SerializedName(value="width", alternate={"Width"})
    private Double width;
    @SerializedName(value="height", alternate={"Height"})
    private Double height;
    @SerializedName(value="overlay", alternate={"Overlay"})
    private Boolean overlay;
    @SerializedName(value="fillFormat", alternate={"FillFormat"})
    private FillFormat fillFormat;
    @SerializedName(value="effectFormat", alternate={"EffectFormat"})
    private EffectFormat effectFormat;
    @SerializedName(value="lineFormat", alternate={"LineFormat"})
    private LineFormat lineFormat;
    @SerializedName(value="hasLegend", alternate={"HasLegend"})
    private Boolean hasLegend;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public Legend position(PositionEnum position) {
        this.position = position;
        return this;
    }

    @ApiModelProperty(value="position")
    public PositionEnum getPosition() {
        return this.position;
    }

    public void setPosition(PositionEnum position) {
        this.position = position;
    }

    public Legend x(Double x) {
        this.x = x;
        return this;
    }

    @ApiModelProperty(value="the X location")
    public Double getX() {
        return this.x;
    }

    public void setX(Double x) {
        this.x = x;
    }

    public Legend y(Double y) {
        this.y = y;
        return this;
    }

    @ApiModelProperty(value="the Y location")
    public Double getY() {
        return this.y;
    }

    public void setY(Double y) {
        this.y = y;
    }

    public Legend width(Double width) {
        this.width = width;
        return this;
    }

    @ApiModelProperty(value="Width")
    public Double getWidth() {
        return this.width;
    }

    public void setWidth(Double width) {
        this.width = width;
    }

    public Legend height(Double height) {
        this.height = height;
        return this;
    }

    @ApiModelProperty(value="Height")
    public Double getHeight() {
        return this.height;
    }

    public void setHeight(Double height) {
        this.height = height;
    }

    public Legend overlay(Boolean overlay) {
        this.overlay = overlay;
        return this;
    }

    @ApiModelProperty(value="true if other elements are allowed to overlay the legend")
    public Boolean isOverlay() {
        return this.overlay;
    }

    public void setOverlay(Boolean overlay) {
        this.overlay = overlay;
    }

    public Legend fillFormat(FillFormat fillFormat) {
        this.fillFormat = fillFormat;
        return this;
    }

    @ApiModelProperty(value="Get or sets the fill format.")
    public FillFormat getFillFormat() {
        return this.fillFormat;
    }

    public void setFillFormat(FillFormat fillFormat) {
        this.fillFormat = fillFormat;
    }

    public Legend effectFormat(EffectFormat effectFormat) {
        this.effectFormat = effectFormat;
        return this;
    }

    @ApiModelProperty(value="Get or sets the effect format.")
    public EffectFormat getEffectFormat() {
        return this.effectFormat;
    }

    public void setEffectFormat(EffectFormat effectFormat) {
        this.effectFormat = effectFormat;
    }

    public Legend lineFormat(LineFormat lineFormat) {
        this.lineFormat = lineFormat;
        return this;
    }

    @ApiModelProperty(value="Get or sets the line format.")
    public LineFormat getLineFormat() {
        return this.lineFormat;
    }

    public void setLineFormat(LineFormat lineFormat) {
        this.lineFormat = lineFormat;
    }

    public Legend hasLegend(Boolean hasLegend) {
        this.hasLegend = hasLegend;
        return this;
    }

    @ApiModelProperty(value="Get or sets value determines the visibility of legend")
    public Boolean isHasLegend() {
        return this.hasLegend;
    }

    public void setHasLegend(Boolean hasLegend) {
        this.hasLegend = hasLegend;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Legend legend = (Legend)o;
        return Objects.equals((Object)this.position, (Object)legend.position) && Objects.equals(this.x, legend.x) && Objects.equals(this.y, legend.y) && Objects.equals(this.width, legend.width) && Objects.equals(this.height, legend.height) && Objects.equals(this.overlay, legend.overlay) && Objects.equals(this.fillFormat, legend.fillFormat) && Objects.equals(this.effectFormat, legend.effectFormat) && Objects.equals(this.lineFormat, legend.lineFormat) && Objects.equals(this.hasLegend, legend.hasLegend);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.position, this.x, this.y, this.width, this.height, this.overlay, this.fillFormat, this.effectFormat, this.lineFormat, this.hasLegend});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Legend {\n");
        sb.append("    position: ").append(this.toIndentedString((Object)this.position)).append("\n");
        sb.append("    x: ").append(this.toIndentedString(this.x)).append("\n");
        sb.append("    y: ").append(this.toIndentedString(this.y)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    overlay: ").append(this.toIndentedString(this.overlay)).append("\n");
        sb.append("    fillFormat: ").append(this.toIndentedString(this.fillFormat)).append("\n");
        sb.append("    effectFormat: ").append(this.toIndentedString(this.effectFormat)).append("\n");
        sb.append("    lineFormat: ").append(this.toIndentedString(this.lineFormat)).append("\n");
        sb.append("    hasLegend: ").append(this.toIndentedString(this.hasLegend)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PositionEnum {
        BOTTOM("Bottom"),
        LEFT("Left"),
        RIGHT("Right"),
        TOP("Top"),
        TOPRIGHT("TopRight");

        private String value;

        private PositionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PositionEnum fromValue(String text) {
            for (PositionEnum b : PositionEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<PositionEnum> {
            public void write(JsonWriter jsonWriter, PositionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PositionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PositionEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

