/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.ExportOptions;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Provides options that control how a presentation is saved in Html5 format.")
public class MarkdownExportOptions
extends ExportOptions {
    @SerializedName(value="exportType", alternate={"ExportType"})
    private ExportTypeEnum exportType;
    @SerializedName(value="flavor", alternate={"Flavor"})
    private FlavorEnum flavor;
    @SerializedName(value="newLineType", alternate={"NewLineType"})
    private NewLineTypeEnum newLineType;
    @SerializedName(value="imagesSaveFolderName", alternate={"ImagesSaveFolderName"})
    private String imagesSaveFolderName;
    @SerializedName(value="showSlideNumber", alternate={"ShowSlideNumber"})
    private Boolean showSlideNumber;
    @SerializedName(value="showComments", alternate={"ShowComments"})
    private Boolean showComments;
    @SerializedName(value="showHiddenSlides", alternate={"ShowHiddenSlides"})
    private Boolean showHiddenSlides;
    @SerializedName(value="removeEmptyLines", alternate={"RemoveEmptyLines"})
    private Boolean removeEmptyLines;
    @SerializedName(value="handleRepeatedSpaces", alternate={"HandleRepeatedSpaces"})
    private HandleRepeatedSpacesEnum handleRepeatedSpaces;
    @SerializedName(value="slideNumberFormat", alternate={"SlideNumberFormat"})
    private String slideNumberFormat;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public MarkdownExportOptions() {
        this.setFormat("MD");
    }

    public MarkdownExportOptions exportType(ExportTypeEnum exportType) {
        this.exportType = exportType;
        return this;
    }

    @ApiModelProperty(value="Specifies markdown specification to convert presentation. Default is TextOnly.")
    public ExportTypeEnum getExportType() {
        return this.exportType;
    }

    public void setExportType(ExportTypeEnum exportType) {
        this.exportType = exportType;
    }

    public MarkdownExportOptions flavor(FlavorEnum flavor) {
        this.flavor = flavor;
        return this;
    }

    @ApiModelProperty(value="Specifies markdown specification to convert presentation. Default is MultiMarkdown.")
    public FlavorEnum getFlavor() {
        return this.flavor;
    }

    public void setFlavor(FlavorEnum flavor) {
        this.flavor = flavor;
    }

    public MarkdownExportOptions newLineType(NewLineTypeEnum newLineType) {
        this.newLineType = newLineType;
        return this;
    }

    @ApiModelProperty(value="Specifies whether the generated document should have new lines of \\\\r(Macintosh), \\\\n(Unix) or \\\\r\\\\n(Windows). Default is Unix.")
    public NewLineTypeEnum getNewLineType() {
        return this.newLineType;
    }

    public void setNewLineType(NewLineTypeEnum newLineType) {
        this.newLineType = newLineType;
    }

    public MarkdownExportOptions imagesSaveFolderName(String imagesSaveFolderName) {
        this.imagesSaveFolderName = imagesSaveFolderName;
        return this;
    }

    @ApiModelProperty(value="Specifies folder name to save images. Default is Images. ")
    public String getImagesSaveFolderName() {
        return this.imagesSaveFolderName;
    }

    public void setImagesSaveFolderName(String imagesSaveFolderName) {
        this.imagesSaveFolderName = imagesSaveFolderName;
    }

    public MarkdownExportOptions showSlideNumber(Boolean showSlideNumber) {
        this.showSlideNumber = showSlideNumber;
        return this;
    }

    @ApiModelProperty(value="Specifies whether the generated document should include slide number. Default is false. ")
    public Boolean isShowSlideNumber() {
        return this.showSlideNumber;
    }

    public void setShowSlideNumber(Boolean showSlideNumber) {
        this.showSlideNumber = showSlideNumber;
    }

    public MarkdownExportOptions showComments(Boolean showComments) {
        this.showComments = showComments;
        return this;
    }

    @ApiModelProperty(value="Specifies whether the generated document should include comments. Default is false. ")
    public Boolean isShowComments() {
        return this.showComments;
    }

    public void setShowComments(Boolean showComments) {
        this.showComments = showComments;
    }

    public MarkdownExportOptions showHiddenSlides(Boolean showHiddenSlides) {
        this.showHiddenSlides = showHiddenSlides;
        return this;
    }

    @ApiModelProperty(value="Specifies whether the generated document should include hidden slides. Default is false. ")
    public Boolean isShowHiddenSlides() {
        return this.showHiddenSlides;
    }

    public void setShowHiddenSlides(Boolean showHiddenSlides) {
        this.showHiddenSlides = showHiddenSlides;
    }

    public MarkdownExportOptions removeEmptyLines(Boolean removeEmptyLines) {
        this.removeEmptyLines = removeEmptyLines;
        return this;
    }

    @ApiModelProperty(value="true to remove empty or whitespace-only lines from the final Markdown output. Default is false. ")
    public Boolean isRemoveEmptyLines() {
        return this.removeEmptyLines;
    }

    public void setRemoveEmptyLines(Boolean removeEmptyLines) {
        this.removeEmptyLines = removeEmptyLines;
    }

    public MarkdownExportOptions handleRepeatedSpaces(HandleRepeatedSpacesEnum handleRepeatedSpaces) {
        this.handleRepeatedSpaces = handleRepeatedSpaces;
        return this;
    }

    @ApiModelProperty(value="Specifies how repeated space characters are preserved to maintain visual alignment. ")
    public HandleRepeatedSpacesEnum getHandleRepeatedSpaces() {
        return this.handleRepeatedSpaces;
    }

    public void setHandleRepeatedSpaces(HandleRepeatedSpacesEnum handleRepeatedSpaces) {
        this.handleRepeatedSpaces = handleRepeatedSpaces;
    }

    public MarkdownExportOptions slideNumberFormat(String slideNumberFormat) {
        this.slideNumberFormat = slideNumberFormat;
        return this;
    }

    @ApiModelProperty(value="The format of slide number headers. ")
    public String getSlideNumberFormat() {
        return this.slideNumberFormat;
    }

    public void setSlideNumberFormat(String slideNumberFormat) {
        this.slideNumberFormat = slideNumberFormat;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarkdownExportOptions markdownExportOptions = (MarkdownExportOptions)o;
        return Objects.equals((Object)this.exportType, (Object)markdownExportOptions.exportType) && Objects.equals((Object)this.flavor, (Object)markdownExportOptions.flavor) && Objects.equals((Object)this.newLineType, (Object)markdownExportOptions.newLineType) && Objects.equals(this.imagesSaveFolderName, markdownExportOptions.imagesSaveFolderName) && Objects.equals(this.showSlideNumber, markdownExportOptions.showSlideNumber) && Objects.equals(this.showComments, markdownExportOptions.showComments) && Objects.equals(this.showHiddenSlides, markdownExportOptions.showHiddenSlides) && Objects.equals(this.removeEmptyLines, markdownExportOptions.removeEmptyLines) && Objects.equals((Object)this.handleRepeatedSpaces, (Object)markdownExportOptions.handleRepeatedSpaces) && Objects.equals(this.slideNumberFormat, markdownExportOptions.slideNumberFormat) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.exportType, this.flavor, this.newLineType, this.imagesSaveFolderName, this.showSlideNumber, this.showComments, this.showHiddenSlides, this.removeEmptyLines, this.handleRepeatedSpaces, this.slideNumberFormat, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MarkdownExportOptions {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    exportType: ").append(this.toIndentedString((Object)this.exportType)).append("\n");
        sb.append("    flavor: ").append(this.toIndentedString((Object)this.flavor)).append("\n");
        sb.append("    newLineType: ").append(this.toIndentedString((Object)this.newLineType)).append("\n");
        sb.append("    imagesSaveFolderName: ").append(this.toIndentedString(this.imagesSaveFolderName)).append("\n");
        sb.append("    showSlideNumber: ").append(this.toIndentedString(this.showSlideNumber)).append("\n");
        sb.append("    showComments: ").append(this.toIndentedString(this.showComments)).append("\n");
        sb.append("    showHiddenSlides: ").append(this.toIndentedString(this.showHiddenSlides)).append("\n");
        sb.append("    removeEmptyLines: ").append(this.toIndentedString(this.removeEmptyLines)).append("\n");
        sb.append("    handleRepeatedSpaces: ").append(this.toIndentedString((Object)this.handleRepeatedSpaces)).append("\n");
        sb.append("    slideNumberFormat: ").append(this.toIndentedString(this.slideNumberFormat)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum HandleRepeatedSpacesEnum {
        NONE("None"),
        ALTERNATESPACESTONBSP("AlternateSpacesToNbsp"),
        MULTIPLESPACESTONBSP("MultipleSpacesToNbsp");

        private String value;

        private HandleRepeatedSpacesEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static HandleRepeatedSpacesEnum fromValue(String text) {
            for (HandleRepeatedSpacesEnum b : HandleRepeatedSpacesEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<HandleRepeatedSpacesEnum> {
            public void write(JsonWriter jsonWriter, HandleRepeatedSpacesEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public HandleRepeatedSpacesEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return HandleRepeatedSpacesEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum NewLineTypeEnum {
        WINDOWS("Windows"),
        UNIX("Unix"),
        MAC("Mac");

        private String value;

        private NewLineTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static NewLineTypeEnum fromValue(String text) {
            for (NewLineTypeEnum b : NewLineTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<NewLineTypeEnum> {
            public void write(JsonWriter jsonWriter, NewLineTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public NewLineTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return NewLineTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum FlavorEnum {
        GITHUB("Github"),
        GRUBER("Gruber"),
        MULTIMARKDOWN("MultiMarkdown"),
        COMMONMARK("CommonMark"),
        MARKDOWNEXTRA("MarkdownExtra"),
        PANDOC("Pandoc"),
        KRAMDOWN("Kramdown"),
        MARKUA("Markua"),
        MARUKU("Maruku"),
        MARKDOWN2("Markdown2"),
        REMARKABLE("Remarkable"),
        SHOWDOWN("Showdown"),
        GHOST("Ghost"),
        GITLAB("GitLab"),
        HAROOPAD("Haroopad"),
        IAWRITER("IaWriter"),
        REDCARPET("Redcarpet"),
        SCHOLARLYMARKDOWN("ScholarlyMarkdown"),
        TAIGA("Taiga"),
        TRELLO("Trello"),
        S9ETEXTFORMATTER("S9ETextFormatter"),
        XWIKI("XWiki"),
        STACKOVERFLOW("StackOverflow"),
        DEFAULT("Default");

        private String value;

        private FlavorEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static FlavorEnum fromValue(String text) {
            for (FlavorEnum b : FlavorEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<FlavorEnum> {
            public void write(JsonWriter jsonWriter, FlavorEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public FlavorEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return FlavorEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ExportTypeEnum {
        SEQUENTIAL("Sequential"),
        TEXTONLY("TextOnly"),
        VISUAL("Visual");

        private String value;

        private ExportTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ExportTypeEnum fromValue(String text) {
            for (ExportTypeEnum b : ExportTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ExportTypeEnum> {
            public void write(JsonWriter jsonWriter, ExportTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ExportTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ExportTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

