/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.BlockElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Mathematical paragraph that is a container for mathematical blocks")
public class MathParagraph {
    @SerializedName(value="mathBlockList", alternate={"MathBlockList"})
    private List<BlockElement> mathBlockList = null;
    @SerializedName(value="justification", alternate={"Justification"})
    private JustificationEnum justification;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public MathParagraph mathBlockList(List<BlockElement> mathBlockList) {
        this.mathBlockList = mathBlockList;
        return this;
    }

    public MathParagraph addMathBlockListItem(BlockElement mathBlockListItem) {
        if (this.mathBlockList == null) {
            this.mathBlockList = new ArrayList<BlockElement>();
        }
        this.mathBlockList.add(mathBlockListItem);
        return this;
    }

    @ApiModelProperty(value="List of math blocks")
    public List<BlockElement> getMathBlockList() {
        return this.mathBlockList;
    }

    public void setMathBlockList(List<BlockElement> mathBlockList) {
        this.mathBlockList = mathBlockList;
    }

    public MathParagraph justification(JustificationEnum justification) {
        this.justification = justification;
        return this;
    }

    @ApiModelProperty(value="Justification of the math paragraph")
    public JustificationEnum getJustification() {
        return this.justification;
    }

    public void setJustification(JustificationEnum justification) {
        this.justification = justification;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MathParagraph mathParagraph = (MathParagraph)o;
        return Objects.equals(this.mathBlockList, mathParagraph.mathBlockList) && Objects.equals((Object)this.justification, (Object)mathParagraph.justification);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mathBlockList, this.justification});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MathParagraph {\n");
        sb.append("    mathBlockList: ").append(this.toIndentedString(this.mathBlockList)).append("\n");
        sb.append("    justification: ").append(this.toIndentedString((Object)this.justification)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum JustificationEnum {
        LEFTJUSTIFIED("LeftJustified"),
        RIGHTJUSTIFIED("RightJustified"),
        CENTERED("Centered"),
        CENTEREDASGROUP("CenteredAsGroup");

        private String value;

        private JustificationEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static JustificationEnum fromValue(String text) {
            for (JustificationEnum b : JustificationEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<JustificationEnum> {
            public void write(JsonWriter jsonWriter, JustificationEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public JustificationEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return JustificationEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

