/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.MathElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Specifies an N-ary mathematical object, such as Summation and Integral.")
public class NaryOperatorElement
extends MathElement {
    @SerializedName(value="base", alternate={"Base"})
    private MathElement base;
    @SerializedName(value="subscript", alternate={"Subscript"})
    private MathElement subscript;
    @SerializedName(value="superscript", alternate={"Superscript"})
    private MathElement superscript;
    @SerializedName(value="operator", alternate={"Operator"})
    private String operator;
    @SerializedName(value="limitLocation", alternate={"LimitLocation"})
    private LimitLocationEnum limitLocation;
    @SerializedName(value="growToMatchOperandHeight", alternate={"GrowToMatchOperandHeight"})
    private Boolean growToMatchOperandHeight;
    @SerializedName(value="hideSubscript", alternate={"HideSubscript"})
    private Boolean hideSubscript;
    @SerializedName(value="hideSuperscript", alternate={"HideSuperscript"})
    private Boolean hideSuperscript;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public NaryOperatorElement() {
        this.setType(MathElement.TypeEnum.NARYOPERATOR);
    }

    public NaryOperatorElement base(MathElement base) {
        this.base = base;
        return this;
    }

    @ApiModelProperty(value="Base argument")
    public MathElement getBase() {
        return this.base;
    }

    public void setBase(MathElement base) {
        this.base = base;
    }

    public NaryOperatorElement subscript(MathElement subscript) {
        this.subscript = subscript;
        return this;
    }

    @ApiModelProperty(value="Subscript argument")
    public MathElement getSubscript() {
        return this.subscript;
    }

    public void setSubscript(MathElement subscript) {
        this.subscript = subscript;
    }

    public NaryOperatorElement superscript(MathElement superscript) {
        this.superscript = superscript;
        return this;
    }

    @ApiModelProperty(value="Superscript argument")
    public MathElement getSuperscript() {
        return this.superscript;
    }

    public void setSuperscript(MathElement superscript) {
        this.superscript = superscript;
    }

    public NaryOperatorElement operator(String operator) {
        this.operator = operator;
        return this;
    }

    @ApiModelProperty(value="Nary Operator Character")
    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public NaryOperatorElement limitLocation(LimitLocationEnum limitLocation) {
        this.limitLocation = limitLocation;
        return this;
    }

    @ApiModelProperty(value="The location of limits (subscript and superscript)")
    public LimitLocationEnum getLimitLocation() {
        return this.limitLocation;
    }

    public void setLimitLocation(LimitLocationEnum limitLocation) {
        this.limitLocation = limitLocation;
    }

    public NaryOperatorElement growToMatchOperandHeight(Boolean growToMatchOperandHeight) {
        this.growToMatchOperandHeight = growToMatchOperandHeight;
        return this;
    }

    @ApiModelProperty(value="Operator Character grows vertically to match its operand height")
    public Boolean isGrowToMatchOperandHeight() {
        return this.growToMatchOperandHeight;
    }

    public void setGrowToMatchOperandHeight(Boolean growToMatchOperandHeight) {
        this.growToMatchOperandHeight = growToMatchOperandHeight;
    }

    public NaryOperatorElement hideSubscript(Boolean hideSubscript) {
        this.hideSubscript = hideSubscript;
        return this;
    }

    @ApiModelProperty(value="Hide Subscript")
    public Boolean isHideSubscript() {
        return this.hideSubscript;
    }

    public void setHideSubscript(Boolean hideSubscript) {
        this.hideSubscript = hideSubscript;
    }

    public NaryOperatorElement hideSuperscript(Boolean hideSuperscript) {
        this.hideSuperscript = hideSuperscript;
        return this;
    }

    @ApiModelProperty(value="Hide Superscript")
    public Boolean isHideSuperscript() {
        return this.hideSuperscript;
    }

    public void setHideSuperscript(Boolean hideSuperscript) {
        this.hideSuperscript = hideSuperscript;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NaryOperatorElement naryOperatorElement = (NaryOperatorElement)o;
        return Objects.equals(this.base, naryOperatorElement.base) && Objects.equals(this.subscript, naryOperatorElement.subscript) && Objects.equals(this.superscript, naryOperatorElement.superscript) && Objects.equals(this.operator, naryOperatorElement.operator) && Objects.equals((Object)this.limitLocation, (Object)naryOperatorElement.limitLocation) && Objects.equals(this.growToMatchOperandHeight, naryOperatorElement.growToMatchOperandHeight) && Objects.equals(this.hideSubscript, naryOperatorElement.hideSubscript) && Objects.equals(this.hideSuperscript, naryOperatorElement.hideSuperscript) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.base, this.subscript, this.superscript, this.operator, this.limitLocation, this.growToMatchOperandHeight, this.hideSubscript, this.hideSuperscript, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NaryOperatorElement {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    base: ").append(this.toIndentedString(this.base)).append("\n");
        sb.append("    subscript: ").append(this.toIndentedString(this.subscript)).append("\n");
        sb.append("    superscript: ").append(this.toIndentedString(this.superscript)).append("\n");
        sb.append("    operator: ").append(this.toIndentedString(this.operator)).append("\n");
        sb.append("    limitLocation: ").append(this.toIndentedString((Object)this.limitLocation)).append("\n");
        sb.append("    growToMatchOperandHeight: ").append(this.toIndentedString(this.growToMatchOperandHeight)).append("\n");
        sb.append("    hideSubscript: ").append(this.toIndentedString(this.hideSubscript)).append("\n");
        sb.append("    hideSuperscript: ").append(this.toIndentedString(this.hideSuperscript)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    static {
        typeDeterminers.put("Type", (Object)MathElement.TypeEnum.NARYOPERATOR);
    }

    @JsonAdapter(value=Adapter.class)
    public static enum LimitLocationEnum {
        NOTDEFINED("NotDefined"),
        UNDEROVER("UnderOver"),
        SUBSCRIPTSUPERSCRIPT("SubscriptSuperscript");

        private String value;

        private LimitLocationEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static LimitLocationEnum fromValue(String text) {
            for (LimitLocationEnum b : LimitLocationEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<LimitLocationEnum> {
            public void write(JsonWriter jsonWriter, LimitLocationEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public LimitLocationEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return LimitLocationEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

