/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.FillFormat;
import com.aspose.slides.model.Portion;
import com.aspose.slides.model.PortionFormat;
import com.aspose.slides.model.ResourceBase;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Represents paragraph resource")
public class Paragraph
extends ResourceBase {
    @SerializedName(value="marginLeft", alternate={"MarginLeft"})
    private Double marginLeft;
    @SerializedName(value="marginRight", alternate={"MarginRight"})
    private Double marginRight;
    @SerializedName(value="spaceBefore", alternate={"SpaceBefore"})
    private Double spaceBefore;
    @SerializedName(value="spaceAfter", alternate={"SpaceAfter"})
    private Double spaceAfter;
    @SerializedName(value="spaceWithin", alternate={"SpaceWithin"})
    private Double spaceWithin;
    @SerializedName(value="indent", alternate={"Indent"})
    private Double indent;
    @SerializedName(value="alignment", alternate={"Alignment"})
    private AlignmentEnum alignment;
    @SerializedName(value="fontAlignment", alternate={"FontAlignment"})
    private FontAlignmentEnum fontAlignment;
    @SerializedName(value="defaultTabSize", alternate={"DefaultTabSize"})
    private Double defaultTabSize;
    @SerializedName(value="depth", alternate={"Depth"})
    private Integer depth;
    @SerializedName(value="hangingPunctuation", alternate={"HangingPunctuation"})
    private HangingPunctuationEnum hangingPunctuation;
    @SerializedName(value="eastAsianLineBreak", alternate={"EastAsianLineBreak"})
    private EastAsianLineBreakEnum eastAsianLineBreak;
    @SerializedName(value="latinLineBreak", alternate={"LatinLineBreak"})
    private LatinLineBreakEnum latinLineBreak;
    @SerializedName(value="rightToLeft", alternate={"RightToLeft"})
    private RightToLeftEnum rightToLeft;
    @SerializedName(value="portionList", alternate={"PortionList"})
    private List<Portion> portionList = null;
    @SerializedName(value="defaultPortionFormat", alternate={"DefaultPortionFormat"})
    private PortionFormat defaultPortionFormat;
    @SerializedName(value="bulletChar", alternate={"BulletChar"})
    private String bulletChar;
    @SerializedName(value="bulletHeight", alternate={"BulletHeight"})
    private Double bulletHeight;
    @SerializedName(value="bulletType", alternate={"BulletType"})
    private BulletTypeEnum bulletType;
    @SerializedName(value="numberedBulletStartWith", alternate={"NumberedBulletStartWith"})
    private Integer numberedBulletStartWith;
    @SerializedName(value="numberedBulletStyle", alternate={"NumberedBulletStyle"})
    private NumberedBulletStyleEnum numberedBulletStyle;
    @SerializedName(value="bulletFillFormat", alternate={"BulletFillFormat"})
    private FillFormat bulletFillFormat;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public Paragraph marginLeft(Double marginLeft) {
        this.marginLeft = marginLeft;
        return this;
    }

    @ApiModelProperty(value="Left margin.")
    public Double getMarginLeft() {
        return this.marginLeft;
    }

    public void setMarginLeft(Double marginLeft) {
        this.marginLeft = marginLeft;
    }

    public Paragraph marginRight(Double marginRight) {
        this.marginRight = marginRight;
        return this;
    }

    @ApiModelProperty(value="Right margin.")
    public Double getMarginRight() {
        return this.marginRight;
    }

    public void setMarginRight(Double marginRight) {
        this.marginRight = marginRight;
    }

    public Paragraph spaceBefore(Double spaceBefore) {
        this.spaceBefore = spaceBefore;
        return this;
    }

    @ApiModelProperty(value="Left spacing.")
    public Double getSpaceBefore() {
        return this.spaceBefore;
    }

    public void setSpaceBefore(Double spaceBefore) {
        this.spaceBefore = spaceBefore;
    }

    public Paragraph spaceAfter(Double spaceAfter) {
        this.spaceAfter = spaceAfter;
        return this;
    }

    @ApiModelProperty(value="Right spacing.")
    public Double getSpaceAfter() {
        return this.spaceAfter;
    }

    public void setSpaceAfter(Double spaceAfter) {
        this.spaceAfter = spaceAfter;
    }

    public Paragraph spaceWithin(Double spaceWithin) {
        this.spaceWithin = spaceWithin;
        return this;
    }

    @ApiModelProperty(value="Spacing between lines.")
    public Double getSpaceWithin() {
        return this.spaceWithin;
    }

    public void setSpaceWithin(Double spaceWithin) {
        this.spaceWithin = spaceWithin;
    }

    public Paragraph indent(Double indent) {
        this.indent = indent;
        return this;
    }

    @ApiModelProperty(value="First line indent.")
    public Double getIndent() {
        return this.indent;
    }

    public void setIndent(Double indent) {
        this.indent = indent;
    }

    public Paragraph alignment(AlignmentEnum alignment) {
        this.alignment = alignment;
        return this;
    }

    @ApiModelProperty(value="Text alignment.")
    public AlignmentEnum getAlignment() {
        return this.alignment;
    }

    public void setAlignment(AlignmentEnum alignment) {
        this.alignment = alignment;
    }

    public Paragraph fontAlignment(FontAlignmentEnum fontAlignment) {
        this.fontAlignment = fontAlignment;
        return this;
    }

    @ApiModelProperty(value="Font alignment.")
    public FontAlignmentEnum getFontAlignment() {
        return this.fontAlignment;
    }

    public void setFontAlignment(FontAlignmentEnum fontAlignment) {
        this.fontAlignment = fontAlignment;
    }

    public Paragraph defaultTabSize(Double defaultTabSize) {
        this.defaultTabSize = defaultTabSize;
        return this;
    }

    @ApiModelProperty(value="Default tabulation size.")
    public Double getDefaultTabSize() {
        return this.defaultTabSize;
    }

    public void setDefaultTabSize(Double defaultTabSize) {
        this.defaultTabSize = defaultTabSize;
    }

    public Paragraph depth(Integer depth) {
        this.depth = depth;
        return this;
    }

    @ApiModelProperty(value="Depth.")
    public Integer getDepth() {
        return this.depth;
    }

    public void setDepth(Integer depth) {
        this.depth = depth;
    }

    public Paragraph hangingPunctuation(HangingPunctuationEnum hangingPunctuation) {
        this.hangingPunctuation = hangingPunctuation;
        return this;
    }

    @ApiModelProperty(value="True if hanging punctuation is used with the paragraph.")
    public HangingPunctuationEnum getHangingPunctuation() {
        return this.hangingPunctuation;
    }

    public void setHangingPunctuation(HangingPunctuationEnum hangingPunctuation) {
        this.hangingPunctuation = hangingPunctuation;
    }

    public Paragraph eastAsianLineBreak(EastAsianLineBreakEnum eastAsianLineBreak) {
        this.eastAsianLineBreak = eastAsianLineBreak;
        return this;
    }

    @ApiModelProperty(value="True if East Asian line break is used with the paragraph.")
    public EastAsianLineBreakEnum getEastAsianLineBreak() {
        return this.eastAsianLineBreak;
    }

    public void setEastAsianLineBreak(EastAsianLineBreakEnum eastAsianLineBreak) {
        this.eastAsianLineBreak = eastAsianLineBreak;
    }

    public Paragraph latinLineBreak(LatinLineBreakEnum latinLineBreak) {
        this.latinLineBreak = latinLineBreak;
        return this;
    }

    @ApiModelProperty(value="True if Latin line break is used with the paragraph.")
    public LatinLineBreakEnum getLatinLineBreak() {
        return this.latinLineBreak;
    }

    public void setLatinLineBreak(LatinLineBreakEnum latinLineBreak) {
        this.latinLineBreak = latinLineBreak;
    }

    public Paragraph rightToLeft(RightToLeftEnum rightToLeft) {
        this.rightToLeft = rightToLeft;
        return this;
    }

    @ApiModelProperty(value="True if right to left direction is used with the paragraph.")
    public RightToLeftEnum getRightToLeft() {
        return this.rightToLeft;
    }

    public void setRightToLeft(RightToLeftEnum rightToLeft) {
        this.rightToLeft = rightToLeft;
    }

    public Paragraph portionList(List<Portion> portionList) {
        this.portionList = portionList;
        return this;
    }

    public Paragraph addPortionListItem(Portion portionListItem) {
        if (this.portionList == null) {
            this.portionList = new ArrayList<Portion>();
        }
        this.portionList.add(portionListItem);
        return this;
    }

    @ApiModelProperty(value="List of portion links.")
    public List<Portion> getPortionList() {
        return this.portionList;
    }

    public void setPortionList(List<Portion> portionList) {
        this.portionList = portionList;
    }

    public Paragraph defaultPortionFormat(PortionFormat defaultPortionFormat) {
        this.defaultPortionFormat = defaultPortionFormat;
        return this;
    }

    @ApiModelProperty(value="Default portion format.")
    public PortionFormat getDefaultPortionFormat() {
        return this.defaultPortionFormat;
    }

    public void setDefaultPortionFormat(PortionFormat defaultPortionFormat) {
        this.defaultPortionFormat = defaultPortionFormat;
    }

    public Paragraph bulletChar(String bulletChar) {
        this.bulletChar = bulletChar;
        return this;
    }

    @ApiModelProperty(value="Bullet char.")
    public String getBulletChar() {
        return this.bulletChar;
    }

    public void setBulletChar(String bulletChar) {
        this.bulletChar = bulletChar;
    }

    public Paragraph bulletHeight(Double bulletHeight) {
        this.bulletHeight = bulletHeight;
        return this;
    }

    @ApiModelProperty(value="Bullet height.")
    public Double getBulletHeight() {
        return this.bulletHeight;
    }

    public void setBulletHeight(Double bulletHeight) {
        this.bulletHeight = bulletHeight;
    }

    public Paragraph bulletType(BulletTypeEnum bulletType) {
        this.bulletType = bulletType;
        return this;
    }

    @ApiModelProperty(value="Bullet type.")
    public BulletTypeEnum getBulletType() {
        return this.bulletType;
    }

    public void setBulletType(BulletTypeEnum bulletType) {
        this.bulletType = bulletType;
    }

    public Paragraph numberedBulletStartWith(Integer numberedBulletStartWith) {
        this.numberedBulletStartWith = numberedBulletStartWith;
        return this;
    }

    @ApiModelProperty(value="Starting number for a numbered bullet.")
    public Integer getNumberedBulletStartWith() {
        return this.numberedBulletStartWith;
    }

    public void setNumberedBulletStartWith(Integer numberedBulletStartWith) {
        this.numberedBulletStartWith = numberedBulletStartWith;
    }

    public Paragraph numberedBulletStyle(NumberedBulletStyleEnum numberedBulletStyle) {
        this.numberedBulletStyle = numberedBulletStyle;
        return this;
    }

    @ApiModelProperty(value="Numbered bullet style.")
    public NumberedBulletStyleEnum getNumberedBulletStyle() {
        return this.numberedBulletStyle;
    }

    public void setNumberedBulletStyle(NumberedBulletStyleEnum numberedBulletStyle) {
        this.numberedBulletStyle = numberedBulletStyle;
    }

    public Paragraph bulletFillFormat(FillFormat bulletFillFormat) {
        this.bulletFillFormat = bulletFillFormat;
        return this;
    }

    @ApiModelProperty(value="Bullet fill format.")
    public FillFormat getBulletFillFormat() {
        return this.bulletFillFormat;
    }

    public void setBulletFillFormat(FillFormat bulletFillFormat) {
        this.bulletFillFormat = bulletFillFormat;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Paragraph paragraph = (Paragraph)o;
        return Objects.equals(this.marginLeft, paragraph.marginLeft) && Objects.equals(this.marginRight, paragraph.marginRight) && Objects.equals(this.spaceBefore, paragraph.spaceBefore) && Objects.equals(this.spaceAfter, paragraph.spaceAfter) && Objects.equals(this.spaceWithin, paragraph.spaceWithin) && Objects.equals(this.indent, paragraph.indent) && Objects.equals((Object)this.alignment, (Object)paragraph.alignment) && Objects.equals((Object)this.fontAlignment, (Object)paragraph.fontAlignment) && Objects.equals(this.defaultTabSize, paragraph.defaultTabSize) && Objects.equals(this.depth, paragraph.depth) && Objects.equals((Object)this.hangingPunctuation, (Object)paragraph.hangingPunctuation) && Objects.equals((Object)this.eastAsianLineBreak, (Object)paragraph.eastAsianLineBreak) && Objects.equals((Object)this.latinLineBreak, (Object)paragraph.latinLineBreak) && Objects.equals((Object)this.rightToLeft, (Object)paragraph.rightToLeft) && Objects.equals(this.portionList, paragraph.portionList) && Objects.equals(this.defaultPortionFormat, paragraph.defaultPortionFormat) && Objects.equals(this.bulletChar, paragraph.bulletChar) && Objects.equals(this.bulletHeight, paragraph.bulletHeight) && Objects.equals((Object)this.bulletType, (Object)paragraph.bulletType) && Objects.equals(this.numberedBulletStartWith, paragraph.numberedBulletStartWith) && Objects.equals((Object)this.numberedBulletStyle, (Object)paragraph.numberedBulletStyle) && Objects.equals(this.bulletFillFormat, paragraph.bulletFillFormat) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.marginLeft, this.marginRight, this.spaceBefore, this.spaceAfter, this.spaceWithin, this.indent, this.alignment, this.fontAlignment, this.defaultTabSize, this.depth, this.hangingPunctuation, this.eastAsianLineBreak, this.latinLineBreak, this.rightToLeft, this.portionList, this.defaultPortionFormat, this.bulletChar, this.bulletHeight, this.bulletType, this.numberedBulletStartWith, this.numberedBulletStyle, this.bulletFillFormat, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Paragraph {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    marginLeft: ").append(this.toIndentedString(this.marginLeft)).append("\n");
        sb.append("    marginRight: ").append(this.toIndentedString(this.marginRight)).append("\n");
        sb.append("    spaceBefore: ").append(this.toIndentedString(this.spaceBefore)).append("\n");
        sb.append("    spaceAfter: ").append(this.toIndentedString(this.spaceAfter)).append("\n");
        sb.append("    spaceWithin: ").append(this.toIndentedString(this.spaceWithin)).append("\n");
        sb.append("    indent: ").append(this.toIndentedString(this.indent)).append("\n");
        sb.append("    alignment: ").append(this.toIndentedString((Object)this.alignment)).append("\n");
        sb.append("    fontAlignment: ").append(this.toIndentedString((Object)this.fontAlignment)).append("\n");
        sb.append("    defaultTabSize: ").append(this.toIndentedString(this.defaultTabSize)).append("\n");
        sb.append("    depth: ").append(this.toIndentedString(this.depth)).append("\n");
        sb.append("    hangingPunctuation: ").append(this.toIndentedString((Object)this.hangingPunctuation)).append("\n");
        sb.append("    eastAsianLineBreak: ").append(this.toIndentedString((Object)this.eastAsianLineBreak)).append("\n");
        sb.append("    latinLineBreak: ").append(this.toIndentedString((Object)this.latinLineBreak)).append("\n");
        sb.append("    rightToLeft: ").append(this.toIndentedString((Object)this.rightToLeft)).append("\n");
        sb.append("    portionList: ").append(this.toIndentedString(this.portionList)).append("\n");
        sb.append("    defaultPortionFormat: ").append(this.toIndentedString(this.defaultPortionFormat)).append("\n");
        sb.append("    bulletChar: ").append(this.toIndentedString(this.bulletChar)).append("\n");
        sb.append("    bulletHeight: ").append(this.toIndentedString(this.bulletHeight)).append("\n");
        sb.append("    bulletType: ").append(this.toIndentedString((Object)this.bulletType)).append("\n");
        sb.append("    numberedBulletStartWith: ").append(this.toIndentedString(this.numberedBulletStartWith)).append("\n");
        sb.append("    numberedBulletStyle: ").append(this.toIndentedString((Object)this.numberedBulletStyle)).append("\n");
        sb.append("    bulletFillFormat: ").append(this.toIndentedString(this.bulletFillFormat)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum NumberedBulletStyleEnum {
        BULLETALPHALCPERIOD("BulletAlphaLCPeriod"),
        BULLETALPHAUCPERIOD("BulletAlphaUCPeriod"),
        BULLETARABICPARENRIGHT("BulletArabicParenRight"),
        BULLETARABICPERIOD("BulletArabicPeriod"),
        BULLETROMANLCPARENBOTH("BulletRomanLCParenBoth"),
        BULLETROMANLCPARENRIGHT("BulletRomanLCParenRight"),
        BULLETROMANLCPERIOD("BulletRomanLCPeriod"),
        BULLETROMANUCPERIOD("BulletRomanUCPeriod"),
        BULLETALPHALCPARENBOTH("BulletAlphaLCParenBoth"),
        BULLETALPHALCPARENRIGHT("BulletAlphaLCParenRight"),
        BULLETALPHAUCPARENBOTH("BulletAlphaUCParenBoth"),
        BULLETALPHAUCPARENRIGHT("BulletAlphaUCParenRight"),
        BULLETARABICPARENBOTH("BulletArabicParenBoth"),
        BULLETARABICPLAIN("BulletArabicPlain"),
        BULLETROMANUCPARENBOTH("BulletRomanUCParenBoth"),
        BULLETROMANUCPARENRIGHT("BulletRomanUCParenRight"),
        BULLETSIMPCHINPLAIN("BulletSimpChinPlain"),
        BULLETSIMPCHINPERIOD("BulletSimpChinPeriod"),
        BULLETCIRCLENUMDBPLAIN("BulletCircleNumDBPlain"),
        BULLETCIRCLENUMWDWHITEPLAIN("BulletCircleNumWDWhitePlain"),
        BULLETCIRCLENUMWDBLACKPLAIN("BulletCircleNumWDBlackPlain"),
        BULLETTRADCHINPLAIN("BulletTradChinPlain"),
        BULLETTRADCHINPERIOD("BulletTradChinPeriod"),
        BULLETARABICALPHADASH("BulletArabicAlphaDash"),
        BULLETARABICABJADDASH("BulletArabicAbjadDash"),
        BULLETHEBREWALPHADASH("BulletHebrewAlphaDash"),
        BULLETKANJIKOREANPLAIN("BulletKanjiKoreanPlain"),
        BULLETKANJIKOREANPERIOD("BulletKanjiKoreanPeriod"),
        BULLETARABICDBPLAIN("BulletArabicDBPlain"),
        BULLETARABICDBPERIOD("BulletArabicDBPeriod"),
        BULLETTHAIALPHAPERIOD("BulletThaiAlphaPeriod"),
        BULLETTHAIALPHAPARENRIGHT("BulletThaiAlphaParenRight"),
        BULLETTHAIALPHAPARENBOTH("BulletThaiAlphaParenBoth"),
        BULLETTHAINUMPERIOD("BulletThaiNumPeriod"),
        BULLETTHAINUMPARENRIGHT("BulletThaiNumParenRight"),
        BULLETTHAINUMPARENBOTH("BulletThaiNumParenBoth"),
        BULLETHINDIALPHAPERIOD("BulletHindiAlphaPeriod"),
        BULLETHINDINUMPERIOD("BulletHindiNumPeriod"),
        BULLETKANJISIMPCHINDBPERIOD("BulletKanjiSimpChinDBPeriod"),
        BULLETHINDINUMPARENRIGHT("BulletHindiNumParenRight"),
        BULLETHINDIALPHA1PERIOD("BulletHindiAlpha1Period"),
        NOTDEFINED("NotDefined");

        private String value;

        private NumberedBulletStyleEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static NumberedBulletStyleEnum fromValue(String text) {
            for (NumberedBulletStyleEnum b : NumberedBulletStyleEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<NumberedBulletStyleEnum> {
            public void write(JsonWriter jsonWriter, NumberedBulletStyleEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public NumberedBulletStyleEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return NumberedBulletStyleEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum BulletTypeEnum {
        NONE("None"),
        SYMBOL("Symbol"),
        NUMBERED("Numbered"),
        PICTURE("Picture"),
        NOTDEFINED("NotDefined");

        private String value;

        private BulletTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static BulletTypeEnum fromValue(String text) {
            for (BulletTypeEnum b : BulletTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<BulletTypeEnum> {
            public void write(JsonWriter jsonWriter, BulletTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public BulletTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return BulletTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RightToLeftEnum {
        FALSE("False"),
        TRUE("True"),
        NOTDEFINED("NotDefined");

        private String value;

        private RightToLeftEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RightToLeftEnum fromValue(String text) {
            for (RightToLeftEnum b : RightToLeftEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<RightToLeftEnum> {
            public void write(JsonWriter jsonWriter, RightToLeftEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public RightToLeftEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RightToLeftEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum LatinLineBreakEnum {
        FALSE("False"),
        TRUE("True"),
        NOTDEFINED("NotDefined");

        private String value;

        private LatinLineBreakEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static LatinLineBreakEnum fromValue(String text) {
            for (LatinLineBreakEnum b : LatinLineBreakEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<LatinLineBreakEnum> {
            public void write(JsonWriter jsonWriter, LatinLineBreakEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public LatinLineBreakEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return LatinLineBreakEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum EastAsianLineBreakEnum {
        FALSE("False"),
        TRUE("True"),
        NOTDEFINED("NotDefined");

        private String value;

        private EastAsianLineBreakEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static EastAsianLineBreakEnum fromValue(String text) {
            for (EastAsianLineBreakEnum b : EastAsianLineBreakEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<EastAsianLineBreakEnum> {
            public void write(JsonWriter jsonWriter, EastAsianLineBreakEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public EastAsianLineBreakEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return EastAsianLineBreakEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum HangingPunctuationEnum {
        FALSE("False"),
        TRUE("True"),
        NOTDEFINED("NotDefined");

        private String value;

        private HangingPunctuationEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static HangingPunctuationEnum fromValue(String text) {
            for (HangingPunctuationEnum b : HangingPunctuationEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<HangingPunctuationEnum> {
            public void write(JsonWriter jsonWriter, HangingPunctuationEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public HangingPunctuationEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return HangingPunctuationEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum FontAlignmentEnum {
        AUTOMATIC("Automatic"),
        TOP("Top"),
        CENTER("Center"),
        BOTTOM("Bottom"),
        BASELINE("Baseline"),
        DEFAULT("Default");

        private String value;

        private FontAlignmentEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static FontAlignmentEnum fromValue(String text) {
            for (FontAlignmentEnum b : FontAlignmentEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<FontAlignmentEnum> {
            public void write(JsonWriter jsonWriter, FontAlignmentEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public FontAlignmentEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return FontAlignmentEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum AlignmentEnum {
        LEFT("Left"),
        CENTER("Center"),
        RIGHT("Right"),
        JUSTIFY("Justify"),
        JUSTIFYLOW("JustifyLow"),
        DISTRIBUTED("Distributed"),
        NOTDEFINED("NotDefined");

        private String value;

        private AlignmentEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static AlignmentEnum fromValue(String text) {
            for (AlignmentEnum b : AlignmentEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<AlignmentEnum> {
            public void write(JsonWriter jsonWriter, AlignmentEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public AlignmentEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return AlignmentEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

