/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.FillFormat;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Represents Pattern Fill")
public class PatternFill
extends FillFormat {
    @SerializedName(value="backColor", alternate={"BackColor"})
    private String backColor;
    @SerializedName(value="foreColor", alternate={"ForeColor"})
    private String foreColor;
    @SerializedName(value="style", alternate={"Style"})
    private StyleEnum style;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public PatternFill() {
        this.setType(FillFormat.TypeEnum.PATTERN);
    }

    public PatternFill backColor(String backColor) {
        this.backColor = backColor;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the back color of the pattern fill.")
    public String getBackColor() {
        return this.backColor;
    }

    public void setBackColor(String backColor) {
        this.backColor = backColor;
    }

    public PatternFill foreColor(String foreColor) {
        this.foreColor = foreColor;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the fore color of the pattern fill.")
    public String getForeColor() {
        return this.foreColor;
    }

    public void setForeColor(String foreColor) {
        this.foreColor = foreColor;
    }

    public PatternFill style(StyleEnum style) {
        this.style = style;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets the style of pattern fill.")
    public StyleEnum getStyle() {
        return this.style;
    }

    public void setStyle(StyleEnum style) {
        this.style = style;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatternFill patternFill = (PatternFill)o;
        return Objects.equals(this.backColor, patternFill.backColor) && Objects.equals(this.foreColor, patternFill.foreColor) && Objects.equals((Object)this.style, (Object)patternFill.style) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.backColor, this.foreColor, this.style, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PatternFill {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    backColor: ").append(this.toIndentedString(this.backColor)).append("\n");
        sb.append("    foreColor: ").append(this.toIndentedString(this.foreColor)).append("\n");
        sb.append("    style: ").append(this.toIndentedString((Object)this.style)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    static {
        typeDeterminers.put("Type", (Object)FillFormat.TypeEnum.PATTERN);
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StyleEnum {
        UNKNOWN("Unknown"),
        PERCENT05("Percent05"),
        PERCENT10("Percent10"),
        PERCENT20("Percent20"),
        PERCENT25("Percent25"),
        PERCENT30("Percent30"),
        PERCENT40("Percent40"),
        PERCENT50("Percent50"),
        PERCENT60("Percent60"),
        PERCENT70("Percent70"),
        PERCENT75("Percent75"),
        PERCENT80("Percent80"),
        PERCENT90("Percent90"),
        DARKHORIZONTAL("DarkHorizontal"),
        DARKVERTICAL("DarkVertical"),
        DARKDOWNWARDDIAGONAL("DarkDownwardDiagonal"),
        DARKUPWARDDIAGONAL("DarkUpwardDiagonal"),
        SMALLCHECKERBOARD("SmallCheckerBoard"),
        TRELLIS("Trellis"),
        LIGHTHORIZONTAL("LightHorizontal"),
        LIGHTVERTICAL("LightVertical"),
        LIGHTDOWNWARDDIAGONAL("LightDownwardDiagonal"),
        LIGHTUPWARDDIAGONAL("LightUpwardDiagonal"),
        SMALLGRID("SmallGrid"),
        DOTTEDDIAMOND("DottedDiamond"),
        WIDEDOWNWARDDIAGONAL("WideDownwardDiagonal"),
        WIDEUPWARDDIAGONAL("WideUpwardDiagonal"),
        DASHEDUPWARDDIAGONAL("DashedUpwardDiagonal"),
        DASHEDDOWNWARDDIAGONAL("DashedDownwardDiagonal"),
        NARROWVERTICAL("NarrowVertical"),
        NARROWHORIZONTAL("NarrowHorizontal"),
        DASHEDVERTICAL("DashedVertical"),
        DASHEDHORIZONTAL("DashedHorizontal"),
        LARGECONFETTI("LargeConfetti"),
        LARGEGRID("LargeGrid"),
        HORIZONTALBRICK("HorizontalBrick"),
        LARGECHECKERBOARD("LargeCheckerBoard"),
        SMALLCONFETTI("SmallConfetti"),
        ZIGZAG("Zigzag"),
        SOLIDDIAMOND("SolidDiamond"),
        DIAGONALBRICK("DiagonalBrick"),
        OUTLINEDDIAMOND("OutlinedDiamond"),
        PLAID("Plaid"),
        SPHERE("Sphere"),
        WEAVE("Weave"),
        DOTTEDGRID("DottedGrid"),
        DIVOT("Divot"),
        SHINGLE("Shingle"),
        WAVE("Wave"),
        HORIZONTAL("Horizontal"),
        VERTICAL("Vertical"),
        CROSS("Cross"),
        DOWNWARDDIAGONAL("DownwardDiagonal"),
        UPWARDDIAGONAL("UpwardDiagonal"),
        DIAGONALCROSS("DiagonalCross"),
        NOTDEFINED("NotDefined");

        private String value;

        private StyleEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StyleEnum fromValue(String text) {
            for (StyleEnum b : StyleEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StyleEnum> {
            public void write(JsonWriter jsonWriter, StyleEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StyleEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StyleEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

