/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.FillFormat;
import com.aspose.slides.model.ImageTransformEffect;
import com.aspose.slides.model.ResourceUri;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Picture fill.")
public class PictureFill
extends FillFormat {
    @SerializedName(value="cropBottom", alternate={"CropBottom"})
    private Double cropBottom;
    @SerializedName(value="cropLeft", alternate={"CropLeft"})
    private Double cropLeft;
    @SerializedName(value="cropRight", alternate={"CropRight"})
    private Double cropRight;
    @SerializedName(value="cropTop", alternate={"CropTop"})
    private Double cropTop;
    @SerializedName(value="dpi", alternate={"Dpi"})
    private Integer dpi;
    @SerializedName(value="tileOffsetX", alternate={"TileOffsetX"})
    private Double tileOffsetX;
    @SerializedName(value="tileOffsetY", alternate={"TileOffsetY"})
    private Double tileOffsetY;
    @SerializedName(value="tileScaleX", alternate={"TileScaleX"})
    private Double tileScaleX;
    @SerializedName(value="tileScaleY", alternate={"TileScaleY"})
    private Double tileScaleY;
    @SerializedName(value="tileAlignment", alternate={"TileAlignment"})
    private TileAlignmentEnum tileAlignment;
    @SerializedName(value="tileFlip", alternate={"TileFlip"})
    private TileFlipEnum tileFlip;
    @SerializedName(value="image", alternate={"Image"})
    private ResourceUri image;
    @SerializedName(value="base64Data", alternate={"Base64Data"})
    private String base64Data;
    @SerializedName(value="svgData", alternate={"SvgData"})
    private String svgData;
    @SerializedName(value="deletePictureCroppedAreas", alternate={"DeletePictureCroppedAreas"})
    private Boolean deletePictureCroppedAreas;
    @SerializedName(value="resolution", alternate={"Resolution"})
    private Double resolution;
    @SerializedName(value="pictureFillMode", alternate={"PictureFillMode"})
    private PictureFillModeEnum pictureFillMode;
    @SerializedName(value="imageTransformList", alternate={"ImageTransformList"})
    private List<ImageTransformEffect> imageTransformList = null;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public PictureFill() {
        this.setType(FillFormat.TypeEnum.PICTURE);
    }

    public PictureFill cropBottom(Double cropBottom) {
        this.cropBottom = cropBottom;
        return this;
    }

    @ApiModelProperty(required=true, value="Percentage of image height that is cropped from the bottom.")
    public Double getCropBottom() {
        return this.cropBottom;
    }

    public void setCropBottom(Double cropBottom) {
        this.cropBottom = cropBottom;
    }

    public PictureFill cropLeft(Double cropLeft) {
        this.cropLeft = cropLeft;
        return this;
    }

    @ApiModelProperty(required=true, value="Percentage of image height that is cropped from the left.")
    public Double getCropLeft() {
        return this.cropLeft;
    }

    public void setCropLeft(Double cropLeft) {
        this.cropLeft = cropLeft;
    }

    public PictureFill cropRight(Double cropRight) {
        this.cropRight = cropRight;
        return this;
    }

    @ApiModelProperty(required=true, value="Percentage of image height that is cropped from the right.")
    public Double getCropRight() {
        return this.cropRight;
    }

    public void setCropRight(Double cropRight) {
        this.cropRight = cropRight;
    }

    public PictureFill cropTop(Double cropTop) {
        this.cropTop = cropTop;
        return this;
    }

    @ApiModelProperty(required=true, value="Percentage of image height that is cropped from the top.")
    public Double getCropTop() {
        return this.cropTop;
    }

    public void setCropTop(Double cropTop) {
        this.cropTop = cropTop;
    }

    public PictureFill dpi(Integer dpi) {
        this.dpi = dpi;
        return this;
    }

    @ApiModelProperty(required=true, value="Picture resolution.")
    public Integer getDpi() {
        return this.dpi;
    }

    public void setDpi(Integer dpi) {
        this.dpi = dpi;
    }

    public PictureFill tileOffsetX(Double tileOffsetX) {
        this.tileOffsetX = tileOffsetX;
        return this;
    }

    @ApiModelProperty(value="The horizontal offset of the texture from the shape's origin in points. A positive value moves the texture to the right, while a negative value moves it to the left.")
    public Double getTileOffsetX() {
        return this.tileOffsetX;
    }

    public void setTileOffsetX(Double tileOffsetX) {
        this.tileOffsetX = tileOffsetX;
    }

    public PictureFill tileOffsetY(Double tileOffsetY) {
        this.tileOffsetY = tileOffsetY;
        return this;
    }

    @ApiModelProperty(value="The vertical offset of the texture from the shape's origin in points. A positive value moves the texture down, while a negative value moves it up.")
    public Double getTileOffsetY() {
        return this.tileOffsetY;
    }

    public void setTileOffsetY(Double tileOffsetY) {
        this.tileOffsetY = tileOffsetY;
    }

    public PictureFill tileScaleX(Double tileScaleX) {
        this.tileScaleX = tileScaleX;
        return this;
    }

    @ApiModelProperty(value="The horizontal scale for the texture fill as a percentage.")
    public Double getTileScaleX() {
        return this.tileScaleX;
    }

    public void setTileScaleX(Double tileScaleX) {
        this.tileScaleX = tileScaleX;
    }

    public PictureFill tileScaleY(Double tileScaleY) {
        this.tileScaleY = tileScaleY;
        return this;
    }

    @ApiModelProperty(value="The vertical scale for the texture fill as a percentage.")
    public Double getTileScaleY() {
        return this.tileScaleY;
    }

    public void setTileScaleY(Double tileScaleY) {
        this.tileScaleY = tileScaleY;
    }

    public PictureFill tileAlignment(TileAlignmentEnum tileAlignment) {
        this.tileAlignment = tileAlignment;
        return this;
    }

    @ApiModelProperty(value="The way texture is aligned within the shape. This setting controls the starting point of the texture pattern and how it repeats across the shape.")
    public TileAlignmentEnum getTileAlignment() {
        return this.tileAlignment;
    }

    public void setTileAlignment(TileAlignmentEnum tileAlignment) {
        this.tileAlignment = tileAlignment;
    }

    public PictureFill tileFlip(TileFlipEnum tileFlip) {
        this.tileFlip = tileFlip;
        return this;
    }

    @ApiModelProperty(value="Flips the texture tile around its horizontal, vertical or both axis.")
    public TileFlipEnum getTileFlip() {
        return this.tileFlip;
    }

    public void setTileFlip(TileFlipEnum tileFlip) {
        this.tileFlip = tileFlip;
    }

    public PictureFill image(ResourceUri image) {
        this.image = image;
        return this;
    }

    @ApiModelProperty(value="Internal image link.")
    public ResourceUri getImage() {
        return this.image;
    }

    public void setImage(ResourceUri image) {
        this.image = image;
    }

    public PictureFill base64Data(String base64Data) {
        this.base64Data = base64Data;
        return this;
    }

    @ApiModelProperty(value="Base 64 image data.")
    public String getBase64Data() {
        return this.base64Data;
    }

    public void setBase64Data(String base64Data) {
        this.base64Data = base64Data;
    }

    public PictureFill svgData(String svgData) {
        this.svgData = svgData;
        return this;
    }

    @ApiModelProperty(value="SVG image data.")
    public String getSvgData() {
        return this.svgData;
    }

    public void setSvgData(String svgData) {
        this.svgData = svgData;
    }

    public PictureFill deletePictureCroppedAreas(Boolean deletePictureCroppedAreas) {
        this.deletePictureCroppedAreas = deletePictureCroppedAreas;
        return this;
    }

    @ApiModelProperty(value="true to delete picture cropped areas on save.")
    public Boolean isDeletePictureCroppedAreas() {
        return this.deletePictureCroppedAreas;
    }

    public void setDeletePictureCroppedAreas(Boolean deletePictureCroppedAreas) {
        this.deletePictureCroppedAreas = deletePictureCroppedAreas;
    }

    public PictureFill resolution(Double resolution) {
        this.resolution = resolution;
        return this;
    }

    @ApiModelProperty(value="true to compress the picture image with the specified resolution (in dpi) on save.")
    public Double getResolution() {
        return this.resolution;
    }

    public void setResolution(Double resolution) {
        this.resolution = resolution;
    }

    public PictureFill pictureFillMode(PictureFillModeEnum pictureFillMode) {
        this.pictureFillMode = pictureFillMode;
        return this;
    }

    @ApiModelProperty(required=true, value="Fill mode.")
    public PictureFillModeEnum getPictureFillMode() {
        return this.pictureFillMode;
    }

    public void setPictureFillMode(PictureFillModeEnum pictureFillMode) {
        this.pictureFillMode = pictureFillMode;
    }

    public PictureFill imageTransformList(List<ImageTransformEffect> imageTransformList) {
        this.imageTransformList = imageTransformList;
        return this;
    }

    public PictureFill addImageTransformListItem(ImageTransformEffect imageTransformListItem) {
        if (this.imageTransformList == null) {
            this.imageTransformList = new ArrayList<ImageTransformEffect>();
        }
        this.imageTransformList.add(imageTransformListItem);
        return this;
    }

    @ApiModelProperty(value="Image transform effects.")
    public List<ImageTransformEffect> getImageTransformList() {
        return this.imageTransformList;
    }

    public void setImageTransformList(List<ImageTransformEffect> imageTransformList) {
        this.imageTransformList = imageTransformList;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PictureFill pictureFill = (PictureFill)o;
        return Objects.equals(this.cropBottom, pictureFill.cropBottom) && Objects.equals(this.cropLeft, pictureFill.cropLeft) && Objects.equals(this.cropRight, pictureFill.cropRight) && Objects.equals(this.cropTop, pictureFill.cropTop) && Objects.equals(this.dpi, pictureFill.dpi) && Objects.equals(this.tileOffsetX, pictureFill.tileOffsetX) && Objects.equals(this.tileOffsetY, pictureFill.tileOffsetY) && Objects.equals(this.tileScaleX, pictureFill.tileScaleX) && Objects.equals(this.tileScaleY, pictureFill.tileScaleY) && Objects.equals((Object)this.tileAlignment, (Object)pictureFill.tileAlignment) && Objects.equals((Object)this.tileFlip, (Object)pictureFill.tileFlip) && Objects.equals(this.image, pictureFill.image) && Objects.equals(this.base64Data, pictureFill.base64Data) && Objects.equals(this.svgData, pictureFill.svgData) && Objects.equals(this.deletePictureCroppedAreas, pictureFill.deletePictureCroppedAreas) && Objects.equals(this.resolution, pictureFill.resolution) && Objects.equals((Object)this.pictureFillMode, (Object)pictureFill.pictureFillMode) && Objects.equals(this.imageTransformList, pictureFill.imageTransformList) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.cropBottom, this.cropLeft, this.cropRight, this.cropTop, this.dpi, this.tileOffsetX, this.tileOffsetY, this.tileScaleX, this.tileScaleY, this.tileAlignment, this.tileFlip, this.image, this.base64Data, this.svgData, this.deletePictureCroppedAreas, this.resolution, this.pictureFillMode, this.imageTransformList, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PictureFill {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    cropBottom: ").append(this.toIndentedString(this.cropBottom)).append("\n");
        sb.append("    cropLeft: ").append(this.toIndentedString(this.cropLeft)).append("\n");
        sb.append("    cropRight: ").append(this.toIndentedString(this.cropRight)).append("\n");
        sb.append("    cropTop: ").append(this.toIndentedString(this.cropTop)).append("\n");
        sb.append("    dpi: ").append(this.toIndentedString(this.dpi)).append("\n");
        sb.append("    tileOffsetX: ").append(this.toIndentedString(this.tileOffsetX)).append("\n");
        sb.append("    tileOffsetY: ").append(this.toIndentedString(this.tileOffsetY)).append("\n");
        sb.append("    tileScaleX: ").append(this.toIndentedString(this.tileScaleX)).append("\n");
        sb.append("    tileScaleY: ").append(this.toIndentedString(this.tileScaleY)).append("\n");
        sb.append("    tileAlignment: ").append(this.toIndentedString((Object)this.tileAlignment)).append("\n");
        sb.append("    tileFlip: ").append(this.toIndentedString((Object)this.tileFlip)).append("\n");
        sb.append("    image: ").append(this.toIndentedString(this.image)).append("\n");
        sb.append("    base64Data: ").append(this.toIndentedString(this.base64Data)).append("\n");
        sb.append("    svgData: ").append(this.toIndentedString(this.svgData)).append("\n");
        sb.append("    deletePictureCroppedAreas: ").append(this.toIndentedString(this.deletePictureCroppedAreas)).append("\n");
        sb.append("    resolution: ").append(this.toIndentedString(this.resolution)).append("\n");
        sb.append("    pictureFillMode: ").append(this.toIndentedString((Object)this.pictureFillMode)).append("\n");
        sb.append("    imageTransformList: ").append(this.toIndentedString(this.imageTransformList)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    static {
        typeDeterminers.put("Type", (Object)FillFormat.TypeEnum.PICTURE);
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PictureFillModeEnum {
        TILE("Tile"),
        STRETCH("Stretch");

        private String value;

        private PictureFillModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PictureFillModeEnum fromValue(String text) {
            for (PictureFillModeEnum b : PictureFillModeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<PictureFillModeEnum> {
            public void write(JsonWriter jsonWriter, PictureFillModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PictureFillModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PictureFillModeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TileFlipEnum {
        NOFLIP("NoFlip"),
        FLIPX("FlipX"),
        FLIPY("FlipY"),
        FLIPBOTH("FlipBoth"),
        NOTDEFINED("NotDefined");

        private String value;

        private TileFlipEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TileFlipEnum fromValue(String text) {
            for (TileFlipEnum b : TileFlipEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TileFlipEnum> {
            public void write(JsonWriter jsonWriter, TileFlipEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TileFlipEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TileFlipEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TileAlignmentEnum {
        TOPLEFT("TopLeft"),
        TOP("Top"),
        TOPRIGHT("TopRight"),
        LEFT("Left"),
        CENTER("Center"),
        RIGHT("Right"),
        BOTTOMLEFT("BottomLeft"),
        BOTTOM("Bottom"),
        BOTTOMRIGHT("BottomRight"),
        NOTDEFINED("NotDefined");

        private String value;

        private TileAlignmentEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TileAlignmentEnum fromValue(String text) {
            for (TileAlignmentEnum b : TileAlignmentEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TileAlignmentEnum> {
            public void write(JsonWriter jsonWriter, TileAlignmentEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TileAlignmentEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TileAlignmentEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

