/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.Input;
import com.aspose.slides.model.Task;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Represents pipeline for one input document.")
public class Pipeline {
    @SerializedName(value="input", alternate={"Input"})
    private Input input;
    @SerializedName(value="tasks", alternate={"Tasks"})
    private List<Task> tasks = null;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public Pipeline input(Input input) {
        this.input = input;
        return this;
    }

    @ApiModelProperty(value="Get or sets input document.")
    public Input getInput() {
        return this.input;
    }

    public void setInput(Input input) {
        this.input = input;
    }

    public Pipeline tasks(List<Task> tasks) {
        this.tasks = tasks;
        return this;
    }

    public Pipeline addTasksItem(Task tasksItem) {
        if (this.tasks == null) {
            this.tasks = new ArrayList<Task>();
        }
        this.tasks.add(tasksItem);
        return this;
    }

    @ApiModelProperty(value="Get or sets list of tasks representing pipeline.")
    public List<Task> getTasks() {
        return this.tasks;
    }

    public void setTasks(List<Task> tasks) {
        this.tasks = tasks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pipeline pipeline = (Pipeline)o;
        return Objects.equals(this.input, pipeline.input) && Objects.equals(this.tasks, pipeline.tasks);
    }

    public int hashCode() {
        return Objects.hash(this.input, this.tasks);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Pipeline {\n");
        sb.append("    input: ").append(this.toIndentedString(this.input)).append("\n");
        sb.append("    tasks: ").append(this.toIndentedString(this.tasks)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

