/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.ExportOptions;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Provides options that control how a presentation is saved in PPTX format.")
public class PptxExportOptions
extends ExportOptions {
    @SerializedName(value="conformance", alternate={"Conformance"})
    private ConformanceEnum conformance;
    @SerializedName(value="zip64Mode", alternate={"Zip64Mode"})
    private Zip64ModeEnum zip64Mode;
    @SerializedName(value="refreshThumbnail", alternate={"RefreshThumbnail"})
    private Boolean refreshThumbnail;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public PptxExportOptions() {
        this.setFormat("PPTX");
    }

    public PptxExportOptions conformance(ConformanceEnum conformance) {
        this.conformance = conformance;
        return this;
    }

    @ApiModelProperty(value="The conformance class to which the PresentationML document conforms.")
    public ConformanceEnum getConformance() {
        return this.conformance;
    }

    public void setConformance(ConformanceEnum conformance) {
        this.conformance = conformance;
    }

    public PptxExportOptions zip64Mode(Zip64ModeEnum zip64Mode) {
        this.zip64Mode = zip64Mode;
        return this;
    }

    @ApiModelProperty(value="Specifies whether the ZIP64 format is used for the Presentation document. The default value is Zip64Mode.IfNecessary.")
    public Zip64ModeEnum getZip64Mode() {
        return this.zip64Mode;
    }

    public void setZip64Mode(Zip64ModeEnum zip64Mode) {
        this.zip64Mode = zip64Mode;
    }

    public PptxExportOptions refreshThumbnail(Boolean refreshThumbnail) {
        this.refreshThumbnail = refreshThumbnail;
        return this;
    }

    @ApiModelProperty(value="True to refresh the presentation thumbnail on save")
    public Boolean isRefreshThumbnail() {
        return this.refreshThumbnail;
    }

    public void setRefreshThumbnail(Boolean refreshThumbnail) {
        this.refreshThumbnail = refreshThumbnail;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PptxExportOptions pptxExportOptions = (PptxExportOptions)o;
        return Objects.equals((Object)this.conformance, (Object)pptxExportOptions.conformance) && Objects.equals((Object)this.zip64Mode, (Object)pptxExportOptions.zip64Mode) && Objects.equals(this.refreshThumbnail, pptxExportOptions.refreshThumbnail) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.conformance, this.zip64Mode, this.refreshThumbnail, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PptxExportOptions {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    conformance: ").append(this.toIndentedString((Object)this.conformance)).append("\n");
        sb.append("    zip64Mode: ").append(this.toIndentedString((Object)this.zip64Mode)).append("\n");
        sb.append("    refreshThumbnail: ").append(this.toIndentedString(this.refreshThumbnail)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum Zip64ModeEnum {
        NEVER("Never"),
        IFNECESSARY("IfNecessary"),
        ALWAYS("Always");

        private String value;

        private Zip64ModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static Zip64ModeEnum fromValue(String text) {
            for (Zip64ModeEnum b : Zip64ModeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<Zip64ModeEnum> {
            public void write(JsonWriter jsonWriter, Zip64ModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public Zip64ModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return Zip64ModeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ConformanceEnum {
        ECMA376("Ecma376"),
        ISO29500TRANSITIONAL("Iso29500Transitional"),
        ISO29500STRICT("Iso29500Strict");

        private String value;

        private ConformanceEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ConformanceEnum fromValue(String text) {
            for (ConformanceEnum b : ConformanceEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ConformanceEnum> {
            public void write(JsonWriter jsonWriter, ConformanceEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ConformanceEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ConformanceEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

