/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Represents presentation to merge")
public class PresentationToMerge {
    @SerializedName(value="path", alternate={"Path"})
    private String path;
    @SerializedName(value="password", alternate={"Password"})
    private String password;
    @SerializedName(value="slides", alternate={"Slides"})
    private List<Integer> slides = null;
    @SerializedName(value="source", alternate={"Source"})
    private SourceEnum source;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public PresentationToMerge path(String path) {
        this.path = path;
        return this;
    }

    @ApiModelProperty(value="Get or sets the presentation path")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public PresentationToMerge password(String password) {
        this.password = password;
        return this;
    }

    @ApiModelProperty(value="Get or sets the presentation password")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public PresentationToMerge slides(List<Integer> slides) {
        this.slides = slides;
        return this;
    }

    public PresentationToMerge addSlidesItem(Integer slidesItem) {
        if (this.slides == null) {
            this.slides = new ArrayList<Integer>();
        }
        this.slides.add(slidesItem);
        return this;
    }

    @ApiModelProperty(value="Get or sets the indexes of slides to merge")
    public List<Integer> getSlides() {
        return this.slides;
    }

    public void setSlides(List<Integer> slides) {
        this.slides = slides;
    }

    public PresentationToMerge source(SourceEnum source) {
        this.source = source;
        return this;
    }

    @ApiModelProperty(value="Merge (request or storage). ")
    public SourceEnum getSource() {
        return this.source;
    }

    public void setSource(SourceEnum source) {
        this.source = source;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PresentationToMerge presentationToMerge = (PresentationToMerge)o;
        return Objects.equals(this.path, presentationToMerge.path) && Objects.equals(this.password, presentationToMerge.password) && Objects.equals(this.slides, presentationToMerge.slides) && Objects.equals((Object)this.source, (Object)presentationToMerge.source);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.path, this.password, this.slides, this.source});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PresentationToMerge {\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    slides: ").append(this.toIndentedString(this.slides)).append("\n");
        sb.append("    source: ").append(this.toIndentedString((Object)this.source)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SourceEnum {
        STORAGE("Storage"),
        REQUEST("Request"),
        URL("Url");

        private String value;

        private SourceEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SourceEnum fromValue(String text) {
            for (SourceEnum b : SourceEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<SourceEnum> {
            public void write(JsonWriter jsonWriter, SourceEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public SourceEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SourceEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

