/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Represents preset shadow effect ")
public class PresetShadowEffect {
    @SerializedName(value="direction", alternate={"Direction"})
    private Double direction;
    @SerializedName(value="distance", alternate={"Distance"})
    private Double distance;
    @SerializedName(value="preset", alternate={"Preset"})
    private PresetEnum preset;
    @SerializedName(value="shadowColor", alternate={"ShadowColor"})
    private String shadowColor;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public PresetShadowEffect direction(Double direction) {
        this.direction = direction;
        return this;
    }

    @ApiModelProperty(required=true, value="direction")
    public Double getDirection() {
        return this.direction;
    }

    public void setDirection(Double direction) {
        this.direction = direction;
    }

    public PresetShadowEffect distance(Double distance) {
        this.distance = distance;
        return this;
    }

    @ApiModelProperty(required=true, value="distance")
    public Double getDistance() {
        return this.distance;
    }

    public void setDistance(Double distance) {
        this.distance = distance;
    }

    public PresetShadowEffect preset(PresetEnum preset) {
        this.preset = preset;
        return this;
    }

    @ApiModelProperty(required=true, value="preset")
    public PresetEnum getPreset() {
        return this.preset;
    }

    public void setPreset(PresetEnum preset) {
        this.preset = preset;
    }

    public PresetShadowEffect shadowColor(String shadowColor) {
        this.shadowColor = shadowColor;
        return this;
    }

    @ApiModelProperty(value="shadow color")
    public String getShadowColor() {
        return this.shadowColor;
    }

    public void setShadowColor(String shadowColor) {
        this.shadowColor = shadowColor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PresetShadowEffect presetShadowEffect = (PresetShadowEffect)o;
        return Objects.equals(this.direction, presetShadowEffect.direction) && Objects.equals(this.distance, presetShadowEffect.distance) && Objects.equals((Object)this.preset, (Object)presetShadowEffect.preset) && Objects.equals(this.shadowColor, presetShadowEffect.shadowColor);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.direction, this.distance, this.preset, this.shadowColor});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PresetShadowEffect {\n");
        sb.append("    direction: ").append(this.toIndentedString(this.direction)).append("\n");
        sb.append("    distance: ").append(this.toIndentedString(this.distance)).append("\n");
        sb.append("    preset: ").append(this.toIndentedString((Object)this.preset)).append("\n");
        sb.append("    shadowColor: ").append(this.toIndentedString(this.shadowColor)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PresetEnum {
        TOPLEFTDROPSHADOW("TopLeftDropShadow"),
        TOPLEFTLARGEDROPSHADOW("TopLeftLargeDropShadow"),
        BACKLEFTLONGPERSPECTIVESHADOW("BackLeftLongPerspectiveShadow"),
        BACKRIGHTLONGPERSPECTIVESHADOW("BackRightLongPerspectiveShadow"),
        TOPLEFTDOUBLEDROPSHADOW("TopLeftDoubleDropShadow"),
        BOTTOMRIGHTSMALLDROPSHADOW("BottomRightSmallDropShadow"),
        FRONTLEFTLONGPERSPECTIVESHADOW("FrontLeftLongPerspectiveShadow"),
        FRONTRIGHTLONGPERSPECTIVESHADOW("FrontRightLongPerspectiveShadow"),
        OUTERBOXSHADOW3D("OuterBoxShadow3D"),
        INNERBOXSHADOW3D("InnerBoxShadow3D"),
        BACKCENTERPERSPECTIVESHADOW("BackCenterPerspectiveShadow"),
        TOPRIGHTDROPSHADOW("TopRightDropShadow"),
        FRONTBOTTOMSHADOW("FrontBottomShadow"),
        BACKLEFTPERSPECTIVESHADOW("BackLeftPerspectiveShadow"),
        BACKRIGHTPERSPECTIVESHADOW("BackRightPerspectiveShadow"),
        BOTTOMLEFTDROPSHADOW("BottomLeftDropShadow"),
        BOTTOMRIGHTDROPSHADOW("BottomRightDropShadow"),
        FRONTLEFTPERSPECTIVESHADOW("FrontLeftPerspectiveShadow"),
        FRONTRIGHTPERSPECTIVESHADOW("FrontRightPerspectiveShadow"),
        TOPLEFTSMALLDROPSHADOW("TopLeftSmallDropShadow");

        private String value;

        private PresetEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PresetEnum fromValue(String text) {
            for (PresetEnum b : PresetEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<PresetEnum> {
            public void write(JsonWriter jsonWriter, PresetEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PresetEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PresetEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

