/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.ResourceBase;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Protection properties.")
public class ProtectionProperties
extends ResourceBase {
    @SerializedName(value="encryptDocumentProperties", alternate={"EncryptDocumentProperties"})
    private Boolean encryptDocumentProperties;
    @SerializedName(value="readOnlyRecommended", alternate={"ReadOnlyRecommended"})
    private Boolean readOnlyRecommended;
    @SerializedName(value="readPassword", alternate={"ReadPassword"})
    private String readPassword;
    @SerializedName(value="writePassword", alternate={"WritePassword"})
    private String writePassword;
    @SerializedName(value="isWriteProtected", alternate={"IsWriteProtected"})
    private Boolean isWriteProtected;
    @SerializedName(value="isEncrypted", alternate={"IsEncrypted"})
    private Boolean isEncrypted;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public ProtectionProperties encryptDocumentProperties(Boolean encryptDocumentProperties) {
        this.encryptDocumentProperties = encryptDocumentProperties;
        return this;
    }

    @ApiModelProperty(value="True if document properties are encrypted. Has effect only for password protected presentations.")
    public Boolean isEncryptDocumentProperties() {
        return this.encryptDocumentProperties;
    }

    public void setEncryptDocumentProperties(Boolean encryptDocumentProperties) {
        this.encryptDocumentProperties = encryptDocumentProperties;
    }

    public ProtectionProperties readOnlyRecommended(Boolean readOnlyRecommended) {
        this.readOnlyRecommended = readOnlyRecommended;
        return this;
    }

    @ApiModelProperty(value="True if the document should be opened as read-only.")
    public Boolean isReadOnlyRecommended() {
        return this.readOnlyRecommended;
    }

    public void setReadOnlyRecommended(Boolean readOnlyRecommended) {
        this.readOnlyRecommended = readOnlyRecommended;
    }

    public ProtectionProperties readPassword(String readPassword) {
        this.readPassword = readPassword;
        return this;
    }

    @ApiModelProperty(value="Password for read protection.")
    public String getReadPassword() {
        return this.readPassword;
    }

    public void setReadPassword(String readPassword) {
        this.readPassword = readPassword;
    }

    public ProtectionProperties writePassword(String writePassword) {
        this.writePassword = writePassword;
        return this;
    }

    @ApiModelProperty(value="Password for write protection.")
    public String getWritePassword() {
        return this.writePassword;
    }

    public void setWritePassword(String writePassword) {
        this.writePassword = writePassword;
    }

    public ProtectionProperties isWriteProtected(Boolean isWriteProtected) {
        this.isWriteProtected = isWriteProtected;
        return this;
    }

    @ApiModelProperty(value="Returns true if the presentation protected for editing. ")
    public Boolean getIsWriteProtected() {
        return this.isWriteProtected;
    }

    public void setIsWriteProtected(Boolean isWriteProtected) {
        this.isWriteProtected = isWriteProtected;
    }

    public ProtectionProperties isEncrypted(Boolean isEncrypted) {
        this.isEncrypted = isEncrypted;
        return this;
    }

    @ApiModelProperty(value="Returns true if the presentation protected for reading. ")
    public Boolean getIsEncrypted() {
        return this.isEncrypted;
    }

    public void setIsEncrypted(Boolean isEncrypted) {
        this.isEncrypted = isEncrypted;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProtectionProperties protectionProperties = (ProtectionProperties)o;
        return Objects.equals(this.encryptDocumentProperties, protectionProperties.encryptDocumentProperties) && Objects.equals(this.readOnlyRecommended, protectionProperties.readOnlyRecommended) && Objects.equals(this.readPassword, protectionProperties.readPassword) && Objects.equals(this.writePassword, protectionProperties.writePassword) && Objects.equals(this.isWriteProtected, protectionProperties.isWriteProtected) && Objects.equals(this.isEncrypted, protectionProperties.isEncrypted) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.encryptDocumentProperties, this.readOnlyRecommended, this.readPassword, this.writePassword, this.isWriteProtected, this.isEncrypted, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProtectionProperties {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    encryptDocumentProperties: ").append(this.toIndentedString(this.encryptDocumentProperties)).append("\n");
        sb.append("    readOnlyRecommended: ").append(this.toIndentedString(this.readOnlyRecommended)).append("\n");
        sb.append("    readPassword: ").append(this.toIndentedString(this.readPassword)).append("\n");
        sb.append("    writePassword: ").append(this.toIndentedString(this.writePassword)).append("\n");
        sb.append("    isWriteProtected: ").append(this.toIndentedString(this.isWriteProtected)).append("\n");
        sb.append("    isEncrypted: ").append(this.toIndentedString(this.isEncrypted)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

