/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.ExportOptions;
import com.aspose.slides.model.OutputFile;
import com.aspose.slides.model.Task;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Save slide task.")
public class SaveSlide
extends Task {
    @SerializedName(value="output", alternate={"Output"})
    private OutputFile output;
    @SerializedName(value="format", alternate={"Format"})
    private FormatEnum format;
    @SerializedName(value="options", alternate={"Options"})
    private ExportOptions options;
    @SerializedName(value="width", alternate={"Width"})
    private Integer width;
    @SerializedName(value="height", alternate={"Height"})
    private Integer height;
    @SerializedName(value="position", alternate={"Position"})
    private Integer position;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public SaveSlide() {
        this.setType(Task.TypeEnum.SAVESLIDE);
    }

    public SaveSlide output(OutputFile output) {
        this.output = output;
        return this;
    }

    @ApiModelProperty(value="Output to save the slide to.")
    public OutputFile getOutput() {
        return this.output;
    }

    public void setOutput(OutputFile output) {
        this.output = output;
    }

    public SaveSlide format(FormatEnum format) {
        this.format = format;
        return this;
    }

    @ApiModelProperty(required=true, value="Save format.")
    public FormatEnum getFormat() {
        return this.format;
    }

    public void setFormat(FormatEnum format) {
        this.format = format;
    }

    public SaveSlide options(ExportOptions options) {
        this.options = options;
        return this;
    }

    @ApiModelProperty(value="Save options.")
    public ExportOptions getOptions() {
        return this.options;
    }

    public void setOptions(ExportOptions options) {
        this.options = options;
    }

    public SaveSlide width(Integer width) {
        this.width = width;
        return this;
    }

    @ApiModelProperty(value="Result width for saving to an image format.")
    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public SaveSlide height(Integer height) {
        this.height = height;
        return this;
    }

    @ApiModelProperty(value="Result height for saving to an image format.")
    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public SaveSlide position(Integer position) {
        this.position = position;
        return this;
    }

    @ApiModelProperty(required=true, value="Slide index.")
    public Integer getPosition() {
        return this.position;
    }

    public void setPosition(Integer position) {
        this.position = position;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SaveSlide saveSlide = (SaveSlide)o;
        return Objects.equals(this.output, saveSlide.output) && Objects.equals((Object)this.format, (Object)saveSlide.format) && Objects.equals(this.options, saveSlide.options) && Objects.equals(this.width, saveSlide.width) && Objects.equals(this.height, saveSlide.height) && Objects.equals(this.position, saveSlide.position) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.output, this.format, this.options, this.width, this.height, this.position, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SaveSlide {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    output: ").append(this.toIndentedString(this.output)).append("\n");
        sb.append("    format: ").append(this.toIndentedString((Object)this.format)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    position: ").append(this.toIndentedString(this.position)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    static {
        typeDeterminers.put("Type", (Object)Task.TypeEnum.SAVESLIDE);
    }

    @JsonAdapter(value=Adapter.class)
    public static enum FormatEnum {
        JPEG("Jpeg"),
        PNG("Png"),
        GIF("Gif"),
        BMP("Bmp"),
        TIFF("Tiff"),
        HTML("Html"),
        PDF("Pdf"),
        XPS("Xps"),
        PPTX("Pptx"),
        ODP("Odp"),
        OTP("Otp"),
        PPT("Ppt"),
        PPS("Pps"),
        PPSX("Ppsx"),
        PPTM("Pptm"),
        PPSM("Ppsm"),
        POTX("Potx"),
        POT("Pot"),
        POTM("Potm"),
        SVG("Svg"),
        FODP("Fodp"),
        XAML("Xaml"),
        HTML5("Html5"),
        MD("Md"),
        XML("Xml"),
        EMF("Emf");

        private String value;

        private FormatEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static FormatEnum fromValue(String text) {
            for (FormatEnum b : FormatEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<FormatEnum> {
            public void write(JsonWriter jsonWriter, FormatEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public FormatEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return FormatEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

