/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.DataPoint;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Scatter chart (two-dimensional) data point")
public class ScatterChartDataPoint
extends DataPoint {
    @SerializedName(value="xvalue", alternate={"XValue"})
    private Double xvalue;
    @SerializedName(value="yvalue", alternate={"YValue"})
    private Double yvalue;
    @SerializedName(value="xvalueFormula", alternate={"XValueFormula"})
    private String xvalueFormula;
    @SerializedName(value="yvalueFormula", alternate={"YValueFormula"})
    private String yvalueFormula;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public ScatterChartDataPoint() {
        this.setType(DataPoint.TypeEnum.SCATTER);
    }

    public ScatterChartDataPoint xvalue(Double xvalue) {
        this.xvalue = xvalue;
        return this;
    }

    @ApiModelProperty(value="X-value")
    public Double getXvalue() {
        return this.xvalue;
    }

    public void setXvalue(Double xvalue) {
        this.xvalue = xvalue;
    }

    public ScatterChartDataPoint yvalue(Double yvalue) {
        this.yvalue = yvalue;
        return this;
    }

    @ApiModelProperty(value="Y-value")
    public Double getYvalue() {
        return this.yvalue;
    }

    public void setYvalue(Double yvalue) {
        this.yvalue = yvalue;
    }

    public ScatterChartDataPoint xvalueFormula(String xvalueFormula) {
        this.xvalueFormula = xvalueFormula;
        return this;
    }

    @ApiModelProperty(value="Spreadsheet formula in A1-style.")
    public String getXvalueFormula() {
        return this.xvalueFormula;
    }

    public void setXvalueFormula(String xvalueFormula) {
        this.xvalueFormula = xvalueFormula;
    }

    public ScatterChartDataPoint yvalueFormula(String yvalueFormula) {
        this.yvalueFormula = yvalueFormula;
        return this;
    }

    @ApiModelProperty(value="Spreadsheet formula in A1-style.")
    public String getYvalueFormula() {
        return this.yvalueFormula;
    }

    public void setYvalueFormula(String yvalueFormula) {
        this.yvalueFormula = yvalueFormula;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScatterChartDataPoint scatterChartDataPoint = (ScatterChartDataPoint)o;
        return Objects.equals(this.xvalue, scatterChartDataPoint.xvalue) && Objects.equals(this.yvalue, scatterChartDataPoint.yvalue) && Objects.equals(this.xvalueFormula, scatterChartDataPoint.xvalueFormula) && Objects.equals(this.yvalueFormula, scatterChartDataPoint.yvalueFormula) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.xvalue, this.yvalue, this.xvalueFormula, this.yvalueFormula, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScatterChartDataPoint {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    xvalue: ").append(this.toIndentedString(this.xvalue)).append("\n");
        sb.append("    yvalue: ").append(this.toIndentedString(this.yvalue)).append("\n");
        sb.append("    xvalueFormula: ").append(this.toIndentedString(this.xvalueFormula)).append("\n");
        sb.append("    yvalueFormula: ").append(this.toIndentedString(this.yvalueFormula)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    static {
        typeDeterminers.put("Type", (Object)DataPoint.TypeEnum.SCATTER);
    }
}

