/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.GeometryShape;
import com.aspose.slides.model.Paragraph;
import com.aspose.slides.model.ShapeBase;
import com.aspose.slides.model.TextFrameFormat;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Represents AutoShape resource.")
public class Shape
extends GeometryShape {
    @SerializedName(value="text", alternate={"Text"})
    private String text;
    @SerializedName(value="paragraphs", alternate={"Paragraphs"})
    private List<Paragraph> paragraphs = null;
    @SerializedName(value="textFrameFormat", alternate={"TextFrameFormat"})
    private TextFrameFormat textFrameFormat;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public Shape() {
        this.setType(ShapeBase.TypeEnum.SHAPE);
    }

    public Shape text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the text.")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @ApiModelProperty(value="Get or sets list to paragraphs list")
    public List<Paragraph> getParagraphs() {
        return this.paragraphs;
    }

    protected void setParagraphs(List<Paragraph> paragraphs) {
        this.paragraphs = paragraphs;
    }

    public Shape textFrameFormat(TextFrameFormat textFrameFormat) {
        this.textFrameFormat = textFrameFormat;
        return this;
    }

    @ApiModelProperty(value="Returns TextFrame's formatting properties.")
    public TextFrameFormat getTextFrameFormat() {
        return this.textFrameFormat;
    }

    public void setTextFrameFormat(TextFrameFormat textFrameFormat) {
        this.textFrameFormat = textFrameFormat;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Shape shape = (Shape)o;
        return Objects.equals(this.text, shape.text) && Objects.equals(this.paragraphs, shape.paragraphs) && Objects.equals(this.textFrameFormat, shape.textFrameFormat) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.text, this.paragraphs, this.textFrameFormat, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Shape {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    paragraphs: ").append(this.toIndentedString(this.paragraphs)).append("\n");
        sb.append("    textFrameFormat: ").append(this.toIndentedString(this.textFrameFormat)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    static {
        typeDeterminers.put("Type", (Object)ShapeBase.TypeEnum.SHAPE);
    }
}

