/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.ResourceUri;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Smart art node.")
public class SmartArtNode {
    @SerializedName(value="nodes", alternate={"Nodes"})
    private List<SmartArtNode> nodes = null;
    @SerializedName(value="shapes", alternate={"Shapes"})
    private ResourceUri shapes;
    @SerializedName(value="isAssistant", alternate={"IsAssistant"})
    private Boolean isAssistant;
    @SerializedName(value="text", alternate={"Text"})
    private String text;
    @SerializedName(value="orgChartLayout", alternate={"OrgChartLayout"})
    private OrgChartLayoutEnum orgChartLayout;
    @SerializedName(value="paragraphs", alternate={"Paragraphs"})
    private ResourceUri paragraphs;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public SmartArtNode nodes(List<SmartArtNode> nodes) {
        this.nodes = nodes;
        return this;
    }

    public SmartArtNode addNodesItem(SmartArtNode nodesItem) {
        if (this.nodes == null) {
            this.nodes = new ArrayList<SmartArtNode>();
        }
        this.nodes.add(nodesItem);
        return this;
    }

    @ApiModelProperty(value="Node list.")
    public List<SmartArtNode> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<SmartArtNode> nodes) {
        this.nodes = nodes;
    }

    public SmartArtNode shapes(ResourceUri shapes) {
        this.shapes = shapes;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the link to shapes.")
    public ResourceUri getShapes() {
        return this.shapes;
    }

    public void setShapes(ResourceUri shapes) {
        this.shapes = shapes;
    }

    public SmartArtNode isAssistant(Boolean isAssistant) {
        this.isAssistant = isAssistant;
        return this;
    }

    @ApiModelProperty(value="True for and assistant node.")
    public Boolean getIsAssistant() {
        return this.isAssistant;
    }

    public void setIsAssistant(Boolean isAssistant) {
        this.isAssistant = isAssistant;
    }

    public SmartArtNode text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(value="Node text.")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public SmartArtNode orgChartLayout(OrgChartLayoutEnum orgChartLayout) {
        this.orgChartLayout = orgChartLayout;
        return this;
    }

    @ApiModelProperty(required=true, value="Organization chart layout type associated with current node.")
    public OrgChartLayoutEnum getOrgChartLayout() {
        return this.orgChartLayout;
    }

    public void setOrgChartLayout(OrgChartLayoutEnum orgChartLayout) {
        this.orgChartLayout = orgChartLayout;
    }

    public SmartArtNode paragraphs(ResourceUri paragraphs) {
        this.paragraphs = paragraphs;
        return this;
    }

    @ApiModelProperty(value="Get or sets list to paragraphs list")
    public ResourceUri getParagraphs() {
        return this.paragraphs;
    }

    public void setParagraphs(ResourceUri paragraphs) {
        this.paragraphs = paragraphs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SmartArtNode smartArtNode = (SmartArtNode)o;
        return Objects.equals(this.nodes, smartArtNode.nodes) && Objects.equals(this.shapes, smartArtNode.shapes) && Objects.equals(this.isAssistant, smartArtNode.isAssistant) && Objects.equals(this.text, smartArtNode.text) && Objects.equals((Object)this.orgChartLayout, (Object)smartArtNode.orgChartLayout) && Objects.equals(this.paragraphs, smartArtNode.paragraphs);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.nodes, this.shapes, this.isAssistant, this.text, this.orgChartLayout, this.paragraphs});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SmartArtNode {\n");
        sb.append("    nodes: ").append(this.toIndentedString(this.nodes)).append("\n");
        sb.append("    shapes: ").append(this.toIndentedString(this.shapes)).append("\n");
        sb.append("    isAssistant: ").append(this.toIndentedString(this.isAssistant)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    orgChartLayout: ").append(this.toIndentedString((Object)this.orgChartLayout)).append("\n");
        sb.append("    paragraphs: ").append(this.toIndentedString(this.paragraphs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum OrgChartLayoutEnum {
        INITIAL("Initial"),
        STANDART("Standart"),
        BOTHHANGING("BothHanging"),
        LEFTHANGING("LeftHanging"),
        RIGHTHANGING("RightHanging");

        private String value;

        private OrgChartLayoutEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static OrgChartLayoutEnum fromValue(String text) {
            for (OrgChartLayoutEnum b : OrgChartLayoutEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<OrgChartLayoutEnum> {
            public void write(JsonWriter jsonWriter, OrgChartLayoutEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public OrgChartLayoutEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return OrgChartLayoutEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

