/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.ExportOptions;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Provides options that control how a presentation is saved in SVG format.")
public class SvgExportOptions
extends ExportOptions {
    @SerializedName(value="vectorizeText", alternate={"VectorizeText"})
    private Boolean vectorizeText;
    @SerializedName(value="metafileRasterizationDpi", alternate={"MetafileRasterizationDpi"})
    private Integer metafileRasterizationDpi;
    @SerializedName(value="disable3DText", alternate={"Disable3DText"})
    private Boolean disable3DText;
    @SerializedName(value="disableGradientSplit", alternate={"DisableGradientSplit"})
    private Boolean disableGradientSplit;
    @SerializedName(value="disableLineEndCropping", alternate={"DisableLineEndCropping"})
    private Boolean disableLineEndCropping;
    @SerializedName(value="jpegQuality", alternate={"JpegQuality"})
    private Integer jpegQuality;
    @SerializedName(value="picturesCompression", alternate={"PicturesCompression"})
    private PicturesCompressionEnum picturesCompression;
    @SerializedName(value="deletePicturesCroppedAreas", alternate={"DeletePicturesCroppedAreas"})
    private Boolean deletePicturesCroppedAreas;
    @SerializedName(value="externalFontsHandling", alternate={"ExternalFontsHandling"})
    private ExternalFontsHandlingEnum externalFontsHandling;
    @SerializedName(value="useFrameSize", alternate={"UseFrameSize"})
    private Boolean useFrameSize;
    @SerializedName(value="useFrameRotation", alternate={"UseFrameRotation"})
    private Boolean useFrameRotation;
    @SerializedName(value="disableFontLigatures", alternate={"DisableFontLigatures"})
    private Boolean disableFontLigatures;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public SvgExportOptions() {
        this.setFormat("SVG");
    }

    public SvgExportOptions vectorizeText(Boolean vectorizeText) {
        this.vectorizeText = vectorizeText;
        return this;
    }

    @ApiModelProperty(value="Determines whether the text on a slide will be saved as graphics.")
    public Boolean isVectorizeText() {
        return this.vectorizeText;
    }

    public void setVectorizeText(Boolean vectorizeText) {
        this.vectorizeText = vectorizeText;
    }

    public SvgExportOptions metafileRasterizationDpi(Integer metafileRasterizationDpi) {
        this.metafileRasterizationDpi = metafileRasterizationDpi;
        return this;
    }

    @ApiModelProperty(value="Returns or sets the lower resolution limit for metafile rasterization.")
    public Integer getMetafileRasterizationDpi() {
        return this.metafileRasterizationDpi;
    }

    public void setMetafileRasterizationDpi(Integer metafileRasterizationDpi) {
        this.metafileRasterizationDpi = metafileRasterizationDpi;
    }

    public SvgExportOptions disable3DText(Boolean disable3DText) {
        this.disable3DText = disable3DText;
        return this;
    }

    @ApiModelProperty(value="Determines whether the 3D text is disabled in SVG.")
    public Boolean isDisable3DText() {
        return this.disable3DText;
    }

    public void setDisable3DText(Boolean disable3DText) {
        this.disable3DText = disable3DText;
    }

    public SvgExportOptions disableGradientSplit(Boolean disableGradientSplit) {
        this.disableGradientSplit = disableGradientSplit;
        return this;
    }

    @ApiModelProperty(value="Disables splitting FromCornerX and FromCenter gradients.")
    public Boolean isDisableGradientSplit() {
        return this.disableGradientSplit;
    }

    public void setDisableGradientSplit(Boolean disableGradientSplit) {
        this.disableGradientSplit = disableGradientSplit;
    }

    public SvgExportOptions disableLineEndCropping(Boolean disableLineEndCropping) {
        this.disableLineEndCropping = disableLineEndCropping;
        return this;
    }

    @ApiModelProperty(value="SVG 1.1 lacks ability to define insets for markers. Aspose.Slides SVG writing engine has workaround for that problem: it crops end of line with arrow, so, line doesn't overlap markers. This option switches off such behavior.")
    public Boolean isDisableLineEndCropping() {
        return this.disableLineEndCropping;
    }

    public void setDisableLineEndCropping(Boolean disableLineEndCropping) {
        this.disableLineEndCropping = disableLineEndCropping;
    }

    public SvgExportOptions jpegQuality(Integer jpegQuality) {
        this.jpegQuality = jpegQuality;
        return this;
    }

    @ApiModelProperty(value="Determines JPEG encoding quality.")
    public Integer getJpegQuality() {
        return this.jpegQuality;
    }

    public void setJpegQuality(Integer jpegQuality) {
        this.jpegQuality = jpegQuality;
    }

    public SvgExportOptions picturesCompression(PicturesCompressionEnum picturesCompression) {
        this.picturesCompression = picturesCompression;
        return this;
    }

    @ApiModelProperty(value="Represents the pictures compression level")
    public PicturesCompressionEnum getPicturesCompression() {
        return this.picturesCompression;
    }

    public void setPicturesCompression(PicturesCompressionEnum picturesCompression) {
        this.picturesCompression = picturesCompression;
    }

    public SvgExportOptions deletePicturesCroppedAreas(Boolean deletePicturesCroppedAreas) {
        this.deletePicturesCroppedAreas = deletePicturesCroppedAreas;
        return this;
    }

    @ApiModelProperty(value="A boolean flag indicates if the cropped parts remain as part of the document. If true the cropped  parts will removed, if false they will be serialized in the document (which can possible lead to a  larger file)")
    public Boolean isDeletePicturesCroppedAreas() {
        return this.deletePicturesCroppedAreas;
    }

    public void setDeletePicturesCroppedAreas(Boolean deletePicturesCroppedAreas) {
        this.deletePicturesCroppedAreas = deletePicturesCroppedAreas;
    }

    public SvgExportOptions externalFontsHandling(ExternalFontsHandlingEnum externalFontsHandling) {
        this.externalFontsHandling = externalFontsHandling;
        return this;
    }

    @ApiModelProperty(value="Determines a way of handling externally loaded fonts.")
    public ExternalFontsHandlingEnum getExternalFontsHandling() {
        return this.externalFontsHandling;
    }

    public void setExternalFontsHandling(ExternalFontsHandlingEnum externalFontsHandling) {
        this.externalFontsHandling = externalFontsHandling;
    }

    public SvgExportOptions useFrameSize(Boolean useFrameSize) {
        this.useFrameSize = useFrameSize;
        return this;
    }

    @ApiModelProperty(value="Determines whether the text frame will be included in a rendering area or not.")
    public Boolean isUseFrameSize() {
        return this.useFrameSize;
    }

    public void setUseFrameSize(Boolean useFrameSize) {
        this.useFrameSize = useFrameSize;
    }

    public SvgExportOptions useFrameRotation(Boolean useFrameRotation) {
        this.useFrameRotation = useFrameRotation;
        return this;
    }

    @ApiModelProperty(value="Determines whether to perform the specified rotation of the shape when rendering or not.")
    public Boolean isUseFrameRotation() {
        return this.useFrameRotation;
    }

    public void setUseFrameRotation(Boolean useFrameRotation) {
        this.useFrameRotation = useFrameRotation;
    }

    public SvgExportOptions disableFontLigatures(Boolean disableFontLigatures) {
        this.disableFontLigatures = disableFontLigatures;
        return this;
    }

    @ApiModelProperty(value="true to disable ligatures in the rendered output.")
    public Boolean isDisableFontLigatures() {
        return this.disableFontLigatures;
    }

    public void setDisableFontLigatures(Boolean disableFontLigatures) {
        this.disableFontLigatures = disableFontLigatures;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SvgExportOptions svgExportOptions = (SvgExportOptions)o;
        return Objects.equals(this.vectorizeText, svgExportOptions.vectorizeText) && Objects.equals(this.metafileRasterizationDpi, svgExportOptions.metafileRasterizationDpi) && Objects.equals(this.disable3DText, svgExportOptions.disable3DText) && Objects.equals(this.disableGradientSplit, svgExportOptions.disableGradientSplit) && Objects.equals(this.disableLineEndCropping, svgExportOptions.disableLineEndCropping) && Objects.equals(this.jpegQuality, svgExportOptions.jpegQuality) && Objects.equals((Object)this.picturesCompression, (Object)svgExportOptions.picturesCompression) && Objects.equals(this.deletePicturesCroppedAreas, svgExportOptions.deletePicturesCroppedAreas) && Objects.equals((Object)this.externalFontsHandling, (Object)svgExportOptions.externalFontsHandling) && Objects.equals(this.useFrameSize, svgExportOptions.useFrameSize) && Objects.equals(this.useFrameRotation, svgExportOptions.useFrameRotation) && Objects.equals(this.disableFontLigatures, svgExportOptions.disableFontLigatures) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.vectorizeText, this.metafileRasterizationDpi, this.disable3DText, this.disableGradientSplit, this.disableLineEndCropping, this.jpegQuality, this.picturesCompression, this.deletePicturesCroppedAreas, this.externalFontsHandling, this.useFrameSize, this.useFrameRotation, this.disableFontLigatures, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SvgExportOptions {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    vectorizeText: ").append(this.toIndentedString(this.vectorizeText)).append("\n");
        sb.append("    metafileRasterizationDpi: ").append(this.toIndentedString(this.metafileRasterizationDpi)).append("\n");
        sb.append("    disable3DText: ").append(this.toIndentedString(this.disable3DText)).append("\n");
        sb.append("    disableGradientSplit: ").append(this.toIndentedString(this.disableGradientSplit)).append("\n");
        sb.append("    disableLineEndCropping: ").append(this.toIndentedString(this.disableLineEndCropping)).append("\n");
        sb.append("    jpegQuality: ").append(this.toIndentedString(this.jpegQuality)).append("\n");
        sb.append("    picturesCompression: ").append(this.toIndentedString((Object)this.picturesCompression)).append("\n");
        sb.append("    deletePicturesCroppedAreas: ").append(this.toIndentedString(this.deletePicturesCroppedAreas)).append("\n");
        sb.append("    externalFontsHandling: ").append(this.toIndentedString((Object)this.externalFontsHandling)).append("\n");
        sb.append("    useFrameSize: ").append(this.toIndentedString(this.useFrameSize)).append("\n");
        sb.append("    useFrameRotation: ").append(this.toIndentedString(this.useFrameRotation)).append("\n");
        sb.append("    disableFontLigatures: ").append(this.toIndentedString(this.disableFontLigatures)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ExternalFontsHandlingEnum {
        ADDLINKSTOFONTFILES("AddLinksToFontFiles"),
        EMBED("Embed"),
        VECTORIZE("Vectorize");

        private String value;

        private ExternalFontsHandlingEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ExternalFontsHandlingEnum fromValue(String text) {
            for (ExternalFontsHandlingEnum b : ExternalFontsHandlingEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ExternalFontsHandlingEnum> {
            public void write(JsonWriter jsonWriter, ExternalFontsHandlingEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ExternalFontsHandlingEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ExternalFontsHandlingEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PicturesCompressionEnum {
        DPI330("Dpi330"),
        DPI220("Dpi220"),
        DPI150("Dpi150"),
        DPI96("Dpi96"),
        DPI72("Dpi72"),
        DOCUMENTRESOLUTION("DocumentResolution");

        private String value;

        private PicturesCompressionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PicturesCompressionEnum fromValue(String text) {
            for (PicturesCompressionEnum b : PicturesCompressionEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<PicturesCompressionEnum> {
            public void write(JsonWriter jsonWriter, PicturesCompressionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PicturesCompressionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PicturesCompressionEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

