/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.FillFormat;
import com.aspose.slides.model.LineFormat;
import com.aspose.slides.model.ResourceUri;
import com.aspose.slides.model.TextFrameFormat;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Represents one cell of table.")
public class TableCell {
    @SerializedName(value="text", alternate={"Text"})
    private String text;
    @SerializedName(value="rowSpan", alternate={"RowSpan"})
    private Integer rowSpan;
    @SerializedName(value="colSpan", alternate={"ColSpan"})
    private Integer colSpan;
    @SerializedName(value="marginTop", alternate={"MarginTop"})
    private Double marginTop;
    @SerializedName(value="marginRight", alternate={"MarginRight"})
    private Double marginRight;
    @SerializedName(value="marginLeft", alternate={"MarginLeft"})
    private Double marginLeft;
    @SerializedName(value="marginBottom", alternate={"MarginBottom"})
    private Double marginBottom;
    @SerializedName(value="transparency", alternate={"Transparency"})
    private Double transparency;
    @SerializedName(value="textAnchorType", alternate={"TextAnchorType"})
    private TextAnchorTypeEnum textAnchorType;
    @SerializedName(value="textVerticalType", alternate={"TextVerticalType"})
    private TextVerticalTypeEnum textVerticalType;
    @SerializedName(value="fillFormat", alternate={"FillFormat"})
    private FillFormat fillFormat;
    @SerializedName(value="borderTop", alternate={"BorderTop"})
    private LineFormat borderTop;
    @SerializedName(value="borderRight", alternate={"BorderRight"})
    private LineFormat borderRight;
    @SerializedName(value="borderLeft", alternate={"BorderLeft"})
    private LineFormat borderLeft;
    @SerializedName(value="borderBottom", alternate={"BorderBottom"})
    private LineFormat borderBottom;
    @SerializedName(value="borderDiagonalUp", alternate={"BorderDiagonalUp"})
    private LineFormat borderDiagonalUp;
    @SerializedName(value="borderDiagonalDown", alternate={"BorderDiagonalDown"})
    private LineFormat borderDiagonalDown;
    @SerializedName(value="columnIndex", alternate={"ColumnIndex"})
    private Integer columnIndex;
    @SerializedName(value="rowIndex", alternate={"RowIndex"})
    private Integer rowIndex;
    @SerializedName(value="textFrameFormat", alternate={"TextFrameFormat"})
    private TextFrameFormat textFrameFormat;
    @SerializedName(value="paragraphs", alternate={"Paragraphs"})
    private ResourceUri paragraphs;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public TableCell text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(value="Cell text.")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public TableCell rowSpan(Integer rowSpan) {
        this.rowSpan = rowSpan;
        return this;
    }

    @ApiModelProperty(value="The number of rows spanned by a merged cell.")
    public Integer getRowSpan() {
        return this.rowSpan;
    }

    public void setRowSpan(Integer rowSpan) {
        this.rowSpan = rowSpan;
    }

    public TableCell colSpan(Integer colSpan) {
        this.colSpan = colSpan;
        return this;
    }

    @ApiModelProperty(value="The number of columns spanned by a merged cell.")
    public Integer getColSpan() {
        return this.colSpan;
    }

    public void setColSpan(Integer colSpan) {
        this.colSpan = colSpan;
    }

    public TableCell marginTop(Double marginTop) {
        this.marginTop = marginTop;
        return this;
    }

    @ApiModelProperty(value="The top margin of the cell.")
    public Double getMarginTop() {
        return this.marginTop;
    }

    public void setMarginTop(Double marginTop) {
        this.marginTop = marginTop;
    }

    public TableCell marginRight(Double marginRight) {
        this.marginRight = marginRight;
        return this;
    }

    @ApiModelProperty(value="The right margin of the cell.")
    public Double getMarginRight() {
        return this.marginRight;
    }

    public void setMarginRight(Double marginRight) {
        this.marginRight = marginRight;
    }

    public TableCell marginLeft(Double marginLeft) {
        this.marginLeft = marginLeft;
        return this;
    }

    @ApiModelProperty(value="The left margin of the cell.")
    public Double getMarginLeft() {
        return this.marginLeft;
    }

    public void setMarginLeft(Double marginLeft) {
        this.marginLeft = marginLeft;
    }

    public TableCell marginBottom(Double marginBottom) {
        this.marginBottom = marginBottom;
        return this;
    }

    @ApiModelProperty(value="The bottom margin of the cell.")
    public Double getMarginBottom() {
        return this.marginBottom;
    }

    public void setMarginBottom(Double marginBottom) {
        this.marginBottom = marginBottom;
    }

    public TableCell transparency(Double transparency) {
        this.transparency = transparency;
        return this;
    }

    @ApiModelProperty(value="Transparency.")
    public Double getTransparency() {
        return this.transparency;
    }

    public void setTransparency(Double transparency) {
        this.transparency = transparency;
    }

    public TableCell textAnchorType(TextAnchorTypeEnum textAnchorType) {
        this.textAnchorType = textAnchorType;
        return this;
    }

    @ApiModelProperty(value="Text anchor type.")
    public TextAnchorTypeEnum getTextAnchorType() {
        return this.textAnchorType;
    }

    public void setTextAnchorType(TextAnchorTypeEnum textAnchorType) {
        this.textAnchorType = textAnchorType;
    }

    public TableCell textVerticalType(TextVerticalTypeEnum textVerticalType) {
        this.textVerticalType = textVerticalType;
        return this;
    }

    @ApiModelProperty(value="The type of vertical text.")
    public TextVerticalTypeEnum getTextVerticalType() {
        return this.textVerticalType;
    }

    public void setTextVerticalType(TextVerticalTypeEnum textVerticalType) {
        this.textVerticalType = textVerticalType;
    }

    public TableCell fillFormat(FillFormat fillFormat) {
        this.fillFormat = fillFormat;
        return this;
    }

    @ApiModelProperty(value="Fill properties set of the cell.")
    public FillFormat getFillFormat() {
        return this.fillFormat;
    }

    public void setFillFormat(FillFormat fillFormat) {
        this.fillFormat = fillFormat;
    }

    public TableCell borderTop(LineFormat borderTop) {
        this.borderTop = borderTop;
        return this;
    }

    @ApiModelProperty(value="Line properties set for the top border of the cell.")
    public LineFormat getBorderTop() {
        return this.borderTop;
    }

    public void setBorderTop(LineFormat borderTop) {
        this.borderTop = borderTop;
    }

    public TableCell borderRight(LineFormat borderRight) {
        this.borderRight = borderRight;
        return this;
    }

    @ApiModelProperty(value="Line properties set for the right border of the cell.")
    public LineFormat getBorderRight() {
        return this.borderRight;
    }

    public void setBorderRight(LineFormat borderRight) {
        this.borderRight = borderRight;
    }

    public TableCell borderLeft(LineFormat borderLeft) {
        this.borderLeft = borderLeft;
        return this;
    }

    @ApiModelProperty(value="Line properties set for the left border of the cell.")
    public LineFormat getBorderLeft() {
        return this.borderLeft;
    }

    public void setBorderLeft(LineFormat borderLeft) {
        this.borderLeft = borderLeft;
    }

    public TableCell borderBottom(LineFormat borderBottom) {
        this.borderBottom = borderBottom;
        return this;
    }

    @ApiModelProperty(value="Line properties set for the bottom border of the cell.")
    public LineFormat getBorderBottom() {
        return this.borderBottom;
    }

    public void setBorderBottom(LineFormat borderBottom) {
        this.borderBottom = borderBottom;
    }

    public TableCell borderDiagonalUp(LineFormat borderDiagonalUp) {
        this.borderDiagonalUp = borderDiagonalUp;
        return this;
    }

    @ApiModelProperty(value="Line properties set for the diagonal up border of the cell.")
    public LineFormat getBorderDiagonalUp() {
        return this.borderDiagonalUp;
    }

    public void setBorderDiagonalUp(LineFormat borderDiagonalUp) {
        this.borderDiagonalUp = borderDiagonalUp;
    }

    public TableCell borderDiagonalDown(LineFormat borderDiagonalDown) {
        this.borderDiagonalDown = borderDiagonalDown;
        return this;
    }

    @ApiModelProperty(value="Line properties set for the diagonal down border of the cell.")
    public LineFormat getBorderDiagonalDown() {
        return this.borderDiagonalDown;
    }

    public void setBorderDiagonalDown(LineFormat borderDiagonalDown) {
        this.borderDiagonalDown = borderDiagonalDown;
    }

    public TableCell columnIndex(Integer columnIndex) {
        this.columnIndex = columnIndex;
        return this;
    }

    @ApiModelProperty(value="Cell column index")
    public Integer getColumnIndex() {
        return this.columnIndex;
    }

    public void setColumnIndex(Integer columnIndex) {
        this.columnIndex = columnIndex;
    }

    public TableCell rowIndex(Integer rowIndex) {
        this.rowIndex = rowIndex;
        return this;
    }

    @ApiModelProperty(value="Cell row index")
    public Integer getRowIndex() {
        return this.rowIndex;
    }

    public void setRowIndex(Integer rowIndex) {
        this.rowIndex = rowIndex;
    }

    public TableCell textFrameFormat(TextFrameFormat textFrameFormat) {
        this.textFrameFormat = textFrameFormat;
        return this;
    }

    @ApiModelProperty(value="Returns TextFrame's formatting properties.")
    public TextFrameFormat getTextFrameFormat() {
        return this.textFrameFormat;
    }

    public void setTextFrameFormat(TextFrameFormat textFrameFormat) {
        this.textFrameFormat = textFrameFormat;
    }

    public TableCell paragraphs(ResourceUri paragraphs) {
        this.paragraphs = paragraphs;
        return this;
    }

    @ApiModelProperty(value="Get or sets list to paragraphs list")
    public ResourceUri getParagraphs() {
        return this.paragraphs;
    }

    public void setParagraphs(ResourceUri paragraphs) {
        this.paragraphs = paragraphs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableCell tableCell = (TableCell)o;
        return Objects.equals(this.text, tableCell.text) && Objects.equals(this.rowSpan, tableCell.rowSpan) && Objects.equals(this.colSpan, tableCell.colSpan) && Objects.equals(this.marginTop, tableCell.marginTop) && Objects.equals(this.marginRight, tableCell.marginRight) && Objects.equals(this.marginLeft, tableCell.marginLeft) && Objects.equals(this.marginBottom, tableCell.marginBottom) && Objects.equals(this.transparency, tableCell.transparency) && Objects.equals((Object)this.textAnchorType, (Object)tableCell.textAnchorType) && Objects.equals((Object)this.textVerticalType, (Object)tableCell.textVerticalType) && Objects.equals(this.fillFormat, tableCell.fillFormat) && Objects.equals(this.borderTop, tableCell.borderTop) && Objects.equals(this.borderRight, tableCell.borderRight) && Objects.equals(this.borderLeft, tableCell.borderLeft) && Objects.equals(this.borderBottom, tableCell.borderBottom) && Objects.equals(this.borderDiagonalUp, tableCell.borderDiagonalUp) && Objects.equals(this.borderDiagonalDown, tableCell.borderDiagonalDown) && Objects.equals(this.columnIndex, tableCell.columnIndex) && Objects.equals(this.rowIndex, tableCell.rowIndex) && Objects.equals(this.textFrameFormat, tableCell.textFrameFormat) && Objects.equals(this.paragraphs, tableCell.paragraphs);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.text, this.rowSpan, this.colSpan, this.marginTop, this.marginRight, this.marginLeft, this.marginBottom, this.transparency, this.textAnchorType, this.textVerticalType, this.fillFormat, this.borderTop, this.borderRight, this.borderLeft, this.borderBottom, this.borderDiagonalUp, this.borderDiagonalDown, this.columnIndex, this.rowIndex, this.textFrameFormat, this.paragraphs});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TableCell {\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    rowSpan: ").append(this.toIndentedString(this.rowSpan)).append("\n");
        sb.append("    colSpan: ").append(this.toIndentedString(this.colSpan)).append("\n");
        sb.append("    marginTop: ").append(this.toIndentedString(this.marginTop)).append("\n");
        sb.append("    marginRight: ").append(this.toIndentedString(this.marginRight)).append("\n");
        sb.append("    marginLeft: ").append(this.toIndentedString(this.marginLeft)).append("\n");
        sb.append("    marginBottom: ").append(this.toIndentedString(this.marginBottom)).append("\n");
        sb.append("    transparency: ").append(this.toIndentedString(this.transparency)).append("\n");
        sb.append("    textAnchorType: ").append(this.toIndentedString((Object)this.textAnchorType)).append("\n");
        sb.append("    textVerticalType: ").append(this.toIndentedString((Object)this.textVerticalType)).append("\n");
        sb.append("    fillFormat: ").append(this.toIndentedString(this.fillFormat)).append("\n");
        sb.append("    borderTop: ").append(this.toIndentedString(this.borderTop)).append("\n");
        sb.append("    borderRight: ").append(this.toIndentedString(this.borderRight)).append("\n");
        sb.append("    borderLeft: ").append(this.toIndentedString(this.borderLeft)).append("\n");
        sb.append("    borderBottom: ").append(this.toIndentedString(this.borderBottom)).append("\n");
        sb.append("    borderDiagonalUp: ").append(this.toIndentedString(this.borderDiagonalUp)).append("\n");
        sb.append("    borderDiagonalDown: ").append(this.toIndentedString(this.borderDiagonalDown)).append("\n");
        sb.append("    columnIndex: ").append(this.toIndentedString(this.columnIndex)).append("\n");
        sb.append("    rowIndex: ").append(this.toIndentedString(this.rowIndex)).append("\n");
        sb.append("    textFrameFormat: ").append(this.toIndentedString(this.textFrameFormat)).append("\n");
        sb.append("    paragraphs: ").append(this.toIndentedString(this.paragraphs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TextVerticalTypeEnum {
        HORIZONTAL("Horizontal"),
        VERTICAL("Vertical"),
        VERTICAL270("Vertical270"),
        WORDARTVERTICAL("WordArtVertical"),
        EASTASIANVERTICAL("EastAsianVertical"),
        MONGOLIANVERTICAL("MongolianVertical"),
        WORDARTVERTICALRIGHTTOLEFT("WordArtVerticalRightToLeft"),
        NOTDEFINED("NotDefined");

        private String value;

        private TextVerticalTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TextVerticalTypeEnum fromValue(String text) {
            for (TextVerticalTypeEnum b : TextVerticalTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TextVerticalTypeEnum> {
            public void write(JsonWriter jsonWriter, TextVerticalTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TextVerticalTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TextVerticalTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TextAnchorTypeEnum {
        TOP("Top"),
        CENTER("Center"),
        BOTTOM("Bottom"),
        JUSTIFIED("Justified"),
        DISTRIBUTED("Distributed"),
        NOTDEFINED("NotDefined");

        private String value;

        private TextAnchorTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TextAnchorTypeEnum fromValue(String text) {
            for (TextAnchorTypeEnum b : TextAnchorTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TextAnchorTypeEnum> {
            public void write(JsonWriter jsonWriter, TextAnchorTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TextAnchorTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TextAnchorTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

