/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.ParagraphFormat;
import com.aspose.slides.model.ThreeDFormat;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Contains the TextFrame's formatting properties.")
public class TextFrameFormat {
    @SerializedName(value="threeDFormat", alternate={"ThreeDFormat"})
    private ThreeDFormat threeDFormat;
    @SerializedName(value="transform", alternate={"Transform"})
    private TransformEnum transform;
    @SerializedName(value="marginLeft", alternate={"MarginLeft"})
    private Double marginLeft;
    @SerializedName(value="marginRight", alternate={"MarginRight"})
    private Double marginRight;
    @SerializedName(value="marginTop", alternate={"MarginTop"})
    private Double marginTop;
    @SerializedName(value="marginBottom", alternate={"MarginBottom"})
    private Double marginBottom;
    @SerializedName(value="wrapText", alternate={"WrapText"})
    private WrapTextEnum wrapText;
    @SerializedName(value="anchoringType", alternate={"AnchoringType"})
    private AnchoringTypeEnum anchoringType;
    @SerializedName(value="centerText", alternate={"CenterText"})
    private CenterTextEnum centerText;
    @SerializedName(value="textVerticalType", alternate={"TextVerticalType"})
    private TextVerticalTypeEnum textVerticalType;
    @SerializedName(value="autofitType", alternate={"AutofitType"})
    private AutofitTypeEnum autofitType;
    @SerializedName(value="columnCount", alternate={"ColumnCount"})
    private Integer columnCount;
    @SerializedName(value="columnSpacing", alternate={"ColumnSpacing"})
    private Double columnSpacing;
    @SerializedName(value="keepTextFlat", alternate={"KeepTextFlat"})
    private Boolean keepTextFlat;
    @SerializedName(value="rotationAngle", alternate={"RotationAngle"})
    private Double rotationAngle;
    @SerializedName(value="defaultParagraphFormat", alternate={"DefaultParagraphFormat"})
    private ParagraphFormat defaultParagraphFormat;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public TextFrameFormat threeDFormat(ThreeDFormat threeDFormat) {
        this.threeDFormat = threeDFormat;
        return this;
    }

    @ApiModelProperty(value="Represents 3d effect properties for a text.")
    public ThreeDFormat getThreeDFormat() {
        return this.threeDFormat;
    }

    public void setThreeDFormat(ThreeDFormat threeDFormat) {
        this.threeDFormat = threeDFormat;
    }

    public TextFrameFormat transform(TransformEnum transform) {
        this.transform = transform;
        return this;
    }

    @ApiModelProperty(value="Gets or sets text wrapping shape.")
    public TransformEnum getTransform() {
        return this.transform;
    }

    public void setTransform(TransformEnum transform) {
        this.transform = transform;
    }

    public TextFrameFormat marginLeft(Double marginLeft) {
        this.marginLeft = marginLeft;
        return this;
    }

    @ApiModelProperty(value="Left margin. Left margin.")
    public Double getMarginLeft() {
        return this.marginLeft;
    }

    public void setMarginLeft(Double marginLeft) {
        this.marginLeft = marginLeft;
    }

    public TextFrameFormat marginRight(Double marginRight) {
        this.marginRight = marginRight;
        return this;
    }

    @ApiModelProperty(value="Right margin.")
    public Double getMarginRight() {
        return this.marginRight;
    }

    public void setMarginRight(Double marginRight) {
        this.marginRight = marginRight;
    }

    public TextFrameFormat marginTop(Double marginTop) {
        this.marginTop = marginTop;
        return this;
    }

    @ApiModelProperty(value="Top margin.")
    public Double getMarginTop() {
        return this.marginTop;
    }

    public void setMarginTop(Double marginTop) {
        this.marginTop = marginTop;
    }

    public TextFrameFormat marginBottom(Double marginBottom) {
        this.marginBottom = marginBottom;
        return this;
    }

    @ApiModelProperty(value="Bottom margin.")
    public Double getMarginBottom() {
        return this.marginBottom;
    }

    public void setMarginBottom(Double marginBottom) {
        this.marginBottom = marginBottom;
    }

    public TextFrameFormat wrapText(WrapTextEnum wrapText) {
        this.wrapText = wrapText;
        return this;
    }

    @ApiModelProperty(value="True if text is wrapped at TextFrame's margins.")
    public WrapTextEnum getWrapText() {
        return this.wrapText;
    }

    public void setWrapText(WrapTextEnum wrapText) {
        this.wrapText = wrapText;
    }

    public TextFrameFormat anchoringType(AnchoringTypeEnum anchoringType) {
        this.anchoringType = anchoringType;
        return this;
    }

    @ApiModelProperty(value="Returns or sets vertical anchor text in a TextFrame.")
    public AnchoringTypeEnum getAnchoringType() {
        return this.anchoringType;
    }

    public void setAnchoringType(AnchoringTypeEnum anchoringType) {
        this.anchoringType = anchoringType;
    }

    public TextFrameFormat centerText(CenterTextEnum centerText) {
        this.centerText = centerText;
        return this;
    }

    @ApiModelProperty(value="If True then text should be centered in box horizontally.")
    public CenterTextEnum getCenterText() {
        return this.centerText;
    }

    public void setCenterText(CenterTextEnum centerText) {
        this.centerText = centerText;
    }

    public TextFrameFormat textVerticalType(TextVerticalTypeEnum textVerticalType) {
        this.textVerticalType = textVerticalType;
        return this;
    }

    @ApiModelProperty(value="Determines text orientation. The resulted value of visual text rotation summarized from this property and custom angle in property RotationAngle.")
    public TextVerticalTypeEnum getTextVerticalType() {
        return this.textVerticalType;
    }

    public void setTextVerticalType(TextVerticalTypeEnum textVerticalType) {
        this.textVerticalType = textVerticalType;
    }

    public TextFrameFormat autofitType(AutofitTypeEnum autofitType) {
        this.autofitType = autofitType;
        return this;
    }

    @ApiModelProperty(value="Returns or sets text's auto-fit mode.")
    public AutofitTypeEnum getAutofitType() {
        return this.autofitType;
    }

    public void setAutofitType(AutofitTypeEnum autofitType) {
        this.autofitType = autofitType;
    }

    public TextFrameFormat columnCount(Integer columnCount) {
        this.columnCount = columnCount;
        return this;
    }

    @ApiModelProperty(value="Returns or sets number of columns in the text area. This value must be a positive number. Otherwise, the value will be set to zero.  Value 0 means undefined value.")
    public Integer getColumnCount() {
        return this.columnCount;
    }

    public void setColumnCount(Integer columnCount) {
        this.columnCount = columnCount;
    }

    public TextFrameFormat columnSpacing(Double columnSpacing) {
        this.columnSpacing = columnSpacing;
        return this;
    }

    @ApiModelProperty(value="Returns or sets the space between text columns in the text area (in points). This should only apply  when there is more than 1 column present. This value must be a positive number. Otherwise, the value will be set to zero. ")
    public Double getColumnSpacing() {
        return this.columnSpacing;
    }

    public void setColumnSpacing(Double columnSpacing) {
        this.columnSpacing = columnSpacing;
    }

    public TextFrameFormat keepTextFlat(Boolean keepTextFlat) {
        this.keepTextFlat = keepTextFlat;
        return this;
    }

    @ApiModelProperty(value="Returns or set keeping text out of 3D scene entirely.")
    public Boolean isKeepTextFlat() {
        return this.keepTextFlat;
    }

    public void setKeepTextFlat(Boolean keepTextFlat) {
        this.keepTextFlat = keepTextFlat;
    }

    public TextFrameFormat rotationAngle(Double rotationAngle) {
        this.rotationAngle = rotationAngle;
        return this;
    }

    @ApiModelProperty(value="Specifies the custom rotation that is being applied to the text within the bounding box.")
    public Double getRotationAngle() {
        return this.rotationAngle;
    }

    public void setRotationAngle(Double rotationAngle) {
        this.rotationAngle = rotationAngle;
    }

    public TextFrameFormat defaultParagraphFormat(ParagraphFormat defaultParagraphFormat) {
        this.defaultParagraphFormat = defaultParagraphFormat;
        return this;
    }

    @ApiModelProperty(value="Default portion format.")
    public ParagraphFormat getDefaultParagraphFormat() {
        return this.defaultParagraphFormat;
    }

    public void setDefaultParagraphFormat(ParagraphFormat defaultParagraphFormat) {
        this.defaultParagraphFormat = defaultParagraphFormat;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextFrameFormat textFrameFormat = (TextFrameFormat)o;
        return Objects.equals(this.threeDFormat, textFrameFormat.threeDFormat) && Objects.equals((Object)this.transform, (Object)textFrameFormat.transform) && Objects.equals(this.marginLeft, textFrameFormat.marginLeft) && Objects.equals(this.marginRight, textFrameFormat.marginRight) && Objects.equals(this.marginTop, textFrameFormat.marginTop) && Objects.equals(this.marginBottom, textFrameFormat.marginBottom) && Objects.equals((Object)this.wrapText, (Object)textFrameFormat.wrapText) && Objects.equals((Object)this.anchoringType, (Object)textFrameFormat.anchoringType) && Objects.equals((Object)this.centerText, (Object)textFrameFormat.centerText) && Objects.equals((Object)this.textVerticalType, (Object)textFrameFormat.textVerticalType) && Objects.equals((Object)this.autofitType, (Object)textFrameFormat.autofitType) && Objects.equals(this.columnCount, textFrameFormat.columnCount) && Objects.equals(this.columnSpacing, textFrameFormat.columnSpacing) && Objects.equals(this.keepTextFlat, textFrameFormat.keepTextFlat) && Objects.equals(this.rotationAngle, textFrameFormat.rotationAngle) && Objects.equals(this.defaultParagraphFormat, textFrameFormat.defaultParagraphFormat);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.threeDFormat, this.transform, this.marginLeft, this.marginRight, this.marginTop, this.marginBottom, this.wrapText, this.anchoringType, this.centerText, this.textVerticalType, this.autofitType, this.columnCount, this.columnSpacing, this.keepTextFlat, this.rotationAngle, this.defaultParagraphFormat});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TextFrameFormat {\n");
        sb.append("    threeDFormat: ").append(this.toIndentedString(this.threeDFormat)).append("\n");
        sb.append("    transform: ").append(this.toIndentedString((Object)this.transform)).append("\n");
        sb.append("    marginLeft: ").append(this.toIndentedString(this.marginLeft)).append("\n");
        sb.append("    marginRight: ").append(this.toIndentedString(this.marginRight)).append("\n");
        sb.append("    marginTop: ").append(this.toIndentedString(this.marginTop)).append("\n");
        sb.append("    marginBottom: ").append(this.toIndentedString(this.marginBottom)).append("\n");
        sb.append("    wrapText: ").append(this.toIndentedString((Object)this.wrapText)).append("\n");
        sb.append("    anchoringType: ").append(this.toIndentedString((Object)this.anchoringType)).append("\n");
        sb.append("    centerText: ").append(this.toIndentedString((Object)this.centerText)).append("\n");
        sb.append("    textVerticalType: ").append(this.toIndentedString((Object)this.textVerticalType)).append("\n");
        sb.append("    autofitType: ").append(this.toIndentedString((Object)this.autofitType)).append("\n");
        sb.append("    columnCount: ").append(this.toIndentedString(this.columnCount)).append("\n");
        sb.append("    columnSpacing: ").append(this.toIndentedString(this.columnSpacing)).append("\n");
        sb.append("    keepTextFlat: ").append(this.toIndentedString(this.keepTextFlat)).append("\n");
        sb.append("    rotationAngle: ").append(this.toIndentedString(this.rotationAngle)).append("\n");
        sb.append("    defaultParagraphFormat: ").append(this.toIndentedString(this.defaultParagraphFormat)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum AutofitTypeEnum {
        NONE("None"),
        NORMAL("Normal"),
        SHAPE("Shape"),
        NOTDEFINED("NotDefined");

        private String value;

        private AutofitTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static AutofitTypeEnum fromValue(String text) {
            for (AutofitTypeEnum b : AutofitTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<AutofitTypeEnum> {
            public void write(JsonWriter jsonWriter, AutofitTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public AutofitTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return AutofitTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TextVerticalTypeEnum {
        HORIZONTAL("Horizontal"),
        VERTICAL("Vertical"),
        VERTICAL270("Vertical270"),
        WORDARTVERTICAL("WordArtVertical"),
        EASTASIANVERTICAL("EastAsianVertical"),
        MONGOLIANVERTICAL("MongolianVertical"),
        WORDARTVERTICALRIGHTTOLEFT("WordArtVerticalRightToLeft"),
        NOTDEFINED("NotDefined");

        private String value;

        private TextVerticalTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TextVerticalTypeEnum fromValue(String text) {
            for (TextVerticalTypeEnum b : TextVerticalTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TextVerticalTypeEnum> {
            public void write(JsonWriter jsonWriter, TextVerticalTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TextVerticalTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TextVerticalTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CenterTextEnum {
        FALSE("False"),
        TRUE("True"),
        NOTDEFINED("NotDefined");

        private String value;

        private CenterTextEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CenterTextEnum fromValue(String text) {
            for (CenterTextEnum b : CenterTextEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<CenterTextEnum> {
            public void write(JsonWriter jsonWriter, CenterTextEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public CenterTextEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CenterTextEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum AnchoringTypeEnum {
        TOP("Top"),
        CENTER("Center"),
        BOTTOM("Bottom"),
        JUSTIFIED("Justified"),
        DISTRIBUTED("Distributed"),
        NOTDEFINED("NotDefined");

        private String value;

        private AnchoringTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static AnchoringTypeEnum fromValue(String text) {
            for (AnchoringTypeEnum b : AnchoringTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<AnchoringTypeEnum> {
            public void write(JsonWriter jsonWriter, AnchoringTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public AnchoringTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return AnchoringTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum WrapTextEnum {
        FALSE("False"),
        TRUE("True"),
        NOTDEFINED("NotDefined");

        private String value;

        private WrapTextEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static WrapTextEnum fromValue(String text) {
            for (WrapTextEnum b : WrapTextEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<WrapTextEnum> {
            public void write(JsonWriter jsonWriter, WrapTextEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public WrapTextEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return WrapTextEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TransformEnum {
        NONE("None"),
        PLAIN("Plain"),
        STOP("Stop"),
        TRIANGLE("Triangle"),
        TRIANGLEINVERTED("TriangleInverted"),
        CHEVRON("Chevron"),
        CHEVRONINVERTED("ChevronInverted"),
        RINGINSIDE("RingInside"),
        RINGOUTSIDE("RingOutside"),
        ARCHUP("ArchUp"),
        ARCHDOWN("ArchDown"),
        CIRCLE("Circle"),
        BUTTON("Button"),
        ARCHUPPOUR("ArchUpPour"),
        ARCHDOWNPOUR("ArchDownPour"),
        CIRCLEPOUR("CirclePour"),
        BUTTONPOUR("ButtonPour"),
        CURVEUP("CurveUp"),
        CURVEDOWN("CurveDown"),
        CANUP("CanUp"),
        CANDOWN("CanDown"),
        WAVE1("Wave1"),
        WAVE2("Wave2"),
        DOUBLEWAVE1("DoubleWave1"),
        WAVE4("Wave4"),
        INFLATE("Inflate"),
        DEFLATE("Deflate"),
        INFLATEBOTTOM("InflateBottom"),
        DEFLATEBOTTOM("DeflateBottom"),
        INFLATETOP("InflateTop"),
        DEFLATETOP("DeflateTop"),
        DEFLATEINFLATE("DeflateInflate"),
        DEFLATEINFLATEDEFLATE("DeflateInflateDeflate"),
        FADERIGHT("FadeRight"),
        FADELEFT("FadeLeft"),
        FADEUP("FadeUp"),
        FADEDOWN("FadeDown"),
        SLANTUP("SlantUp"),
        SLANTDOWN("SlantDown"),
        CASCADEUP("CascadeUp"),
        CASCADEDOWN("CascadeDown"),
        CUSTOM("Custom"),
        NOTDEFINED("NotDefined");

        private String value;

        private TransformEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TransformEnum fromValue(String text) {
            for (TransformEnum b : TransformEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TransformEnum> {
            public void write(JsonWriter jsonWriter, TransformEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TransformEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TransformEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

