/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.GeometryShape;
import com.aspose.slides.model.PictureFill;
import com.aspose.slides.model.ShapeBase;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Represents VideoFrame resource.")
public class VideoFrame
extends GeometryShape {
    @SerializedName(value="fullScreenMode", alternate={"FullScreenMode"})
    private Boolean fullScreenMode;
    @SerializedName(value="hideAtShowing", alternate={"HideAtShowing"})
    private Boolean hideAtShowing;
    @SerializedName(value="playLoopMode", alternate={"PlayLoopMode"})
    private Boolean playLoopMode;
    @SerializedName(value="playMode", alternate={"PlayMode"})
    private PlayModeEnum playMode;
    @SerializedName(value="rewindVideo", alternate={"RewindVideo"})
    private Boolean rewindVideo;
    @SerializedName(value="volume", alternate={"Volume"})
    private VolumeEnum volume;
    @SerializedName(value="base64Data", alternate={"Base64Data"})
    private String base64Data;
    @SerializedName(value="pictureFillFormat", alternate={"PictureFillFormat"})
    private PictureFill pictureFillFormat;
    @SerializedName(value="trimFromStart", alternate={"TrimFromStart"})
    private Double trimFromStart;
    @SerializedName(value="trimFromEnd", alternate={"TrimFromEnd"})
    private Double trimFromEnd;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public VideoFrame() {
        this.setType(ShapeBase.TypeEnum.VIDEOFRAME);
    }

    public VideoFrame fullScreenMode(Boolean fullScreenMode) {
        this.fullScreenMode = fullScreenMode;
        return this;
    }

    @ApiModelProperty(value="Determines whether a video is shown in full screen mode.")
    public Boolean isFullScreenMode() {
        return this.fullScreenMode;
    }

    public void setFullScreenMode(Boolean fullScreenMode) {
        this.fullScreenMode = fullScreenMode;
    }

    public VideoFrame hideAtShowing(Boolean hideAtShowing) {
        this.hideAtShowing = hideAtShowing;
        return this;
    }

    @ApiModelProperty(value="Determines whether a VideoFrame is hidden. ")
    public Boolean isHideAtShowing() {
        return this.hideAtShowing;
    }

    public void setHideAtShowing(Boolean hideAtShowing) {
        this.hideAtShowing = hideAtShowing;
    }

    public VideoFrame playLoopMode(Boolean playLoopMode) {
        this.playLoopMode = playLoopMode;
        return this;
    }

    @ApiModelProperty(value="Determines whether a video is looped.")
    public Boolean isPlayLoopMode() {
        return this.playLoopMode;
    }

    public void setPlayLoopMode(Boolean playLoopMode) {
        this.playLoopMode = playLoopMode;
    }

    public VideoFrame playMode(PlayModeEnum playMode) {
        this.playMode = playMode;
        return this;
    }

    @ApiModelProperty(value="Returns or sets the video play mode.  ")
    public PlayModeEnum getPlayMode() {
        return this.playMode;
    }

    public void setPlayMode(PlayModeEnum playMode) {
        this.playMode = playMode;
    }

    public VideoFrame rewindVideo(Boolean rewindVideo) {
        this.rewindVideo = rewindVideo;
        return this;
    }

    @ApiModelProperty(value="Determines whether a video is automatically rewinded to start as soon as the movie has finished playing")
    public Boolean isRewindVideo() {
        return this.rewindVideo;
    }

    public void setRewindVideo(Boolean rewindVideo) {
        this.rewindVideo = rewindVideo;
    }

    public VideoFrame volume(VolumeEnum volume) {
        this.volume = volume;
        return this;
    }

    @ApiModelProperty(value="Returns or sets the audio volume.")
    public VolumeEnum getVolume() {
        return this.volume;
    }

    public void setVolume(VolumeEnum volume) {
        this.volume = volume;
    }

    public VideoFrame base64Data(String base64Data) {
        this.base64Data = base64Data;
        return this;
    }

    @ApiModelProperty(value="Video data encoded in base64.")
    public String getBase64Data() {
        return this.base64Data;
    }

    public void setBase64Data(String base64Data) {
        this.base64Data = base64Data;
    }

    public VideoFrame pictureFillFormat(PictureFill pictureFillFormat) {
        this.pictureFillFormat = pictureFillFormat;
        return this;
    }

    @ApiModelProperty(value="Picture fill format.")
    public PictureFill getPictureFillFormat() {
        return this.pictureFillFormat;
    }

    public void setPictureFillFormat(PictureFill pictureFillFormat) {
        this.pictureFillFormat = pictureFillFormat;
    }

    public VideoFrame trimFromStart(Double trimFromStart) {
        this.trimFromStart = trimFromStart;
        return this;
    }

    @ApiModelProperty(value="Trim start [ms]")
    public Double getTrimFromStart() {
        return this.trimFromStart;
    }

    public void setTrimFromStart(Double trimFromStart) {
        this.trimFromStart = trimFromStart;
    }

    public VideoFrame trimFromEnd(Double trimFromEnd) {
        this.trimFromEnd = trimFromEnd;
        return this;
    }

    @ApiModelProperty(value="Trim end [ms]")
    public Double getTrimFromEnd() {
        return this.trimFromEnd;
    }

    public void setTrimFromEnd(Double trimFromEnd) {
        this.trimFromEnd = trimFromEnd;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VideoFrame videoFrame = (VideoFrame)o;
        return Objects.equals(this.fullScreenMode, videoFrame.fullScreenMode) && Objects.equals(this.hideAtShowing, videoFrame.hideAtShowing) && Objects.equals(this.playLoopMode, videoFrame.playLoopMode) && Objects.equals((Object)this.playMode, (Object)videoFrame.playMode) && Objects.equals(this.rewindVideo, videoFrame.rewindVideo) && Objects.equals((Object)this.volume, (Object)videoFrame.volume) && Objects.equals(this.base64Data, videoFrame.base64Data) && Objects.equals(this.pictureFillFormat, videoFrame.pictureFillFormat) && Objects.equals(this.trimFromStart, videoFrame.trimFromStart) && Objects.equals(this.trimFromEnd, videoFrame.trimFromEnd) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.fullScreenMode, this.hideAtShowing, this.playLoopMode, this.playMode, this.rewindVideo, this.volume, this.base64Data, this.pictureFillFormat, this.trimFromStart, this.trimFromEnd, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VideoFrame {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    fullScreenMode: ").append(this.toIndentedString(this.fullScreenMode)).append("\n");
        sb.append("    hideAtShowing: ").append(this.toIndentedString(this.hideAtShowing)).append("\n");
        sb.append("    playLoopMode: ").append(this.toIndentedString(this.playLoopMode)).append("\n");
        sb.append("    playMode: ").append(this.toIndentedString((Object)this.playMode)).append("\n");
        sb.append("    rewindVideo: ").append(this.toIndentedString(this.rewindVideo)).append("\n");
        sb.append("    volume: ").append(this.toIndentedString((Object)this.volume)).append("\n");
        sb.append("    base64Data: ").append(this.toIndentedString(this.base64Data)).append("\n");
        sb.append("    pictureFillFormat: ").append(this.toIndentedString(this.pictureFillFormat)).append("\n");
        sb.append("    trimFromStart: ").append(this.toIndentedString(this.trimFromStart)).append("\n");
        sb.append("    trimFromEnd: ").append(this.toIndentedString(this.trimFromEnd)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    static {
        typeDeterminers.put("Type", (Object)ShapeBase.TypeEnum.VIDEOFRAME);
    }

    @JsonAdapter(value=Adapter.class)
    public static enum VolumeEnum {
        MUTE("Mute"),
        LOW("Low"),
        MEDIUM("Medium"),
        LOUD("Loud"),
        MIXED("Mixed");

        private String value;

        private VolumeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static VolumeEnum fromValue(String text) {
            for (VolumeEnum b : VolumeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<VolumeEnum> {
            public void write(JsonWriter jsonWriter, VolumeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public VolumeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return VolumeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PlayModeEnum {
        AUTO("Auto"),
        ONCLICK("OnClick"),
        ALLSLIDES("AllSlides"),
        INCLICKSEQUENCE("InClickSequence"),
        MIXED("Mixed");

        private String value;

        private PlayModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PlayModeEnum fromValue(String text) {
            for (PlayModeEnum b : PlayModeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<PlayModeEnum> {
            public void write(JsonWriter jsonWriter, PlayModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PlayModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PlayModeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

