/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.CommonSlideViewProperties;
import com.aspose.slides.model.NormalViewRestoredProperties;
import com.aspose.slides.model.ResourceBase;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Slides document properties.")
public class ViewProperties
extends ResourceBase {
    @SerializedName(value="lastView", alternate={"LastView"})
    private LastViewEnum lastView;
    @SerializedName(value="horizontalBarState", alternate={"HorizontalBarState"})
    private HorizontalBarStateEnum horizontalBarState;
    @SerializedName(value="verticalBarState", alternate={"VerticalBarState"})
    private VerticalBarStateEnum verticalBarState;
    @SerializedName(value="preferSingleView", alternate={"PreferSingleView"})
    private Boolean preferSingleView;
    @SerializedName(value="restoredLeft", alternate={"RestoredLeft"})
    private NormalViewRestoredProperties restoredLeft;
    @SerializedName(value="restoredTop", alternate={"RestoredTop"})
    private NormalViewRestoredProperties restoredTop;
    @SerializedName(value="slideViewProperties", alternate={"SlideViewProperties"})
    private CommonSlideViewProperties slideViewProperties;
    @SerializedName(value="notesViewProperties", alternate={"NotesViewProperties"})
    private CommonSlideViewProperties notesViewProperties;
    @SerializedName(value="showComments", alternate={"ShowComments"})
    private ShowCommentsEnum showComments;
    @SerializedName(value="gridSpacing", alternate={"GridSpacing"})
    private Double gridSpacing;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public ViewProperties lastView(LastViewEnum lastView) {
        this.lastView = lastView;
        return this;
    }

    @ApiModelProperty(value="Last used view mode.")
    public LastViewEnum getLastView() {
        return this.lastView;
    }

    public void setLastView(LastViewEnum lastView) {
        this.lastView = lastView;
    }

    public ViewProperties horizontalBarState(HorizontalBarStateEnum horizontalBarState) {
        this.horizontalBarState = horizontalBarState;
        return this;
    }

    @ApiModelProperty(value="Horizontal bar state.")
    public HorizontalBarStateEnum getHorizontalBarState() {
        return this.horizontalBarState;
    }

    public void setHorizontalBarState(HorizontalBarStateEnum horizontalBarState) {
        this.horizontalBarState = horizontalBarState;
    }

    public ViewProperties verticalBarState(VerticalBarStateEnum verticalBarState) {
        this.verticalBarState = verticalBarState;
        return this;
    }

    @ApiModelProperty(value="Vertical bar state.")
    public VerticalBarStateEnum getVerticalBarState() {
        return this.verticalBarState;
    }

    public void setVerticalBarState(VerticalBarStateEnum verticalBarState) {
        this.verticalBarState = verticalBarState;
    }

    public ViewProperties preferSingleView(Boolean preferSingleView) {
        this.preferSingleView = preferSingleView;
        return this;
    }

    @ApiModelProperty(value="True to prefer single view.")
    public Boolean isPreferSingleView() {
        return this.preferSingleView;
    }

    public void setPreferSingleView(Boolean preferSingleView) {
        this.preferSingleView = preferSingleView;
    }

    public ViewProperties restoredLeft(NormalViewRestoredProperties restoredLeft) {
        this.restoredLeft = restoredLeft;
        return this;
    }

    @ApiModelProperty(value="The sizing of the side content region of the normal view, when the region is of a variable restored size.")
    public NormalViewRestoredProperties getRestoredLeft() {
        return this.restoredLeft;
    }

    public void setRestoredLeft(NormalViewRestoredProperties restoredLeft) {
        this.restoredLeft = restoredLeft;
    }

    public ViewProperties restoredTop(NormalViewRestoredProperties restoredTop) {
        this.restoredTop = restoredTop;
        return this;
    }

    @ApiModelProperty(value="The sizing of the top slide region of the normal view, when the region is of a variable restored size.")
    public NormalViewRestoredProperties getRestoredTop() {
        return this.restoredTop;
    }

    public void setRestoredTop(NormalViewRestoredProperties restoredTop) {
        this.restoredTop = restoredTop;
    }

    public ViewProperties slideViewProperties(CommonSlideViewProperties slideViewProperties) {
        this.slideViewProperties = slideViewProperties;
        return this;
    }

    @ApiModelProperty(value="Slide view mode properties.")
    public CommonSlideViewProperties getSlideViewProperties() {
        return this.slideViewProperties;
    }

    public void setSlideViewProperties(CommonSlideViewProperties slideViewProperties) {
        this.slideViewProperties = slideViewProperties;
    }

    public ViewProperties notesViewProperties(CommonSlideViewProperties notesViewProperties) {
        this.notesViewProperties = notesViewProperties;
        return this;
    }

    @ApiModelProperty(value="Notes view mode properties.")
    public CommonSlideViewProperties getNotesViewProperties() {
        return this.notesViewProperties;
    }

    public void setNotesViewProperties(CommonSlideViewProperties notesViewProperties) {
        this.notesViewProperties = notesViewProperties;
    }

    public ViewProperties showComments(ShowCommentsEnum showComments) {
        this.showComments = showComments;
        return this;
    }

    @ApiModelProperty(value="True if the comments should be shown.")
    public ShowCommentsEnum getShowComments() {
        return this.showComments;
    }

    public void setShowComments(ShowCommentsEnum showComments) {
        this.showComments = showComments;
    }

    public ViewProperties gridSpacing(Double gridSpacing) {
        this.gridSpacing = gridSpacing;
        return this;
    }

    @ApiModelProperty(value="The grid spacing that should be used for the grid underlying the presentation document, in points.")
    public Double getGridSpacing() {
        return this.gridSpacing;
    }

    public void setGridSpacing(Double gridSpacing) {
        this.gridSpacing = gridSpacing;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ViewProperties viewProperties = (ViewProperties)o;
        return Objects.equals((Object)this.lastView, (Object)viewProperties.lastView) && Objects.equals((Object)this.horizontalBarState, (Object)viewProperties.horizontalBarState) && Objects.equals((Object)this.verticalBarState, (Object)viewProperties.verticalBarState) && Objects.equals(this.preferSingleView, viewProperties.preferSingleView) && Objects.equals(this.restoredLeft, viewProperties.restoredLeft) && Objects.equals(this.restoredTop, viewProperties.restoredTop) && Objects.equals(this.slideViewProperties, viewProperties.slideViewProperties) && Objects.equals(this.notesViewProperties, viewProperties.notesViewProperties) && Objects.equals((Object)this.showComments, (Object)viewProperties.showComments) && Objects.equals(this.gridSpacing, viewProperties.gridSpacing) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.lastView, this.horizontalBarState, this.verticalBarState, this.preferSingleView, this.restoredLeft, this.restoredTop, this.slideViewProperties, this.notesViewProperties, this.showComments, this.gridSpacing, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ViewProperties {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    lastView: ").append(this.toIndentedString((Object)this.lastView)).append("\n");
        sb.append("    horizontalBarState: ").append(this.toIndentedString((Object)this.horizontalBarState)).append("\n");
        sb.append("    verticalBarState: ").append(this.toIndentedString((Object)this.verticalBarState)).append("\n");
        sb.append("    preferSingleView: ").append(this.toIndentedString(this.preferSingleView)).append("\n");
        sb.append("    restoredLeft: ").append(this.toIndentedString(this.restoredLeft)).append("\n");
        sb.append("    restoredTop: ").append(this.toIndentedString(this.restoredTop)).append("\n");
        sb.append("    slideViewProperties: ").append(this.toIndentedString(this.slideViewProperties)).append("\n");
        sb.append("    notesViewProperties: ").append(this.toIndentedString(this.notesViewProperties)).append("\n");
        sb.append("    showComments: ").append(this.toIndentedString((Object)this.showComments)).append("\n");
        sb.append("    gridSpacing: ").append(this.toIndentedString(this.gridSpacing)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ShowCommentsEnum {
        FALSE("False"),
        TRUE("True"),
        NOTDEFINED("NotDefined");

        private String value;

        private ShowCommentsEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ShowCommentsEnum fromValue(String text) {
            for (ShowCommentsEnum b : ShowCommentsEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ShowCommentsEnum> {
            public void write(JsonWriter jsonWriter, ShowCommentsEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ShowCommentsEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ShowCommentsEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum VerticalBarStateEnum {
        MINIMIZED("Minimized"),
        RESTORED("Restored"),
        MAXIMIZED("Maximized");

        private String value;

        private VerticalBarStateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static VerticalBarStateEnum fromValue(String text) {
            for (VerticalBarStateEnum b : VerticalBarStateEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<VerticalBarStateEnum> {
            public void write(JsonWriter jsonWriter, VerticalBarStateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public VerticalBarStateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return VerticalBarStateEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum HorizontalBarStateEnum {
        MINIMIZED("Minimized"),
        RESTORED("Restored"),
        MAXIMIZED("Maximized");

        private String value;

        private HorizontalBarStateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static HorizontalBarStateEnum fromValue(String text) {
            for (HorizontalBarStateEnum b : HorizontalBarStateEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<HorizontalBarStateEnum> {
            public void write(JsonWriter jsonWriter, HorizontalBarStateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public HorizontalBarStateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return HorizontalBarStateEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum LastViewEnum {
        NOTDEFINED("NotDefined"),
        SLIDEVIEW("SlideView"),
        SLIDEMASTERVIEW("SlideMasterView"),
        NOTESVIEW("NotesView"),
        HANDOUTVIEW("HandoutView"),
        NOTESMASTERVIEW("NotesMasterView"),
        OUTLINEVIEW("OutlineView"),
        SLIDESORTERVIEW("SlideSorterView"),
        SLIDETHUMBNAILVIEW("SlideThumbnailView");

        private String value;

        private LastViewEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static LastViewEnum fromValue(String text) {
            for (LastViewEnum b : LastViewEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<LastViewEnum> {
            public void write(JsonWriter jsonWriter, LastViewEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public LastViewEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return LastViewEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

