/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.ExportOptions;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Provides options that control how a presentation is saved in XPS format.")
public class XpsExportOptions
extends ExportOptions {
    @SerializedName(value="showHiddenSlides", alternate={"ShowHiddenSlides"})
    private Boolean showHiddenSlides;
    @SerializedName(value="saveMetafilesAsPng", alternate={"SaveMetafilesAsPng"})
    private Boolean saveMetafilesAsPng;
    @SerializedName(value="drawSlidesFrame", alternate={"DrawSlidesFrame"})
    private Boolean drawSlidesFrame;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public XpsExportOptions() {
        this.setFormat("XPS");
    }

    public XpsExportOptions showHiddenSlides(Boolean showHiddenSlides) {
        this.showHiddenSlides = showHiddenSlides;
        return this;
    }

    @ApiModelProperty(value="Specifies whether the generated document should include hidden slides or not. Default is false. ")
    public Boolean isShowHiddenSlides() {
        return this.showHiddenSlides;
    }

    public void setShowHiddenSlides(Boolean showHiddenSlides) {
        this.showHiddenSlides = showHiddenSlides;
    }

    public XpsExportOptions saveMetafilesAsPng(Boolean saveMetafilesAsPng) {
        this.saveMetafilesAsPng = saveMetafilesAsPng;
        return this;
    }

    @ApiModelProperty(value="True to convert all metafiles used in a presentation to the PNG images.")
    public Boolean isSaveMetafilesAsPng() {
        return this.saveMetafilesAsPng;
    }

    public void setSaveMetafilesAsPng(Boolean saveMetafilesAsPng) {
        this.saveMetafilesAsPng = saveMetafilesAsPng;
    }

    public XpsExportOptions drawSlidesFrame(Boolean drawSlidesFrame) {
        this.drawSlidesFrame = drawSlidesFrame;
        return this;
    }

    @ApiModelProperty(value="True to draw black frame around each slide.")
    public Boolean isDrawSlidesFrame() {
        return this.drawSlidesFrame;
    }

    public void setDrawSlidesFrame(Boolean drawSlidesFrame) {
        this.drawSlidesFrame = drawSlidesFrame;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XpsExportOptions xpsExportOptions = (XpsExportOptions)o;
        return Objects.equals(this.showHiddenSlides, xpsExportOptions.showHiddenSlides) && Objects.equals(this.saveMetafilesAsPng, xpsExportOptions.saveMetafilesAsPng) && Objects.equals(this.drawSlidesFrame, xpsExportOptions.drawSlidesFrame) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.showHiddenSlides, this.saveMetafilesAsPng, this.drawSlidesFrame, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class XpsExportOptions {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    showHiddenSlides: ").append(this.toIndentedString(this.showHiddenSlides)).append("\n");
        sb.append("    saveMetafilesAsPng: ").append(this.toIndentedString(this.saveMetafilesAsPng)).append("\n");
        sb.append("    drawSlidesFrame: ").append(this.toIndentedString(this.drawSlidesFrame)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

