/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.ResourceUri;
import com.aspose.slides.model.ShapeBase;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Zoom object.")
public class ZoomObject
extends ShapeBase {
    @SerializedName(value="imageType", alternate={"ImageType"})
    private ImageTypeEnum imageType;
    @SerializedName(value="returnToParent", alternate={"ReturnToParent"})
    private Boolean returnToParent;
    @SerializedName(value="showBackground", alternate={"ShowBackground"})
    private Boolean showBackground;
    @SerializedName(value="image", alternate={"Image"})
    private ResourceUri image;
    @SerializedName(value="transitionDuration", alternate={"TransitionDuration"})
    private Double transitionDuration;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public ZoomObject imageType(ImageTypeEnum imageType) {
        this.imageType = imageType;
        return this;
    }

    @ApiModelProperty(value="Image type of a zoom object. ")
    public ImageTypeEnum getImageType() {
        return this.imageType;
    }

    public void setImageType(ImageTypeEnum imageType) {
        this.imageType = imageType;
    }

    public ZoomObject returnToParent(Boolean returnToParent) {
        this.returnToParent = returnToParent;
        return this;
    }

    @ApiModelProperty(value="Navigation behavior in slideshow. ")
    public Boolean isReturnToParent() {
        return this.returnToParent;
    }

    public void setReturnToParent(Boolean returnToParent) {
        this.returnToParent = returnToParent;
    }

    public ZoomObject showBackground(Boolean showBackground) {
        this.showBackground = showBackground;
        return this;
    }

    @ApiModelProperty(value="Specifies whether the Zoom will use the background of the destination slide.")
    public Boolean isShowBackground() {
        return this.showBackground;
    }

    public void setShowBackground(Boolean showBackground) {
        this.showBackground = showBackground;
    }

    public ZoomObject image(ResourceUri image) {
        this.image = image;
        return this;
    }

    @ApiModelProperty(value="Internal image link for zoom object")
    public ResourceUri getImage() {
        return this.image;
    }

    public void setImage(ResourceUri image) {
        this.image = image;
    }

    public ZoomObject transitionDuration(Double transitionDuration) {
        this.transitionDuration = transitionDuration;
        return this;
    }

    @ApiModelProperty(value="Duration of the transition between Zoom and slide.")
    public Double getTransitionDuration() {
        return this.transitionDuration;
    }

    public void setTransitionDuration(Double transitionDuration) {
        this.transitionDuration = transitionDuration;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZoomObject zoomObject = (ZoomObject)o;
        return Objects.equals((Object)this.imageType, (Object)zoomObject.imageType) && Objects.equals(this.returnToParent, zoomObject.returnToParent) && Objects.equals(this.showBackground, zoomObject.showBackground) && Objects.equals(this.image, zoomObject.image) && Objects.equals(this.transitionDuration, zoomObject.transitionDuration) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.imageType, this.returnToParent, this.showBackground, this.image, this.transitionDuration, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ZoomObject {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    imageType: ").append(this.toIndentedString((Object)this.imageType)).append("\n");
        sb.append("    returnToParent: ").append(this.toIndentedString(this.returnToParent)).append("\n");
        sb.append("    showBackground: ").append(this.toIndentedString(this.showBackground)).append("\n");
        sb.append("    image: ").append(this.toIndentedString(this.image)).append("\n");
        sb.append("    transitionDuration: ").append(this.toIndentedString(this.transitionDuration)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ImageTypeEnum {
        PREVIEW("Preview"),
        COVER("Cover");

        private String value;

        private ImageTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ImageTypeEnum fromValue(String text) {
            for (ImageTypeEnum b : ImageTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ImageTypeEnum> {
            public void write(JsonWriter jsonWriter, ImageTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ImageTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ImageTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

