/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides;

import com.aspose.slides.ApiCallback;
import com.aspose.slides.ApiException;
import com.aspose.slides.ApiResponse;
import com.aspose.slides.Configuration;
import com.aspose.slides.ErrorMessage;
import com.aspose.slides.FileInfo;
import com.aspose.slides.JSON;
import com.aspose.slides.Pair;
import com.aspose.slides.ProgressRequestBody;
import com.aspose.slides.StringUtil;
import com.aspose.slides.auth.Authentication;
import com.aspose.slides.auth.JWTAuth;
import com.aspose.slides.auth.NeedRepeatRequestException;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Callback;
import com.squareup.okhttp.FormEncodingBuilder;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.MultipartBuilder;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Protocol;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.internal.http.HttpMethod;
import com.squareup.okhttp.logging.HttpLoggingInterceptor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;
import org.threeten.bp.format.DateTimeFormatter;

public class ApiClient {
    private String baseUrl;
    private boolean debugging = false;
    private Map<String, String> defaultHeaderMap = new HashMap<String, String>();
    private String tempFolderPath = null;
    private Authentication authentication;
    private DateFormat dateFormat;
    private DateFormat datetimeFormat;
    private boolean lenientDatetimeFormat;
    private int dateLength;
    private InputStream sslCaCert;
    private boolean verifyingSsl;
    private KeyManager[] keyManagers;
    private OkHttpClient httpClient;
    private JSON json;
    private String version;
    private HttpLoggingInterceptor loggingInterceptor;

    public ApiClient(Configuration configuration) {
        this(configuration.getUrl(), new JWTAuth(configuration), configuration.getDebug(), configuration.getTimeout(), configuration.getHttpRequestTimeout(), configuration.getAllowInsecureRequests(), configuration.getCustomHeaders());
    }

    public ApiClient(String baseUrl, Authentication authentication) {
        this(baseUrl, authentication, false, 0, 300, false, null);
    }

    private ApiClient(String baseUrl, Authentication authentication, Boolean debugging, Integer timeout, Integer httpRequestTimeout, Boolean allowInsecureRequests, Map<String, String> customHeaders) {
        this.baseUrl = baseUrl;
        this.authentication = authentication;
        this.httpClient = new OkHttpClient();
        ArrayList<Protocol> protocols = new ArrayList<Protocol>();
        protocols.add(Protocol.HTTP_1_1);
        this.httpClient.setProtocols(protocols);
        this.httpClient.setConnectTimeout((long)httpRequestTimeout.intValue(), TimeUnit.SECONDS);
        this.httpClient.setReadTimeout((long)httpRequestTimeout.intValue(), TimeUnit.SECONDS);
        this.httpClient.setWriteTimeout((long)httpRequestTimeout.intValue(), TimeUnit.SECONDS);
        this.setDebugging(debugging);
        this.setVerifyingSsl(allowInsecureRequests == false);
        this.json = new JSON();
        this.addDefaultHeader("x-aspose-client", "java sdk v" + this.getVersion());
        if (timeout > 0) {
            this.addDefaultHeader("x-aspose-timeout", timeout.toString());
        }
        if (customHeaders != null) {
            for (String key : customHeaders.keySet()) {
                this.addDefaultHeader(key, customHeaders.get(key));
            }
        }
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public ApiClient setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    public ApiClient setHttpClient(OkHttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public JSON getJSON() {
        return this.json;
    }

    public ApiClient setJSON(JSON json) {
        this.json = json;
        return this;
    }

    public boolean isVerifyingSsl() {
        return this.verifyingSsl;
    }

    public ApiClient setVerifyingSsl(boolean verifyingSsl) {
        this.verifyingSsl = verifyingSsl;
        this.applySslSettings();
        return this;
    }

    public InputStream getSslCaCert() {
        return this.sslCaCert;
    }

    public ApiClient setSslCaCert(InputStream sslCaCert) {
        this.sslCaCert = sslCaCert;
        this.applySslSettings();
        return this;
    }

    public KeyManager[] getKeyManagers() {
        return this.keyManagers;
    }

    public ApiClient setKeyManagers(KeyManager[] managers) {
        this.keyManagers = managers;
        this.applySslSettings();
        return this;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public ApiClient setDateFormat(DateFormat dateFormat) {
        this.json.setDateFormat(dateFormat);
        return this;
    }

    public ApiClient setSqlDateFormat(DateFormat dateFormat) {
        this.json.setSqlDateFormat(dateFormat);
        return this;
    }

    public ApiClient setOffsetDateTimeFormat(DateTimeFormatter dateFormat) {
        this.json.setOffsetDateTimeFormat(dateFormat);
        return this;
    }

    public ApiClient setLocalDateFormat(DateTimeFormatter dateFormat) {
        this.json.setLocalDateFormat(dateFormat);
        return this;
    }

    public ApiClient setLenientOnJson(boolean lenientOnJson) {
        this.json.setLenientOnJson(lenientOnJson);
        return this;
    }

    private ApiClient addDefaultHeader(String key, String value) {
        this.defaultHeaderMap.put(key, value);
        return this;
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    public ApiClient setDebugging(boolean debugging) {
        if (debugging != this.debugging) {
            if (debugging) {
                this.loggingInterceptor = new HttpLoggingInterceptor();
                this.loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
                this.httpClient.interceptors().add(this.loggingInterceptor);
            } else {
                this.httpClient.interceptors().remove(this.loggingInterceptor);
                this.loggingInterceptor = null;
            }
        }
        this.debugging = debugging;
        return this;
    }

    public String getTempFolderPath() {
        return this.tempFolderPath;
    }

    public ApiClient setTempFolderPath(String tempFolderPath) {
        this.tempFolderPath = tempFolderPath;
        return this;
    }

    public int getConnectTimeout() {
        return this.httpClient.getConnectTimeout();
    }

    public ApiClient setConnectTimeout(int connectionTimeout) {
        this.httpClient.setConnectTimeout((long)connectionTimeout, TimeUnit.MILLISECONDS);
        return this;
    }

    public int getReadTimeout() {
        return this.httpClient.getReadTimeout();
    }

    public ApiClient setReadTimeout(int readTimeout) {
        this.httpClient.setReadTimeout((long)readTimeout, TimeUnit.MILLISECONDS);
        return this;
    }

    public int getWriteTimeout() {
        return this.httpClient.getWriteTimeout();
    }

    public ApiClient setWriteTimeout(int writeTimeout) {
        this.httpClient.setWriteTimeout((long)writeTimeout, TimeUnit.MILLISECONDS);
        return this;
    }

    public String parameterToString(Object param) {
        if (param == null) {
            return "";
        }
        if (param instanceof Date || param instanceof OffsetDateTime || param instanceof LocalDate) {
            String jsonStr = this.json.serialize(param);
            return jsonStr.substring(1, jsonStr.length() - 1);
        }
        if (param instanceof Collection) {
            StringBuilder b = new StringBuilder();
            for (Object o : (Collection)param) {
                if (b.length() > 0) {
                    b.append(",");
                }
                b.append(String.valueOf(o));
            }
            return b.toString();
        }
        if (param.getClass().isEnum()) {
            return param.toString();
        }
        return String.valueOf(param);
    }

    public void addQueryParameter(List<Pair> parameters, String name, Object value) {
        if (name != null && !name.isEmpty() && value != null) {
            parameters.add(new Pair(name, this.parameterToString(value)));
        }
    }

    public List<Pair> parameterToPairs(String collectionFormat, String name, Collection value) {
        ArrayList<Pair> params = new ArrayList<Pair>();
        if (name == null || name.isEmpty() || value == null || value.isEmpty()) {
            return params;
        }
        if ("multi".equals(collectionFormat)) {
            for (Object item : value) {
                params.add(new Pair(name, this.escapeString(this.parameterToString(item))));
            }
            return params;
        }
        String delimiter = ",";
        if ("ssv".equals(collectionFormat)) {
            delimiter = this.escapeString(" ");
        } else if ("tsv".equals(collectionFormat)) {
            delimiter = this.escapeString("\t");
        } else if ("pipes".equals(collectionFormat)) {
            delimiter = this.escapeString("|");
        }
        StringBuilder sb = new StringBuilder();
        for (Object item : value) {
            sb.append(delimiter);
            sb.append(this.escapeString(this.parameterToString(item)));
        }
        params.add(new Pair(name, sb.substring(delimiter.length())));
        return params;
    }

    public String sanitizeFilename(String filename) {
        return filename.replaceAll(".*[/\\\\]", "").replaceAll(";", "");
    }

    public boolean isJsonMime(String mime) {
        String jsonMime = "(?i)^(application/json|[^;/ \t]+/[^;/ \t]+[+]json)[ \t]*(;.*)?$";
        return mime != null && (mime.matches(jsonMime) || mime.equals("*/*"));
    }

    public String selectHeaderAccept(String[] accepts) {
        if (accepts.length == 0) {
            return null;
        }
        for (String accept : accepts) {
            if (!this.isJsonMime(accept)) continue;
            return accept;
        }
        return StringUtil.join(accepts, ",");
    }

    public String selectHeaderContentType(String[] contentTypes) {
        if (contentTypes.length == 0 || contentTypes[0].equals("*/*")) {
            return "application/json";
        }
        for (String contentType : contentTypes) {
            if (!this.isJsonMime(contentType)) continue;
            return contentType;
        }
        return contentTypes[0];
    }

    public String escapeString(String str) {
        try {
            return URLEncoder.encode(str, "utf8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    public <T> T deserialize(Response response, Type returnType) throws ApiException {
        String respBody;
        if (response == null || returnType == null) {
            return null;
        }
        if ("byte[]".equals(returnType.toString())) {
            try {
                return (T)response.body().bytes();
            }
            catch (IOException e) {
                throw new ApiException(e);
            }
        }
        if (returnType.equals(File.class)) {
            return (T)this.downloadFileFromResponse(response);
        }
        try {
            respBody = response.body() != null ? response.body().string() : null;
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (respBody == null || "".equals(respBody)) {
            return null;
        }
        String contentType = response.headers().get("Content-Type");
        if (contentType == null) {
            contentType = "application/json";
        }
        if (returnType.equals(String.class)) {
            return (T)respBody.replaceAll("^\"|\"$", "");
        }
        if (this.isJsonMime(contentType)) {
            return this.json.deserialize(respBody, returnType);
        }
        throw new ApiException("Content type \"" + contentType + "\" is not supported for type: " + returnType, response.code(), (Map<String, List<String>>)response.headers().toMultimap(), respBody);
    }

    public RequestBody serialize(Object obj, String contentType, List<FileInfo> files) throws ApiException {
        if (files != null && files.size() > 0 || obj instanceof byte[] || obj instanceof File) {
            LinkedHashMap<String, Object> parts = new LinkedHashMap<String, Object>();
            if (obj != null) {
                parts.put("data", obj);
            }
            if (files != null) {
                int i = 0;
                for (FileInfo file : files) {
                    String name = file.getName();
                    if (name == null) {
                        name = "file" + ++i;
                    }
                    parts.put(name, file);
                }
            }
            return this.buildRequestBodyMultipart(parts);
        }
        if (obj instanceof String) {
            return RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)((String)obj));
        }
        String content = "";
        if (obj != null) {
            content = this.json.serialize(obj);
        }
        return RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)content);
    }

    public File downloadFileFromResponse(Response response) throws ApiException {
        try {
            File file = this.prepareDownloadFile(response);
            BufferedSink sink = Okio.buffer((Sink)Okio.sink((File)file));
            sink.writeAll((Source)response.body().source());
            sink.close();
            return file;
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    public File prepareDownloadFile(Response response) throws IOException {
        Pattern pattern;
        Matcher matcher;
        String filename = null;
        String contentDisposition = response.header("Content-Disposition");
        if (contentDisposition != null && !"".equals(contentDisposition) && (matcher = (pattern = Pattern.compile("filename=['\"]?([^'\"\\s]+)['\"]?")).matcher(contentDisposition)).find()) {
            filename = this.sanitizeFilename(matcher.group(1));
        }
        String prefix = null;
        String suffix = null;
        if (filename == null) {
            prefix = "download-";
            suffix = "";
        } else {
            int pos = filename.lastIndexOf(".");
            if (pos == -1) {
                prefix = filename + "-";
            } else {
                prefix = filename.substring(0, pos) + "-";
                suffix = filename.substring(pos);
            }
            if (prefix.length() < 3) {
                prefix = "download-";
            }
        }
        if (this.tempFolderPath == null) {
            return File.createTempFile(prefix, suffix);
        }
        return File.createTempFile(prefix, suffix, new File(this.tempFolderPath));
    }

    public <T> ApiResponse<T> execute(Call call) throws ApiException {
        return this.execute(call, null);
    }

    public <T> ApiResponse<T> execute(Call call, Type returnType) throws ApiException {
        try {
            Response response = call.execute();
            T data = this.handleResponse(response, returnType);
            return new ApiResponse<T>(response.code(), response.headers().toMultimap(), data);
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    public <T> void executeAsync(Call call, ApiCallback<T> callback) {
        this.executeAsync(call, null, callback);
    }

    public <T> void executeAsync(final Call call, final Type returnType, final ApiCallback<T> callback) {
        call.enqueue(new Callback(){

            public void onFailure(Request request, IOException e) {
                callback.onFailure(new ApiException(e), 0, null);
            }

            public void onResponse(Response response) throws IOException {
                Object result;
                try {
                    result = ApiClient.this.handleResponse(response, returnType);
                }
                catch (NeedRepeatRequestException e) {
                    ApiClient.this.repeatExecuteAsync(call, returnType, callback);
                    return;
                }
                catch (ApiException e) {
                    callback.onFailure(e, response.code(), response.headers().toMultimap());
                    return;
                }
                callback.onSuccess(result, response.code(), response.headers().toMultimap());
            }
        });
    }

    private <T> void repeatExecuteAsync(Call call, final Type returnType, final ApiCallback<T> callback) {
        call.enqueue(new Callback(){

            public void onFailure(Request request, IOException e) {
                callback.onFailure(new ApiException(e), 0, null);
            }

            public void onResponse(Response response) throws IOException {
                Object result;
                try {
                    result = ApiClient.this.handleResponse(response, returnType);
                }
                catch (ApiException e) {
                    callback.onFailure(e, response.code(), response.headers().toMultimap());
                    return;
                }
                callback.onSuccess(result, response.code(), response.headers().toMultimap());
            }
        });
    }

    public <T> T handleResponse(Response response, Type returnType) throws ApiException {
        if (response.isSuccessful()) {
            if (returnType == null || response.code() == 204) {
                if (response.body() != null) {
                    try {
                        response.body().close();
                    }
                    catch (IOException e) {
                        throw new ApiException(response.message(), (Throwable)e, response.code(), response.headers().toMultimap());
                    }
                }
                return null;
            }
            return this.deserialize(response, returnType);
        }
        try {
            this.authentication.handleBadResponse(response);
        }
        catch (IOException ex) {
            throw new ApiException(response.message(), (Throwable)ex, response.code(), response.headers().toMultimap());
        }
        if (response.body() != null) {
            ErrorMessage message;
            String respBody;
            try {
                respBody = response.body().string();
            }
            catch (IOException ex) {
                throw new ApiException(response.message(), (Throwable)ex, response.code(), response.headers().toMultimap());
            }
            try {
                message = (ErrorMessage)this.json.deserialize(respBody, new TypeToken<ErrorMessage>(){}.getType());
            }
            catch (Exception e) {
                throw new ApiException(response.message(), response.code(), (Map<String, List<String>>)response.headers().toMultimap(), respBody);
            }
            String errorMessage = message.getMessage();
            if (errorMessage == null && message.getError() != null) {
                errorMessage = message.getError().getMessage();
            }
            throw new ApiException(errorMessage, response.code(), (Map<String, List<String>>)response.headers().toMultimap(), null);
        }
        throw new ApiException(response.message(), response.code(), (Map<String, List<String>>)response.headers().toMultimap(), null);
    }

    public Call buildCall(String path, String method, List<Pair> queryParams, Object body, Map<String, String> headerParams, Map<String, Object> formParams, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Request request = this.buildRequest(path, method, queryParams, body, headerParams, formParams, progressRequestListener);
        return this.httpClient.newCall(request);
    }

    public Request buildRequest(String path, String method, List<Pair> queryParams, Object body, Map<String, String> headerParams, Map<String, Object> formParams, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        RequestBody reqBody;
        if (headerParams == null) {
            headerParams = new HashMap<String, String>();
        }
        this.authentication.updateHeaderParams(headerParams);
        Request.Builder reqBuilder = new Request.Builder().url(this.buildUrl(path, queryParams));
        this.processHeaderParams(headerParams, reqBuilder);
        String contentType = headerParams.get("Content-Type");
        if (contentType == null) {
            contentType = "application/json";
        }
        if (!HttpMethod.permitsRequestBody((String)method)) {
            reqBody = null;
        } else if ("application/x-www-form-urlencoded".equals(contentType)) {
            reqBody = this.buildRequestBodyFormEncoding(formParams);
        } else if (formParams.size() > 0) {
            List files = null;
            Object[] bodyParts = null;
            if (List.class.isAssignableFrom(formParams.values().toArray()[0].getClass())) {
                files = (List)formParams.values().toArray()[0];
            } else {
                bodyParts = formParams.values().toArray();
            }
            int partCount = (body != null ? 1 : 0) + (files != null ? files.size() : 0) + (bodyParts != null ? bodyParts.length : 0);
            if (partCount > 1) {
                LinkedHashMap<String, Object> parts = new LinkedHashMap<String, Object>();
                if (body != null) {
                    parts.put("body", body);
                }
                int fileIndex = 0;
                if (files != null) {
                    for (FileInfo file : files) {
                        parts.put("file" + ++fileIndex, file);
                    }
                }
                if (bodyParts != null) {
                    for (Object part : bodyParts) {
                        parts.put("file" + ++fileIndex, part);
                    }
                }
                reqBody = this.buildRequestBodyMultipart(parts);
            } else {
                reqBody = files != null ? this.serialize(files.toArray()[0], contentType, null) : this.serialize(bodyParts[0], contentType, null);
            }
        } else {
            reqBody = formParams.size() > 1 ? this.buildRequestBodyMultipart(formParams) : (formParams.size() == 1 ? this.serialize(formParams.values().toArray()[0], contentType, null) : this.serialize(body, contentType, null));
        }
        Request request = null;
        if (progressRequestListener != null && reqBody != null) {
            ProgressRequestBody progressRequestBody = new ProgressRequestBody(reqBody, progressRequestListener);
            request = reqBuilder.method(method, (RequestBody)progressRequestBody).build();
        } else {
            request = reqBuilder.method(method, reqBody).build();
        }
        return request;
    }

    public String buildUrl(String path, List<Pair> queryParams) {
        StringBuilder url = new StringBuilder();
        url.append(this.baseUrl).append(path);
        if (queryParams != null && !queryParams.isEmpty()) {
            String prefix = path.contains("?") ? "&" : "?";
            for (Pair param : queryParams) {
                if (param.getValue() == null) continue;
                if (prefix != null) {
                    url.append(prefix);
                    prefix = null;
                } else {
                    url.append("&");
                }
                String value = this.parameterToString(param.getValue());
                url.append(this.escapeString(param.getName())).append("=").append(this.escapeString(value));
            }
        }
        return url.toString();
    }

    public void processHeaderParams(Map<String, String> headerParams, Request.Builder reqBuilder) {
        for (Map.Entry<String, String> param : headerParams.entrySet()) {
            reqBuilder.header(param.getKey(), this.parameterToString(param.getValue()));
        }
        for (Map.Entry<String, String> header : this.defaultHeaderMap.entrySet()) {
            if (headerParams.containsKey(header.getKey())) continue;
            reqBuilder.header(header.getKey(), this.parameterToString(header.getValue()));
        }
    }

    public RequestBody buildRequestBodyFormEncoding(Map<String, Object> formParams) {
        FormEncodingBuilder formBuilder = new FormEncodingBuilder();
        for (Map.Entry<String, Object> param : formParams.entrySet()) {
            formBuilder.add(param.getKey(), this.parameterToString(param.getValue()));
        }
        return formBuilder.build();
    }

    public RequestBody buildRequestBodyMultipart(Map<String, Object> formParams) {
        MultipartBuilder mpBuilder = new MultipartBuilder().type(MultipartBuilder.FORM);
        int partIndex = 1;
        for (Map.Entry<String, Object> param : formParams.entrySet()) {
            MediaType mediaType;
            Headers partHeaders;
            Object file;
            String fileName = "file" + partIndex;
            if (param.getValue() instanceof File) {
                file = (File)param.getValue();
                if (((File)file).getName() != null && ((File)file).getName() != "") {
                    fileName = ((File)file).getName();
                }
                partHeaders = Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"" + param.getKey() + "\"; filename=\"" + fileName + "\""});
                mediaType = MediaType.parse((String)this.guessContentTypeFromFile((File)file));
                mpBuilder.addPart(partHeaders, RequestBody.create((MediaType)mediaType, (File)file));
            } else if (param.getValue() instanceof byte[]) {
                byte[] bytes = (byte[])param.getValue();
                if (param.getKey() != null && param.getKey() != "") {
                    fileName = param.getKey();
                }
                partHeaders = Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"" + param.getKey() + "\"; filename=\"" + fileName + "\""});
                mediaType = MediaType.parse((String)"application/octet-stream");
                mpBuilder.addPart(partHeaders, RequestBody.create((MediaType)mediaType, (byte[])bytes));
            } else if (param.getValue() instanceof FileInfo) {
                file = (FileInfo)param.getValue();
                if (((FileInfo)file).getName() != null && ((FileInfo)file).getName() != "") {
                    fileName = ((FileInfo)file).getName();
                }
                partHeaders = Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"" + param.getKey() + "\"; filename=\"" + fileName + "\""});
                mediaType = MediaType.parse((String)(((FileInfo)file).getMimeType() == null ? "application/octet-stream" : ((FileInfo)file).getMimeType()));
                mpBuilder.addPart(partHeaders, RequestBody.create((MediaType)mediaType, (byte[])((FileInfo)file).getData()));
            } else {
                Headers partHeaders2 = Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"" + param.getKey() + "\""});
                mpBuilder.addPart(partHeaders2, RequestBody.create(null, (String)this.json.serialize(param.getValue())));
            }
            ++partIndex;
        }
        return mpBuilder.build();
    }

    public String guessContentTypeFromFile(File file) {
        String contentType = URLConnection.guessContentTypeFromName(file.getName());
        if (contentType == null) {
            return "application/octet-stream";
        }
        return contentType;
    }

    public String objectToString(Object object) {
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    private String getVersion() {
        if (this.version == null) {
            InputStream propertiesStream = this.getClass().getResourceAsStream("/project.properties");
            Properties properties = new Properties();
            try {
                properties.load(propertiesStream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.version = properties.getProperty("version");
        }
        return this.version;
    }

    private void applySslSettings() {
        try {
            TrustManager[] trustManagers = null;
            HostnameVerifier hostnameVerifier = null;
            if (!this.verifyingSsl) {
                X509TrustManager trustAll = new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }
                };
                SSLContext sslContext = SSLContext.getInstance("TLS");
                trustManagers = new TrustManager[]{trustAll};
                hostnameVerifier = new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                };
            } else if (this.sslCaCert != null) {
                char[] password = null;
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                Collection<? extends Certificate> certificates = certificateFactory.generateCertificates(this.sslCaCert);
                if (certificates.isEmpty()) {
                    throw new IllegalArgumentException("expected non-empty set of trusted certificates");
                }
                KeyStore caKeyStore = this.newEmptyKeyStore(password);
                int index = 0;
                for (Certificate certificate : certificates) {
                    String certificateAlias = "ca" + Integer.toString(index++);
                    caKeyStore.setCertificateEntry(certificateAlias, certificate);
                }
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init(caKeyStore);
                trustManagers = trustManagerFactory.getTrustManagers();
            }
            if (this.keyManagers != null || trustManagers != null) {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(this.keyManagers, trustManagers, new SecureRandom());
                this.httpClient.setSslSocketFactory(sslContext.getSocketFactory());
            } else {
                this.httpClient.setSslSocketFactory(null);
            }
            this.httpClient.setHostnameVerifier(hostnameVerifier);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private KeyStore newEmptyKeyStore(char[] password) throws GeneralSecurityException {
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, password);
            return keyStore;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }
}

