/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.api;

import com.aspose.slides.ApiCallback;
import com.aspose.slides.ApiClient;
import com.aspose.slides.ApiException;
import com.aspose.slides.ApiResponse;
import com.aspose.slides.Configuration;
import com.aspose.slides.FileInfo;
import com.aspose.slides.Pair;
import com.aspose.slides.ProgressRequestBody;
import com.aspose.slides.ProgressResponseBody;
import com.aspose.slides.auth.NeedRepeatRequestException;
import com.aspose.slides.model.ExportFormat;
import com.aspose.slides.model.ExportOptions;
import com.aspose.slides.model.FilesUploadResult;
import com.aspose.slides.model.Operation;
import com.aspose.slides.model.OrderedMergeRequest;
import com.aspose.slides.model.SlideExportFormat;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

public class SlidesAsyncApi {
    private final ApiClient apiClient;

    public SlidesAsyncApi(Configuration configuration) {
        this.apiClient = new ApiClient(configuration);
    }

    public SlidesAsyncApi(String appSid, String appKey) {
        this(new Configuration(appSid, appKey));
    }

    public Call downloadCall(String path, String storageName, String versionId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object postBody = null;
        String methodPath = "/slides/async/storage/file/{path}".replaceAll("\\{path\\}", this.apiClient.objectToString(path));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "storageName", storageName);
        this.apiClient.addQueryParameter(queryParams, "versionId", versionId);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"multipart/form-data"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public File download(String path, String storageName, String versionId) throws ApiException {
        try {
            ApiResponse<File> resp = this.downloadWithHttpInfo(path, storageName, versionId);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<File> resp = this.downloadWithHttpInfo(path, storageName, versionId);
            return resp.getData();
        }
    }

    public ApiResponse<File> downloadWithHttpInfo(String path, String storageName, String versionId) throws ApiException {
        Call call = this.downloadCall(path, storageName, versionId, null, null);
        Type returnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call downloadAsync(String path, String storageName, String versionId, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.downloadCall(path, storageName, versionId, progressListener, progressRequestListener);
        Type returnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getOperationResultCall(String id, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getOperationResult(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/async/{id}/result".replaceAll("\\{id\\}", this.apiClient.objectToString(id));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"multipart/form-data"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public File getOperationResult(String id) throws ApiException {
        try {
            ApiResponse<File> resp = this.getOperationResultWithHttpInfo(id);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<File> resp = this.getOperationResultWithHttpInfo(id);
            return resp.getData();
        }
    }

    public ApiResponse<File> getOperationResultWithHttpInfo(String id) throws ApiException {
        Call call = this.getOperationResultCall(id, null, null);
        Type returnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getOperationResultAsync(String id, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getOperationResultCall(id, progressListener, progressRequestListener);
        Type returnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call getOperationStatusCall(String id, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getOperationStatus(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/async/{id}".replaceAll("\\{id\\}", this.apiClient.objectToString(id));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "GET", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public Operation getOperationStatus(String id) throws ApiException {
        try {
            ApiResponse<Operation> resp = this.getOperationStatusWithHttpInfo(id);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<Operation> resp = this.getOperationStatusWithHttpInfo(id);
            return resp.getData();
        }
    }

    public ApiResponse<Operation> getOperationStatusWithHttpInfo(String id) throws ApiException {
        Call call = this.getOperationStatusCall(id, null, null);
        Type returnType = new TypeToken<Operation>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getOperationStatusAsync(String id, final ApiCallback<Operation> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getOperationStatusCall(id, progressListener, progressRequestListener);
        Type returnType = new TypeToken<Operation>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call startConvertCall(byte[] document, ExportFormat format, String password, String storage, String fontsFolder, List<Integer> slides, ExportOptions options, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] accepts;
        String accept;
        if (document == null) {
            throw new ApiException("Missing the required parameter 'document' when calling startConvert(Async)");
        }
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling startConvert(Async)");
        }
        ExportOptions postBody = options;
        String methodPath = "/slides/async/convert/{format}".replaceAll("\\{format\\}", this.apiClient.objectToString((Object)format));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        this.apiClient.addQueryParameter(queryParams, "fontsFolder", fontsFolder);
        this.apiClient.addQueryParameter(queryParams, "slides", slides);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        if (document != null) {
            formParams.put("document", document);
        }
        if ((accept = this.apiClient.selectHeaderAccept(accepts = new String[]{"application/json"})) != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"multipart/form-data"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public String startConvert(byte[] document, ExportFormat format, String password, String storage, String fontsFolder, List<Integer> slides, ExportOptions options) throws ApiException {
        try {
            ApiResponse<String> resp = this.startConvertWithHttpInfo(document, format, password, storage, fontsFolder, slides, options);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<String> resp = this.startConvertWithHttpInfo(document, format, password, storage, fontsFolder, slides, options);
            return resp.getData();
        }
    }

    public ApiResponse<String> startConvertWithHttpInfo(byte[] document, ExportFormat format, String password, String storage, String fontsFolder, List<Integer> slides, ExportOptions options) throws ApiException {
        Call call = this.startConvertCall(document, format, password, storage, fontsFolder, slides, options, null, null);
        Type returnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call startConvertAsync(byte[] document, ExportFormat format, String password, String storage, String fontsFolder, List<Integer> slides, ExportOptions options, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.startConvertCall(document, format, password, storage, fontsFolder, slides, options, progressListener, progressRequestListener);
        Type returnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call startConvertAndSaveCall(byte[] document, ExportFormat format, String outPath, String password, String storage, String fontsFolder, List<Integer> slides, ExportOptions options, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] accepts;
        String accept;
        if (document == null) {
            throw new ApiException("Missing the required parameter 'document' when calling startConvertAndSave(Async)");
        }
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling startConvertAndSave(Async)");
        }
        if (outPath == null) {
            throw new ApiException("Missing the required parameter 'outPath' when calling startConvertAndSave(Async)");
        }
        ExportOptions postBody = options;
        String methodPath = "/slides/async/convert/{format}".replaceAll("\\{format\\}", this.apiClient.objectToString((Object)format));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "outPath", outPath);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        this.apiClient.addQueryParameter(queryParams, "fontsFolder", fontsFolder);
        this.apiClient.addQueryParameter(queryParams, "slides", slides);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        if (document != null) {
            formParams.put("document", document);
        }
        if ((accept = this.apiClient.selectHeaderAccept(accepts = new String[]{"application/json"})) != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"multipart/form-data"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "PUT", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public String startConvertAndSave(byte[] document, ExportFormat format, String outPath, String password, String storage, String fontsFolder, List<Integer> slides, ExportOptions options) throws ApiException {
        try {
            ApiResponse<String> resp = this.startConvertAndSaveWithHttpInfo(document, format, outPath, password, storage, fontsFolder, slides, options);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<String> resp = this.startConvertAndSaveWithHttpInfo(document, format, outPath, password, storage, fontsFolder, slides, options);
            return resp.getData();
        }
    }

    public ApiResponse<String> startConvertAndSaveWithHttpInfo(byte[] document, ExportFormat format, String outPath, String password, String storage, String fontsFolder, List<Integer> slides, ExportOptions options) throws ApiException {
        Call call = this.startConvertAndSaveCall(document, format, outPath, password, storage, fontsFolder, slides, options, null, null);
        Type returnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call startConvertAndSaveAsync(byte[] document, ExportFormat format, String outPath, String password, String storage, String fontsFolder, List<Integer> slides, ExportOptions options, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.startConvertAndSaveCall(document, format, outPath, password, storage, fontsFolder, slides, options, progressListener, progressRequestListener);
        Type returnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call startDownloadPresentationCall(String name, ExportFormat format, ExportOptions options, String password, String folder, String storage, String fontsFolder, List<Integer> slides, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling startDownloadPresentation(Async)");
        }
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling startDownloadPresentation(Async)");
        }
        ExportOptions postBody = options;
        String methodPath = "/slides/async/{name}/{format}".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{format\\}", this.apiClient.objectToString((Object)format));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        this.apiClient.addQueryParameter(queryParams, "fontsFolder", fontsFolder);
        this.apiClient.addQueryParameter(queryParams, "slides", slides);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public String startDownloadPresentation(String name, ExportFormat format, ExportOptions options, String password, String folder, String storage, String fontsFolder, List<Integer> slides) throws ApiException {
        try {
            ApiResponse<String> resp = this.startDownloadPresentationWithHttpInfo(name, format, options, password, folder, storage, fontsFolder, slides);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<String> resp = this.startDownloadPresentationWithHttpInfo(name, format, options, password, folder, storage, fontsFolder, slides);
            return resp.getData();
        }
    }

    public ApiResponse<String> startDownloadPresentationWithHttpInfo(String name, ExportFormat format, ExportOptions options, String password, String folder, String storage, String fontsFolder, List<Integer> slides) throws ApiException {
        Call call = this.startDownloadPresentationCall(name, format, options, password, folder, storage, fontsFolder, slides, null, null);
        Type returnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call startDownloadPresentationAsync(String name, ExportFormat format, ExportOptions options, String password, String folder, String storage, String fontsFolder, List<Integer> slides, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.startDownloadPresentationCall(name, format, options, password, folder, storage, fontsFolder, slides, progressListener, progressRequestListener);
        Type returnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call startMergeCall(List<FileInfo> files, OrderedMergeRequest request, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] accepts;
        String accept;
        OrderedMergeRequest postBody = request;
        String methodPath = "/slides/async/merge";
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        if (files != null) {
            formParams.put("files", files);
        }
        if ((accept = this.apiClient.selectHeaderAccept(accepts = new String[]{"application/json"})) != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"multipart/form-data"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public String startMerge(List<FileInfo> files, OrderedMergeRequest request, String storage) throws ApiException {
        try {
            ApiResponse<String> resp = this.startMergeWithHttpInfo(files, request, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<String> resp = this.startMergeWithHttpInfo(files, request, storage);
            return resp.getData();
        }
    }

    public ApiResponse<String> startMergeWithHttpInfo(List<FileInfo> files, OrderedMergeRequest request, String storage) throws ApiException {
        Call call = this.startMergeCall(files, request, storage, null, null);
        Type returnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call startMergeAsync(List<FileInfo> files, OrderedMergeRequest request, String storage, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.startMergeCall(files, request, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call startMergeAndSaveCall(String outPath, List<FileInfo> files, OrderedMergeRequest request, String storage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] accepts;
        String accept;
        if (outPath == null) {
            throw new ApiException("Missing the required parameter 'outPath' when calling startMergeAndSave(Async)");
        }
        OrderedMergeRequest postBody = request;
        String methodPath = "/slides/async/merge";
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "outPath", outPath);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        if (files != null) {
            formParams.put("files", files);
        }
        if ((accept = this.apiClient.selectHeaderAccept(accepts = new String[]{"application/json"})) != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"multipart/form-data"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "PUT", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public String startMergeAndSave(String outPath, List<FileInfo> files, OrderedMergeRequest request, String storage) throws ApiException {
        try {
            ApiResponse<String> resp = this.startMergeAndSaveWithHttpInfo(outPath, files, request, storage);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<String> resp = this.startMergeAndSaveWithHttpInfo(outPath, files, request, storage);
            return resp.getData();
        }
    }

    public ApiResponse<String> startMergeAndSaveWithHttpInfo(String outPath, List<FileInfo> files, OrderedMergeRequest request, String storage) throws ApiException {
        Call call = this.startMergeAndSaveCall(outPath, files, request, storage, null, null);
        Type returnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call startMergeAndSaveAsync(String outPath, List<FileInfo> files, OrderedMergeRequest request, String storage, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.startMergeAndSaveCall(outPath, files, request, storage, progressListener, progressRequestListener);
        Type returnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call startSavePresentationCall(String name, ExportFormat format, String outPath, ExportOptions options, String password, String folder, String storage, String fontsFolder, List<Integer> slides, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling startSavePresentation(Async)");
        }
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling startSavePresentation(Async)");
        }
        if (outPath == null) {
            throw new ApiException("Missing the required parameter 'outPath' when calling startSavePresentation(Async)");
        }
        ExportOptions postBody = options;
        String methodPath = "/slides/async/{name}/{format}".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{format\\}", this.apiClient.objectToString((Object)format));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "outPath", outPath);
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        this.apiClient.addQueryParameter(queryParams, "fontsFolder", fontsFolder);
        this.apiClient.addQueryParameter(queryParams, "slides", slides);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "PUT", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public String startSavePresentation(String name, ExportFormat format, String outPath, ExportOptions options, String password, String folder, String storage, String fontsFolder, List<Integer> slides) throws ApiException {
        try {
            ApiResponse<String> resp = this.startSavePresentationWithHttpInfo(name, format, outPath, options, password, folder, storage, fontsFolder, slides);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<String> resp = this.startSavePresentationWithHttpInfo(name, format, outPath, options, password, folder, storage, fontsFolder, slides);
            return resp.getData();
        }
    }

    public ApiResponse<String> startSavePresentationWithHttpInfo(String name, ExportFormat format, String outPath, ExportOptions options, String password, String folder, String storage, String fontsFolder, List<Integer> slides) throws ApiException {
        Call call = this.startSavePresentationCall(name, format, outPath, options, password, folder, storage, fontsFolder, slides, null, null);
        Type returnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call startSavePresentationAsync(String name, ExportFormat format, String outPath, ExportOptions options, String password, String folder, String storage, String fontsFolder, List<Integer> slides, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.startSavePresentationCall(name, format, outPath, options, password, folder, storage, fontsFolder, slides, progressListener, progressRequestListener);
        Type returnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call startSplitCall(String name, SlideExportFormat format, ExportOptions options, Integer width, Integer height, Integer from, Integer to, String destFolder, String password, String folder, String storage, String fontsFolder, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling startSplit(Async)");
        }
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling startSplit(Async)");
        }
        ExportOptions postBody = options;
        String methodPath = "/slides/async/{name}/split/{format}".replaceAll("\\{name\\}", this.apiClient.objectToString(name)).replaceAll("\\{format\\}", this.apiClient.objectToString((Object)format));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "width", width);
        this.apiClient.addQueryParameter(queryParams, "height", height);
        this.apiClient.addQueryParameter(queryParams, "from", from);
        this.apiClient.addQueryParameter(queryParams, "to", to);
        this.apiClient.addQueryParameter(queryParams, "destFolder", destFolder);
        this.apiClient.addQueryParameter(queryParams, "folder", folder);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        this.apiClient.addQueryParameter(queryParams, "fontsFolder", fontsFolder);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        if (accept != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"application/json"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public String startSplit(String name, SlideExportFormat format, ExportOptions options, Integer width, Integer height, Integer from, Integer to, String destFolder, String password, String folder, String storage, String fontsFolder) throws ApiException {
        try {
            ApiResponse<String> resp = this.startSplitWithHttpInfo(name, format, options, width, height, from, to, destFolder, password, folder, storage, fontsFolder);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<String> resp = this.startSplitWithHttpInfo(name, format, options, width, height, from, to, destFolder, password, folder, storage, fontsFolder);
            return resp.getData();
        }
    }

    public ApiResponse<String> startSplitWithHttpInfo(String name, SlideExportFormat format, ExportOptions options, Integer width, Integer height, Integer from, Integer to, String destFolder, String password, String folder, String storage, String fontsFolder) throws ApiException {
        Call call = this.startSplitCall(name, format, options, width, height, from, to, destFolder, password, folder, storage, fontsFolder, null, null);
        Type returnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call startSplitAsync(String name, SlideExportFormat format, ExportOptions options, Integer width, Integer height, Integer from, Integer to, String destFolder, String password, String folder, String storage, String fontsFolder, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.startSplitCall(name, format, options, width, height, from, to, destFolder, password, folder, storage, fontsFolder, progressListener, progressRequestListener);
        Type returnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call startUploadAndSplitCall(byte[] document, SlideExportFormat format, String destFolder, Integer width, Integer height, Integer from, Integer to, String password, String storage, String fontsFolder, ExportOptions options, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] accepts;
        String accept;
        if (document == null) {
            throw new ApiException("Missing the required parameter 'document' when calling startUploadAndSplit(Async)");
        }
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling startUploadAndSplit(Async)");
        }
        ExportOptions postBody = options;
        String methodPath = "/slides/async/split/{format}".replaceAll("\\{format\\}", this.apiClient.objectToString((Object)format));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "destFolder", destFolder);
        this.apiClient.addQueryParameter(queryParams, "width", width);
        this.apiClient.addQueryParameter(queryParams, "height", height);
        this.apiClient.addQueryParameter(queryParams, "from", from);
        this.apiClient.addQueryParameter(queryParams, "to", to);
        this.apiClient.addQueryParameter(queryParams, "storage", storage);
        this.apiClient.addQueryParameter(queryParams, "fontsFolder", fontsFolder);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (password != null) {
            headerParams.put("password", this.apiClient.parameterToString(password));
        }
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        if (document != null) {
            formParams.put("document", document);
        }
        if ((accept = this.apiClient.selectHeaderAccept(accepts = new String[]{"application/json"})) != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"multipart/form-data"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "POST", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public String startUploadAndSplit(byte[] document, SlideExportFormat format, String destFolder, Integer width, Integer height, Integer from, Integer to, String password, String storage, String fontsFolder, ExportOptions options) throws ApiException {
        try {
            ApiResponse<String> resp = this.startUploadAndSplitWithHttpInfo(document, format, destFolder, width, height, from, to, password, storage, fontsFolder, options);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<String> resp = this.startUploadAndSplitWithHttpInfo(document, format, destFolder, width, height, from, to, password, storage, fontsFolder, options);
            return resp.getData();
        }
    }

    public ApiResponse<String> startUploadAndSplitWithHttpInfo(byte[] document, SlideExportFormat format, String destFolder, Integer width, Integer height, Integer from, Integer to, String password, String storage, String fontsFolder, ExportOptions options) throws ApiException {
        Call call = this.startUploadAndSplitCall(document, format, destFolder, width, height, from, to, password, storage, fontsFolder, options, null, null);
        Type returnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call startUploadAndSplitAsync(byte[] document, SlideExportFormat format, String destFolder, Integer width, Integer height, Integer from, Integer to, String password, String storage, String fontsFolder, ExportOptions options, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.startUploadAndSplitCall(document, format, destFolder, width, height, from, to, password, storage, fontsFolder, options, progressListener, progressRequestListener);
        Type returnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }

    public Call uploadCall(String path, byte[] file, String storageName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] accepts;
        String accept;
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling upload(Async)");
        }
        Object postBody = null;
        String methodPath = "/slides/async/storage/file/{path}".replaceAll("\\{path\\}", this.apiClient.objectToString(path));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.apiClient.addQueryParameter(queryParams, "storageName", storageName);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> formParams = new LinkedHashMap<String, Object>();
        if (file != null) {
            formParams.put("file", file);
        }
        if ((accept = this.apiClient.selectHeaderAccept(accepts = new String[]{"application/json"})) != null) {
            headerParams.put("Accept", accept);
        }
        String[] contentTypes = new String[]{"multipart/form-data"};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        headerParams.put("Content-Type", contentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return this.apiClient.buildCall(methodPath, "PUT", queryParams, postBody, headerParams, formParams, progressRequestListener);
    }

    public FilesUploadResult upload(String path, byte[] file, String storageName) throws ApiException {
        try {
            ApiResponse<FilesUploadResult> resp = this.uploadWithHttpInfo(path, file, storageName);
            return resp.getData();
        }
        catch (NeedRepeatRequestException e) {
            ApiResponse<FilesUploadResult> resp = this.uploadWithHttpInfo(path, file, storageName);
            return resp.getData();
        }
    }

    public ApiResponse<FilesUploadResult> uploadWithHttpInfo(String path, byte[] file, String storageName) throws ApiException {
        Call call = this.uploadCall(path, file, storageName, null, null);
        Type returnType = new TypeToken<FilesUploadResult>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call uploadAsync(String path, byte[] file, String storageName, final ApiCallback<FilesUploadResult> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.uploadCall(path, file, storageName, progressListener, progressRequestListener);
        Type returnType = new TypeToken<FilesUploadResult>(){}.getType();
        this.apiClient.executeAsync(call, returnType, callback);
        return call;
    }
}

