/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.auth;

import com.aspose.slides.ApiClient;
import com.aspose.slides.ApiException;
import com.aspose.slides.ApiResponse;
import com.aspose.slides.Configuration;
import com.aspose.slides.auth.AuthResponse;
import com.aspose.slides.auth.Authentication;
import com.aspose.slides.auth.NeedRepeatRequestException;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class JWTAuth
extends Authentication {
    private final Configuration config;
    private final ApiClient apiClient;
    private Map<String, Object> grantCredentialsParams;

    public JWTAuth(Configuration config) {
        this.config = config;
        this.apiClient = new ApiClient(config.getAuthBaseUrl(), new Authentication());
    }

    @Override
    public void updateHeaderParams(Map<String, String> headerParams) throws ApiException {
        if (this.config.getAppSid() != null || this.config.getAuthToken() != null) {
            if (this.config.getAuthToken() == null) {
                this.requestToken();
            }
            headerParams.put("Authorization", "Bearer " + this.config.getAuthToken());
        }
    }

    @Override
    public void handleBadResponse(Response response) throws ApiException, IOException {
        if (response.code() == 401) {
            this.requestToken();
            throw new NeedRepeatRequestException();
        }
    }

    private synchronized void requestToken() throws ApiException {
        if (this.grantCredentialsParams == null) {
            this.grantCredentialsParams = new HashMap<String, Object>();
            this.grantCredentialsParams.put("grant_type", "client_credentials");
            this.grantCredentialsParams.put("client_id", this.config.getAppSid());
            this.grantCredentialsParams.put("client_secret", this.config.getAppKey());
        }
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put("Content-Type", "application/x-www-form-urlencoded");
        Call call = this.apiClient.buildCall("/connect/token", "POST", null, null, headerParams, this.grantCredentialsParams, null);
        try {
            ApiResponse response = this.apiClient.execute(call, new TypeToken<AuthResponse>(){}.getType());
            this.config.setAuthToken(((AuthResponse)response.getData()).getAccessToken());
        }
        catch (ApiException ex) {
            throw new ApiException(401, ex.getMessage());
        }
    }
}

