/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.InputFile;
import com.aspose.slides.model.Task;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Add master slide task.")
public class AddMasterSlide
extends Task {
    @SerializedName(value="cloneFromFile", alternate={"CloneFromFile"})
    private InputFile cloneFromFile;
    @SerializedName(value="cloneFromPosition", alternate={"CloneFromPosition"})
    private Integer cloneFromPosition;
    @SerializedName(value="applyToAll", alternate={"ApplyToAll"})
    private Boolean applyToAll;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public AddMasterSlide() {
        this.setType(Task.TypeEnum.ADDMASTERSLIDE);
    }

    public AddMasterSlide cloneFromFile(InputFile cloneFromFile) {
        this.cloneFromFile = cloneFromFile;
        return this;
    }

    @ApiModelProperty(value="Source presentation clone from.")
    public InputFile getCloneFromFile() {
        return this.cloneFromFile;
    }

    public void setCloneFromFile(InputFile cloneFromFile) {
        this.cloneFromFile = cloneFromFile;
    }

    public AddMasterSlide cloneFromPosition(Integer cloneFromPosition) {
        this.cloneFromPosition = cloneFromPosition;
        return this;
    }

    @ApiModelProperty(required=true, value="Index of slide to clone.")
    public Integer getCloneFromPosition() {
        return this.cloneFromPosition;
    }

    public void setCloneFromPosition(Integer cloneFromPosition) {
        this.cloneFromPosition = cloneFromPosition;
    }

    public AddMasterSlide applyToAll(Boolean applyToAll) {
        this.applyToAll = applyToAll;
        return this;
    }

    @ApiModelProperty(required=true, value="True if cloned master slide is applied to all slides.")
    public Boolean isApplyToAll() {
        return this.applyToAll;
    }

    public void setApplyToAll(Boolean applyToAll) {
        this.applyToAll = applyToAll;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddMasterSlide addMasterSlide = (AddMasterSlide)o;
        return Objects.equals(this.cloneFromFile, addMasterSlide.cloneFromFile) && Objects.equals(this.cloneFromPosition, addMasterSlide.cloneFromPosition) && Objects.equals(this.applyToAll, addMasterSlide.applyToAll) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.cloneFromFile, this.cloneFromPosition, this.applyToAll, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AddMasterSlide {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    cloneFromFile: ").append(this.toIndentedString(this.cloneFromFile)).append("\n");
        sb.append("    cloneFromPosition: ").append(this.toIndentedString(this.cloneFromPosition)).append("\n");
        sb.append("    applyToAll: ").append(this.toIndentedString(this.applyToAll)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    static {
        typeDeterminers.put("Type", (Object)Task.TypeEnum.ADDMASTERSLIDE);
    }
}

