/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.MathElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="An array of elements.")
public class ArrayElement
extends MathElement {
    @SerializedName(value="arguments", alternate={"Arguments"})
    private List<MathElement> arguments = null;
    @SerializedName(value="baseJustification", alternate={"BaseJustification"})
    private BaseJustificationEnum baseJustification;
    @SerializedName(value="maximumDistribution", alternate={"MaximumDistribution"})
    private Boolean maximumDistribution;
    @SerializedName(value="objectDistribution", alternate={"ObjectDistribution"})
    private Boolean objectDistribution;
    @SerializedName(value="rowSpacingRule", alternate={"RowSpacingRule"})
    private RowSpacingRuleEnum rowSpacingRule;
    @SerializedName(value="rowSpacing", alternate={"RowSpacing"})
    private Integer rowSpacing;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public ArrayElement() {
        this.setType(MathElement.TypeEnum.ARRAY);
    }

    public ArrayElement arguments(List<MathElement> arguments) {
        this.arguments = arguments;
        return this;
    }

    public ArrayElement addArgumentsItem(MathElement argumentsItem) {
        if (this.arguments == null) {
            this.arguments = new ArrayList<MathElement>();
        }
        this.arguments.add(argumentsItem);
        return this;
    }

    @ApiModelProperty(value="Arguments")
    public List<MathElement> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<MathElement> arguments) {
        this.arguments = arguments;
    }

    public ArrayElement baseJustification(BaseJustificationEnum baseJustification) {
        this.baseJustification = baseJustification;
        return this;
    }

    @ApiModelProperty(value="Specifies alignment of the array relative to surrounding text")
    public BaseJustificationEnum getBaseJustification() {
        return this.baseJustification;
    }

    public void setBaseJustification(BaseJustificationEnum baseJustification) {
        this.baseJustification = baseJustification;
    }

    public ArrayElement maximumDistribution(Boolean maximumDistribution) {
        this.maximumDistribution = maximumDistribution;
        return this;
    }

    @ApiModelProperty(value="Maximum Distribution")
    public Boolean isMaximumDistribution() {
        return this.maximumDistribution;
    }

    public void setMaximumDistribution(Boolean maximumDistribution) {
        this.maximumDistribution = maximumDistribution;
    }

    public ArrayElement objectDistribution(Boolean objectDistribution) {
        this.objectDistribution = objectDistribution;
        return this;
    }

    @ApiModelProperty(value="Object Distribution")
    public Boolean isObjectDistribution() {
        return this.objectDistribution;
    }

    public void setObjectDistribution(Boolean objectDistribution) {
        this.objectDistribution = objectDistribution;
    }

    public ArrayElement rowSpacingRule(RowSpacingRuleEnum rowSpacingRule) {
        this.rowSpacingRule = rowSpacingRule;
        return this;
    }

    @ApiModelProperty(value="The type of vertical spacing between array elements")
    public RowSpacingRuleEnum getRowSpacingRule() {
        return this.rowSpacingRule;
    }

    public void setRowSpacingRule(RowSpacingRuleEnum rowSpacingRule) {
        this.rowSpacingRule = rowSpacingRule;
    }

    public ArrayElement rowSpacing(Integer rowSpacing) {
        this.rowSpacing = rowSpacing;
        return this;
    }

    @ApiModelProperty(value="Spacing between rows of an array")
    public Integer getRowSpacing() {
        return this.rowSpacing;
    }

    public void setRowSpacing(Integer rowSpacing) {
        this.rowSpacing = rowSpacing;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrayElement arrayElement = (ArrayElement)o;
        return Objects.equals(this.arguments, arrayElement.arguments) && Objects.equals((Object)this.baseJustification, (Object)arrayElement.baseJustification) && Objects.equals(this.maximumDistribution, arrayElement.maximumDistribution) && Objects.equals(this.objectDistribution, arrayElement.objectDistribution) && Objects.equals((Object)this.rowSpacingRule, (Object)arrayElement.rowSpacingRule) && Objects.equals(this.rowSpacing, arrayElement.rowSpacing) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.arguments, this.baseJustification, this.maximumDistribution, this.objectDistribution, this.rowSpacingRule, this.rowSpacing, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ArrayElement {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    arguments: ").append(this.toIndentedString(this.arguments)).append("\n");
        sb.append("    baseJustification: ").append(this.toIndentedString((Object)this.baseJustification)).append("\n");
        sb.append("    maximumDistribution: ").append(this.toIndentedString(this.maximumDistribution)).append("\n");
        sb.append("    objectDistribution: ").append(this.toIndentedString(this.objectDistribution)).append("\n");
        sb.append("    rowSpacingRule: ").append(this.toIndentedString((Object)this.rowSpacingRule)).append("\n");
        sb.append("    rowSpacing: ").append(this.toIndentedString(this.rowSpacing)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    static {
        typeDeterminers.put("Type", (Object)MathElement.TypeEnum.ARRAY);
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RowSpacingRuleEnum {
        SINGLELINEGAP("SingleLineGap"),
        ONEANDAHALFLINEGAP("OneAndAHalfLineGap"),
        TWOLINEGAP("TwoLineGap"),
        EXACTLY("Exactly"),
        MULTIPLE("Multiple");

        private String value;

        private RowSpacingRuleEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RowSpacingRuleEnum fromValue(String text) {
            for (RowSpacingRuleEnum b : RowSpacingRuleEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<RowSpacingRuleEnum> {
            public void write(JsonWriter jsonWriter, RowSpacingRuleEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public RowSpacingRuleEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RowSpacingRuleEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum BaseJustificationEnum {
        NOTDEFINED("NotDefined"),
        TOP("Top"),
        CENTER("Center"),
        BOTTOM("Bottom");

        private String value;

        private BaseJustificationEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static BaseJustificationEnum fromValue(String text) {
            for (BaseJustificationEnum b : BaseJustificationEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<BaseJustificationEnum> {
            public void write(JsonWriter jsonWriter, BaseJustificationEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public BaseJustificationEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return BaseJustificationEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

