/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.GeometryShape;
import com.aspose.slides.model.PictureFill;
import com.aspose.slides.model.ShapeBase;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Represents AudioFrame resource.")
public class AudioFrame
extends GeometryShape {
    @SerializedName(value="audioCdEndTrack", alternate={"AudioCdEndTrack"})
    private Integer audioCdEndTrack;
    @SerializedName(value="audioCdEndTrackTime", alternate={"AudioCdEndTrackTime"})
    private Integer audioCdEndTrackTime;
    @SerializedName(value="audioCdStartTrack", alternate={"AudioCdStartTrack"})
    private Integer audioCdStartTrack;
    @SerializedName(value="audioCdStartTrackTime", alternate={"AudioCdStartTrackTime"})
    private Integer audioCdStartTrackTime;
    @SerializedName(value="embedded", alternate={"Embedded"})
    private Boolean embedded;
    @SerializedName(value="hideAtShowing", alternate={"HideAtShowing"})
    private Boolean hideAtShowing;
    @SerializedName(value="playLoopMode", alternate={"PlayLoopMode"})
    private Boolean playLoopMode;
    @SerializedName(value="playMode", alternate={"PlayMode"})
    private PlayModeEnum playMode;
    @SerializedName(value="volume", alternate={"Volume"})
    private VolumeEnum volume;
    @SerializedName(value="volumeValue", alternate={"VolumeValue"})
    private Double volumeValue;
    @SerializedName(value="base64Data", alternate={"Base64Data"})
    private String base64Data;
    @SerializedName(value="playAcrossSlides", alternate={"PlayAcrossSlides"})
    private Boolean playAcrossSlides;
    @SerializedName(value="rewindAudio", alternate={"RewindAudio"})
    private Boolean rewindAudio;
    @SerializedName(value="fadeInDuration", alternate={"FadeInDuration"})
    private Double fadeInDuration;
    @SerializedName(value="fadeOutDuration", alternate={"FadeOutDuration"})
    private Double fadeOutDuration;
    @SerializedName(value="trimFromStart", alternate={"TrimFromStart"})
    private Double trimFromStart;
    @SerializedName(value="trimFromEnd", alternate={"TrimFromEnd"})
    private Double trimFromEnd;
    @SerializedName(value="pictureFillFormat", alternate={"PictureFillFormat"})
    private PictureFill pictureFillFormat;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public AudioFrame() {
        this.setType(ShapeBase.TypeEnum.AUDIOFRAME);
    }

    public AudioFrame audioCdEndTrack(Integer audioCdEndTrack) {
        this.audioCdEndTrack = audioCdEndTrack;
        return this;
    }

    @ApiModelProperty(value="Returns or sets a last track index.")
    public Integer getAudioCdEndTrack() {
        return this.audioCdEndTrack;
    }

    public void setAudioCdEndTrack(Integer audioCdEndTrack) {
        this.audioCdEndTrack = audioCdEndTrack;
    }

    public AudioFrame audioCdEndTrackTime(Integer audioCdEndTrackTime) {
        this.audioCdEndTrackTime = audioCdEndTrackTime;
        return this;
    }

    @ApiModelProperty(value="Returns or sets a last track time.")
    public Integer getAudioCdEndTrackTime() {
        return this.audioCdEndTrackTime;
    }

    public void setAudioCdEndTrackTime(Integer audioCdEndTrackTime) {
        this.audioCdEndTrackTime = audioCdEndTrackTime;
    }

    public AudioFrame audioCdStartTrack(Integer audioCdStartTrack) {
        this.audioCdStartTrack = audioCdStartTrack;
        return this;
    }

    @ApiModelProperty(value="Returns or sets a start track index.")
    public Integer getAudioCdStartTrack() {
        return this.audioCdStartTrack;
    }

    public void setAudioCdStartTrack(Integer audioCdStartTrack) {
        this.audioCdStartTrack = audioCdStartTrack;
    }

    public AudioFrame audioCdStartTrackTime(Integer audioCdStartTrackTime) {
        this.audioCdStartTrackTime = audioCdStartTrackTime;
        return this;
    }

    @ApiModelProperty(value="Returns or sets a start track time. ")
    public Integer getAudioCdStartTrackTime() {
        return this.audioCdStartTrackTime;
    }

    public void setAudioCdStartTrackTime(Integer audioCdStartTrackTime) {
        this.audioCdStartTrackTime = audioCdStartTrackTime;
    }

    public AudioFrame embedded(Boolean embedded) {
        this.embedded = embedded;
        return this;
    }

    @ApiModelProperty(value="Determines whether a sound is embedded to a presentation.")
    public Boolean isEmbedded() {
        return this.embedded;
    }

    public void setEmbedded(Boolean embedded) {
        this.embedded = embedded;
    }

    public AudioFrame hideAtShowing(Boolean hideAtShowing) {
        this.hideAtShowing = hideAtShowing;
        return this;
    }

    @ApiModelProperty(value="Determines whether an AudioFrame is hidden.")
    public Boolean isHideAtShowing() {
        return this.hideAtShowing;
    }

    public void setHideAtShowing(Boolean hideAtShowing) {
        this.hideAtShowing = hideAtShowing;
    }

    public AudioFrame playLoopMode(Boolean playLoopMode) {
        this.playLoopMode = playLoopMode;
        return this;
    }

    @ApiModelProperty(value="Determines whether an audio is looped. ")
    public Boolean isPlayLoopMode() {
        return this.playLoopMode;
    }

    public void setPlayLoopMode(Boolean playLoopMode) {
        this.playLoopMode = playLoopMode;
    }

    public AudioFrame playMode(PlayModeEnum playMode) {
        this.playMode = playMode;
        return this;
    }

    @ApiModelProperty(value="Returns or sets the audio play mode.")
    public PlayModeEnum getPlayMode() {
        return this.playMode;
    }

    public void setPlayMode(PlayModeEnum playMode) {
        this.playMode = playMode;
    }

    public AudioFrame volume(VolumeEnum volume) {
        this.volume = volume;
        return this;
    }

    @ApiModelProperty(value="Returns or sets the audio volume.")
    public VolumeEnum getVolume() {
        return this.volume;
    }

    public void setVolume(VolumeEnum volume) {
        this.volume = volume;
    }

    public AudioFrame volumeValue(Double volumeValue) {
        this.volumeValue = volumeValue;
        return this;
    }

    @ApiModelProperty(value="Audio volume percent.")
    public Double getVolumeValue() {
        return this.volumeValue;
    }

    public void setVolumeValue(Double volumeValue) {
        this.volumeValue = volumeValue;
    }

    public AudioFrame base64Data(String base64Data) {
        this.base64Data = base64Data;
        return this;
    }

    @ApiModelProperty(value="Audio data encoded in base64.")
    public String getBase64Data() {
        return this.base64Data;
    }

    public void setBase64Data(String base64Data) {
        this.base64Data = base64Data;
    }

    public AudioFrame playAcrossSlides(Boolean playAcrossSlides) {
        this.playAcrossSlides = playAcrossSlides;
        return this;
    }

    @ApiModelProperty(value="Determines whether an audio is playing across the slides.")
    public Boolean isPlayAcrossSlides() {
        return this.playAcrossSlides;
    }

    public void setPlayAcrossSlides(Boolean playAcrossSlides) {
        this.playAcrossSlides = playAcrossSlides;
    }

    public AudioFrame rewindAudio(Boolean rewindAudio) {
        this.rewindAudio = rewindAudio;
        return this;
    }

    @ApiModelProperty(value="Determines whether audio is automatically rewound to start after playing.")
    public Boolean isRewindAudio() {
        return this.rewindAudio;
    }

    public void setRewindAudio(Boolean rewindAudio) {
        this.rewindAudio = rewindAudio;
    }

    public AudioFrame fadeInDuration(Double fadeInDuration) {
        this.fadeInDuration = fadeInDuration;
        return this;
    }

    @ApiModelProperty(value="Time duration for the initial fade-in of the media in milliseconds.")
    public Double getFadeInDuration() {
        return this.fadeInDuration;
    }

    public void setFadeInDuration(Double fadeInDuration) {
        this.fadeInDuration = fadeInDuration;
    }

    public AudioFrame fadeOutDuration(Double fadeOutDuration) {
        this.fadeOutDuration = fadeOutDuration;
        return this;
    }

    @ApiModelProperty(value="Time duration for the ending fade-out of the media in milliseconds.")
    public Double getFadeOutDuration() {
        return this.fadeOutDuration;
    }

    public void setFadeOutDuration(Double fadeOutDuration) {
        this.fadeOutDuration = fadeOutDuration;
    }

    public AudioFrame trimFromStart(Double trimFromStart) {
        this.trimFromStart = trimFromStart;
        return this;
    }

    @ApiModelProperty(value="Time duration to be removed from the beginning of the media during playback in milliseconds.")
    public Double getTrimFromStart() {
        return this.trimFromStart;
    }

    public void setTrimFromStart(Double trimFromStart) {
        this.trimFromStart = trimFromStart;
    }

    public AudioFrame trimFromEnd(Double trimFromEnd) {
        this.trimFromEnd = trimFromEnd;
        return this;
    }

    @ApiModelProperty(value="Time duration to be removed from the end of the media during playback in milliseconds.")
    public Double getTrimFromEnd() {
        return this.trimFromEnd;
    }

    public void setTrimFromEnd(Double trimFromEnd) {
        this.trimFromEnd = trimFromEnd;
    }

    public AudioFrame pictureFillFormat(PictureFill pictureFillFormat) {
        this.pictureFillFormat = pictureFillFormat;
        return this;
    }

    @ApiModelProperty(value="Picture fill format.")
    public PictureFill getPictureFillFormat() {
        return this.pictureFillFormat;
    }

    public void setPictureFillFormat(PictureFill pictureFillFormat) {
        this.pictureFillFormat = pictureFillFormat;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AudioFrame audioFrame = (AudioFrame)o;
        return Objects.equals(this.audioCdEndTrack, audioFrame.audioCdEndTrack) && Objects.equals(this.audioCdEndTrackTime, audioFrame.audioCdEndTrackTime) && Objects.equals(this.audioCdStartTrack, audioFrame.audioCdStartTrack) && Objects.equals(this.audioCdStartTrackTime, audioFrame.audioCdStartTrackTime) && Objects.equals(this.embedded, audioFrame.embedded) && Objects.equals(this.hideAtShowing, audioFrame.hideAtShowing) && Objects.equals(this.playLoopMode, audioFrame.playLoopMode) && Objects.equals((Object)this.playMode, (Object)audioFrame.playMode) && Objects.equals((Object)this.volume, (Object)audioFrame.volume) && Objects.equals(this.volumeValue, audioFrame.volumeValue) && Objects.equals(this.base64Data, audioFrame.base64Data) && Objects.equals(this.playAcrossSlides, audioFrame.playAcrossSlides) && Objects.equals(this.rewindAudio, audioFrame.rewindAudio) && Objects.equals(this.fadeInDuration, audioFrame.fadeInDuration) && Objects.equals(this.fadeOutDuration, audioFrame.fadeOutDuration) && Objects.equals(this.trimFromStart, audioFrame.trimFromStart) && Objects.equals(this.trimFromEnd, audioFrame.trimFromEnd) && Objects.equals(this.pictureFillFormat, audioFrame.pictureFillFormat) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.audioCdEndTrack, this.audioCdEndTrackTime, this.audioCdStartTrack, this.audioCdStartTrackTime, this.embedded, this.hideAtShowing, this.playLoopMode, this.playMode, this.volume, this.volumeValue, this.base64Data, this.playAcrossSlides, this.rewindAudio, this.fadeInDuration, this.fadeOutDuration, this.trimFromStart, this.trimFromEnd, this.pictureFillFormat, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AudioFrame {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    audioCdEndTrack: ").append(this.toIndentedString(this.audioCdEndTrack)).append("\n");
        sb.append("    audioCdEndTrackTime: ").append(this.toIndentedString(this.audioCdEndTrackTime)).append("\n");
        sb.append("    audioCdStartTrack: ").append(this.toIndentedString(this.audioCdStartTrack)).append("\n");
        sb.append("    audioCdStartTrackTime: ").append(this.toIndentedString(this.audioCdStartTrackTime)).append("\n");
        sb.append("    embedded: ").append(this.toIndentedString(this.embedded)).append("\n");
        sb.append("    hideAtShowing: ").append(this.toIndentedString(this.hideAtShowing)).append("\n");
        sb.append("    playLoopMode: ").append(this.toIndentedString(this.playLoopMode)).append("\n");
        sb.append("    playMode: ").append(this.toIndentedString((Object)this.playMode)).append("\n");
        sb.append("    volume: ").append(this.toIndentedString((Object)this.volume)).append("\n");
        sb.append("    volumeValue: ").append(this.toIndentedString(this.volumeValue)).append("\n");
        sb.append("    base64Data: ").append(this.toIndentedString(this.base64Data)).append("\n");
        sb.append("    playAcrossSlides: ").append(this.toIndentedString(this.playAcrossSlides)).append("\n");
        sb.append("    rewindAudio: ").append(this.toIndentedString(this.rewindAudio)).append("\n");
        sb.append("    fadeInDuration: ").append(this.toIndentedString(this.fadeInDuration)).append("\n");
        sb.append("    fadeOutDuration: ").append(this.toIndentedString(this.fadeOutDuration)).append("\n");
        sb.append("    trimFromStart: ").append(this.toIndentedString(this.trimFromStart)).append("\n");
        sb.append("    trimFromEnd: ").append(this.toIndentedString(this.trimFromEnd)).append("\n");
        sb.append("    pictureFillFormat: ").append(this.toIndentedString(this.pictureFillFormat)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    static {
        typeDeterminers.put("Type", (Object)ShapeBase.TypeEnum.AUDIOFRAME);
    }

    @JsonAdapter(value=Adapter.class)
    public static enum VolumeEnum {
        MUTE("Mute"),
        LOW("Low"),
        MEDIUM("Medium"),
        LOUD("Loud"),
        MIXED("Mixed");

        private String value;

        private VolumeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static VolumeEnum fromValue(String text) {
            for (VolumeEnum b : VolumeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<VolumeEnum> {
            public void write(JsonWriter jsonWriter, VolumeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public VolumeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return VolumeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PlayModeEnum {
        AUTO("Auto"),
        ONCLICK("OnClick"),
        ALLSLIDES("AllSlides"),
        INCLICKSEQUENCE("InClickSequence"),
        MIXED("Mixed");

        private String value;

        private PlayModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PlayModeEnum fromValue(String text) {
            for (PlayModeEnum b : PlayModeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<PlayModeEnum> {
            public void write(JsonWriter jsonWriter, PlayModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PlayModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PlayModeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

