/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.ChartLinesFormat;
import com.aspose.slides.model.ChartTitle;
import com.aspose.slides.model.EffectFormat;
import com.aspose.slides.model.FillFormat;
import com.aspose.slides.model.LineFormat;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Represents a chart axis")
public class Axis {
    @SerializedName(value="isVisible", alternate={"IsVisible"})
    private Boolean isVisible;
    @SerializedName(value="hasTitle", alternate={"HasTitle"})
    private Boolean hasTitle;
    @SerializedName(value="title", alternate={"Title"})
    private ChartTitle title;
    @SerializedName(value="position", alternate={"Position"})
    private PositionEnum position;
    @SerializedName(value="displayUnit", alternate={"DisplayUnit"})
    private DisplayUnitEnum displayUnit;
    @SerializedName(value="baseUnitScale", alternate={"BaseUnitScale"})
    private BaseUnitScaleEnum baseUnitScale;
    @SerializedName(value="isAutomaticMajorUnit", alternate={"IsAutomaticMajorUnit"})
    private Boolean isAutomaticMajorUnit;
    @SerializedName(value="majorUnit", alternate={"MajorUnit"})
    private Double majorUnit;
    @SerializedName(value="majorUnitScale", alternate={"MajorUnitScale"})
    private MajorUnitScaleEnum majorUnitScale;
    @SerializedName(value="majorTickMark", alternate={"MajorTickMark"})
    private MajorTickMarkEnum majorTickMark;
    @SerializedName(value="isAutomaticMinorUnit", alternate={"IsAutomaticMinorUnit"})
    private Boolean isAutomaticMinorUnit;
    @SerializedName(value="minorUnit", alternate={"MinorUnit"})
    private Double minorUnit;
    @SerializedName(value="minorUnitScale", alternate={"MinorUnitScale"})
    private MinorUnitScaleEnum minorUnitScale;
    @SerializedName(value="minorTickMark", alternate={"MinorTickMark"})
    private MinorTickMarkEnum minorTickMark;
    @SerializedName(value="isAutomaticMaxValue", alternate={"IsAutomaticMaxValue"})
    private Boolean isAutomaticMaxValue;
    @SerializedName(value="maxValue", alternate={"MaxValue"})
    private Double maxValue;
    @SerializedName(value="isAutomaticMinValue", alternate={"IsAutomaticMinValue"})
    private Boolean isAutomaticMinValue;
    @SerializedName(value="minValue", alternate={"MinValue"})
    private Double minValue;
    @SerializedName(value="isLogarithmic", alternate={"IsLogarithmic"})
    private Boolean isLogarithmic;
    @SerializedName(value="logBase", alternate={"LogBase"})
    private Double logBase;
    @SerializedName(value="categoryAxisType", alternate={"CategoryAxisType"})
    private CategoryAxisTypeEnum categoryAxisType;
    @SerializedName(value="axisBetweenCategories", alternate={"AxisBetweenCategories"})
    private Boolean axisBetweenCategories;
    @SerializedName(value="labelOffset", alternate={"LabelOffset"})
    private Integer labelOffset;
    @SerializedName(value="isPlotOrderReversed", alternate={"IsPlotOrderReversed"})
    private Boolean isPlotOrderReversed;
    @SerializedName(value="isNumberFormatLinkedToSource", alternate={"IsNumberFormatLinkedToSource"})
    private Boolean isNumberFormatLinkedToSource;
    @SerializedName(value="numberFormat", alternate={"NumberFormat"})
    private String numberFormat;
    @SerializedName(value="crossType", alternate={"CrossType"})
    private CrossTypeEnum crossType;
    @SerializedName(value="crossAt", alternate={"CrossAt"})
    private Double crossAt;
    @SerializedName(value="isAutomaticTickMarksSpacing", alternate={"IsAutomaticTickMarksSpacing"})
    private Boolean isAutomaticTickMarksSpacing;
    @SerializedName(value="tickMarksSpacing", alternate={"TickMarksSpacing"})
    private Integer tickMarksSpacing;
    @SerializedName(value="isAutomaticTickLabelSpacing", alternate={"IsAutomaticTickLabelSpacing"})
    private Boolean isAutomaticTickLabelSpacing;
    @SerializedName(value="tickLabelSpacing", alternate={"TickLabelSpacing"})
    private Integer tickLabelSpacing;
    @SerializedName(value="tickLabelPosition", alternate={"TickLabelPosition"})
    private TickLabelPositionEnum tickLabelPosition;
    @SerializedName(value="tickLabelRotationAngle", alternate={"TickLabelRotationAngle"})
    private Double tickLabelRotationAngle;
    @SerializedName(value="fillFormat", alternate={"FillFormat"})
    private FillFormat fillFormat;
    @SerializedName(value="effectFormat", alternate={"EffectFormat"})
    private EffectFormat effectFormat;
    @SerializedName(value="lineFormat", alternate={"LineFormat"})
    private LineFormat lineFormat;
    @SerializedName(value="majorGridLinesFormat", alternate={"MajorGridLinesFormat"})
    private ChartLinesFormat majorGridLinesFormat;
    @SerializedName(value="minorGridLinesFormat", alternate={"MinorGridLinesFormat"})
    private ChartLinesFormat minorGridLinesFormat;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public Axis isVisible(Boolean isVisible) {
        this.isVisible = isVisible;
        return this;
    }

    @ApiModelProperty(value="True if the axis is visible")
    public Boolean getIsVisible() {
        return this.isVisible;
    }

    public void setIsVisible(Boolean isVisible) {
        this.isVisible = isVisible;
    }

    public Axis hasTitle(Boolean hasTitle) {
        this.hasTitle = hasTitle;
        return this;
    }

    @ApiModelProperty(value="True if the axis has a visible title")
    public Boolean isHasTitle() {
        return this.hasTitle;
    }

    public void setHasTitle(Boolean hasTitle) {
        this.hasTitle = hasTitle;
    }

    public Axis title(ChartTitle title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(value="Axis title")
    public ChartTitle getTitle() {
        return this.title;
    }

    public void setTitle(ChartTitle title) {
        this.title = title;
    }

    public Axis position(PositionEnum position) {
        this.position = position;
        return this;
    }

    @ApiModelProperty(value="Axis position")
    public PositionEnum getPosition() {
        return this.position;
    }

    public void setPosition(PositionEnum position) {
        this.position = position;
    }

    public Axis displayUnit(DisplayUnitEnum displayUnit) {
        this.displayUnit = displayUnit;
        return this;
    }

    @ApiModelProperty(value="The scaling value of the display units for the value axis")
    public DisplayUnitEnum getDisplayUnit() {
        return this.displayUnit;
    }

    public void setDisplayUnit(DisplayUnitEnum displayUnit) {
        this.displayUnit = displayUnit;
    }

    public Axis baseUnitScale(BaseUnitScaleEnum baseUnitScale) {
        this.baseUnitScale = baseUnitScale;
        return this;
    }

    @ApiModelProperty(value="The smallest time unit that is represented on the date axis")
    public BaseUnitScaleEnum getBaseUnitScale() {
        return this.baseUnitScale;
    }

    public void setBaseUnitScale(BaseUnitScaleEnum baseUnitScale) {
        this.baseUnitScale = baseUnitScale;
    }

    public Axis isAutomaticMajorUnit(Boolean isAutomaticMajorUnit) {
        this.isAutomaticMajorUnit = isAutomaticMajorUnit;
        return this;
    }

    @ApiModelProperty(value="True the major unit of the axis is automatically assigned")
    public Boolean getIsAutomaticMajorUnit() {
        return this.isAutomaticMajorUnit;
    }

    public void setIsAutomaticMajorUnit(Boolean isAutomaticMajorUnit) {
        this.isAutomaticMajorUnit = isAutomaticMajorUnit;
    }

    public Axis majorUnit(Double majorUnit) {
        this.majorUnit = majorUnit;
        return this;
    }

    @ApiModelProperty(value="The major units for the date or value axis")
    public Double getMajorUnit() {
        return this.majorUnit;
    }

    public void setMajorUnit(Double majorUnit) {
        this.majorUnit = majorUnit;
    }

    public Axis majorUnitScale(MajorUnitScaleEnum majorUnitScale) {
        this.majorUnitScale = majorUnitScale;
        return this;
    }

    @ApiModelProperty(value="The major unit scale for the date axis")
    public MajorUnitScaleEnum getMajorUnitScale() {
        return this.majorUnitScale;
    }

    public void setMajorUnitScale(MajorUnitScaleEnum majorUnitScale) {
        this.majorUnitScale = majorUnitScale;
    }

    public Axis majorTickMark(MajorTickMarkEnum majorTickMark) {
        this.majorTickMark = majorTickMark;
        return this;
    }

    @ApiModelProperty(value="The type of major tick mark for the specified axis")
    public MajorTickMarkEnum getMajorTickMark() {
        return this.majorTickMark;
    }

    public void setMajorTickMark(MajorTickMarkEnum majorTickMark) {
        this.majorTickMark = majorTickMark;
    }

    public Axis isAutomaticMinorUnit(Boolean isAutomaticMinorUnit) {
        this.isAutomaticMinorUnit = isAutomaticMinorUnit;
        return this;
    }

    @ApiModelProperty(value="True the minor unit of the axis is automatically assigned")
    public Boolean getIsAutomaticMinorUnit() {
        return this.isAutomaticMinorUnit;
    }

    public void setIsAutomaticMinorUnit(Boolean isAutomaticMinorUnit) {
        this.isAutomaticMinorUnit = isAutomaticMinorUnit;
    }

    public Axis minorUnit(Double minorUnit) {
        this.minorUnit = minorUnit;
        return this;
    }

    @ApiModelProperty(value="The minor units for the date or value axis")
    public Double getMinorUnit() {
        return this.minorUnit;
    }

    public void setMinorUnit(Double minorUnit) {
        this.minorUnit = minorUnit;
    }

    public Axis minorUnitScale(MinorUnitScaleEnum minorUnitScale) {
        this.minorUnitScale = minorUnitScale;
        return this;
    }

    @ApiModelProperty(value="The minor unit scale for the date axis")
    public MinorUnitScaleEnum getMinorUnitScale() {
        return this.minorUnitScale;
    }

    public void setMinorUnitScale(MinorUnitScaleEnum minorUnitScale) {
        this.minorUnitScale = minorUnitScale;
    }

    public Axis minorTickMark(MinorTickMarkEnum minorTickMark) {
        this.minorTickMark = minorTickMark;
        return this;
    }

    @ApiModelProperty(value="The type of minor tick mark for the specified axis")
    public MinorTickMarkEnum getMinorTickMark() {
        return this.minorTickMark;
    }

    public void setMinorTickMark(MinorTickMarkEnum minorTickMark) {
        this.minorTickMark = minorTickMark;
    }

    public Axis isAutomaticMaxValue(Boolean isAutomaticMaxValue) {
        this.isAutomaticMaxValue = isAutomaticMaxValue;
        return this;
    }

    @ApiModelProperty(value="True if the max value is automatically assigned")
    public Boolean getIsAutomaticMaxValue() {
        return this.isAutomaticMaxValue;
    }

    public void setIsAutomaticMaxValue(Boolean isAutomaticMaxValue) {
        this.isAutomaticMaxValue = isAutomaticMaxValue;
    }

    public Axis maxValue(Double maxValue) {
        this.maxValue = maxValue;
        return this;
    }

    @ApiModelProperty(value="The maximum value on the value axis")
    public Double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(Double maxValue) {
        this.maxValue = maxValue;
    }

    public Axis isAutomaticMinValue(Boolean isAutomaticMinValue) {
        this.isAutomaticMinValue = isAutomaticMinValue;
        return this;
    }

    @ApiModelProperty(value="True if the min value is automatically assigned")
    public Boolean getIsAutomaticMinValue() {
        return this.isAutomaticMinValue;
    }

    public void setIsAutomaticMinValue(Boolean isAutomaticMinValue) {
        this.isAutomaticMinValue = isAutomaticMinValue;
    }

    public Axis minValue(Double minValue) {
        this.minValue = minValue;
        return this;
    }

    @ApiModelProperty(value="The minimum value on the value axis")
    public Double getMinValue() {
        return this.minValue;
    }

    public void setMinValue(Double minValue) {
        this.minValue = minValue;
    }

    public Axis isLogarithmic(Boolean isLogarithmic) {
        this.isLogarithmic = isLogarithmic;
        return this;
    }

    @ApiModelProperty(value="True if the value axis scale type is logarithmic")
    public Boolean getIsLogarithmic() {
        return this.isLogarithmic;
    }

    public void setIsLogarithmic(Boolean isLogarithmic) {
        this.isLogarithmic = isLogarithmic;
    }

    public Axis logBase(Double logBase) {
        this.logBase = logBase;
        return this;
    }

    @ApiModelProperty(value="The logarithmic base. Default value is 10")
    public Double getLogBase() {
        return this.logBase;
    }

    public void setLogBase(Double logBase) {
        this.logBase = logBase;
    }

    public Axis categoryAxisType(CategoryAxisTypeEnum categoryAxisType) {
        this.categoryAxisType = categoryAxisType;
        return this;
    }

    @ApiModelProperty(value="The type of the category axis")
    public CategoryAxisTypeEnum getCategoryAxisType() {
        return this.categoryAxisType;
    }

    public void setCategoryAxisType(CategoryAxisTypeEnum categoryAxisType) {
        this.categoryAxisType = categoryAxisType;
    }

    public Axis axisBetweenCategories(Boolean axisBetweenCategories) {
        this.axisBetweenCategories = axisBetweenCategories;
        return this;
    }

    @ApiModelProperty(value="True if the value axis crosses the category axis between categories. This property applies only to category axes, and it doesn't apply to 3-D charts")
    public Boolean isAxisBetweenCategories() {
        return this.axisBetweenCategories;
    }

    public void setAxisBetweenCategories(Boolean axisBetweenCategories) {
        this.axisBetweenCategories = axisBetweenCategories;
    }

    public Axis labelOffset(Integer labelOffset) {
        this.labelOffset = labelOffset;
        return this;
    }

    @ApiModelProperty(value="The distance of labels from the axis. Applied to category or date axis. Value must be between 0% and 1000%.             ")
    public Integer getLabelOffset() {
        return this.labelOffset;
    }

    public void setLabelOffset(Integer labelOffset) {
        this.labelOffset = labelOffset;
    }

    public Axis isPlotOrderReversed(Boolean isPlotOrderReversed) {
        this.isPlotOrderReversed = isPlotOrderReversed;
        return this;
    }

    @ApiModelProperty(value="True if MS PowerPoint plots data points from last to first")
    public Boolean getIsPlotOrderReversed() {
        return this.isPlotOrderReversed;
    }

    public void setIsPlotOrderReversed(Boolean isPlotOrderReversed) {
        this.isPlotOrderReversed = isPlotOrderReversed;
    }

    public Axis isNumberFormatLinkedToSource(Boolean isNumberFormatLinkedToSource) {
        this.isNumberFormatLinkedToSource = isNumberFormatLinkedToSource;
        return this;
    }

    @ApiModelProperty(value="True if the format is linked to source data")
    public Boolean getIsNumberFormatLinkedToSource() {
        return this.isNumberFormatLinkedToSource;
    }

    public void setIsNumberFormatLinkedToSource(Boolean isNumberFormatLinkedToSource) {
        this.isNumberFormatLinkedToSource = isNumberFormatLinkedToSource;
    }

    public Axis numberFormat(String numberFormat) {
        this.numberFormat = numberFormat;
        return this;
    }

    @ApiModelProperty(value="the format string for the Axis Labels")
    public String getNumberFormat() {
        return this.numberFormat;
    }

    public void setNumberFormat(String numberFormat) {
        this.numberFormat = numberFormat;
    }

    public Axis crossType(CrossTypeEnum crossType) {
        this.crossType = crossType;
        return this;
    }

    @ApiModelProperty(value="The CrossType on the specified axis where the other axis crosses")
    public CrossTypeEnum getCrossType() {
        return this.crossType;
    }

    public void setCrossType(CrossTypeEnum crossType) {
        this.crossType = crossType;
    }

    public Axis crossAt(Double crossAt) {
        this.crossAt = crossAt;
        return this;
    }

    @ApiModelProperty(value="The point on the axis where the perpendicular axis crosses it")
    public Double getCrossAt() {
        return this.crossAt;
    }

    public void setCrossAt(Double crossAt) {
        this.crossAt = crossAt;
    }

    public Axis isAutomaticTickMarksSpacing(Boolean isAutomaticTickMarksSpacing) {
        this.isAutomaticTickMarksSpacing = isAutomaticTickMarksSpacing;
        return this;
    }

    @ApiModelProperty(value="True for automatic tick marks spacing value")
    public Boolean getIsAutomaticTickMarksSpacing() {
        return this.isAutomaticTickMarksSpacing;
    }

    public void setIsAutomaticTickMarksSpacing(Boolean isAutomaticTickMarksSpacing) {
        this.isAutomaticTickMarksSpacing = isAutomaticTickMarksSpacing;
    }

    public Axis tickMarksSpacing(Integer tickMarksSpacing) {
        this.tickMarksSpacing = tickMarksSpacing;
        return this;
    }

    @ApiModelProperty(value="Specifies how many tick marks shall be skipped before the next one shall be drawn. Applied to category or series axis.")
    public Integer getTickMarksSpacing() {
        return this.tickMarksSpacing;
    }

    public void setTickMarksSpacing(Integer tickMarksSpacing) {
        this.tickMarksSpacing = tickMarksSpacing;
    }

    public Axis isAutomaticTickLabelSpacing(Boolean isAutomaticTickLabelSpacing) {
        this.isAutomaticTickLabelSpacing = isAutomaticTickLabelSpacing;
        return this;
    }

    @ApiModelProperty(value="True for automatic tick label spacing value")
    public Boolean getIsAutomaticTickLabelSpacing() {
        return this.isAutomaticTickLabelSpacing;
    }

    public void setIsAutomaticTickLabelSpacing(Boolean isAutomaticTickLabelSpacing) {
        this.isAutomaticTickLabelSpacing = isAutomaticTickLabelSpacing;
    }

    public Axis tickLabelSpacing(Integer tickLabelSpacing) {
        this.tickLabelSpacing = tickLabelSpacing;
        return this;
    }

    @ApiModelProperty(value="Specifies how many tick labels to skip between label that is drawn.")
    public Integer getTickLabelSpacing() {
        return this.tickLabelSpacing;
    }

    public void setTickLabelSpacing(Integer tickLabelSpacing) {
        this.tickLabelSpacing = tickLabelSpacing;
    }

    public Axis tickLabelPosition(TickLabelPositionEnum tickLabelPosition) {
        this.tickLabelPosition = tickLabelPosition;
        return this;
    }

    @ApiModelProperty(value="The position of tick-mark labels on the specified axis.")
    public TickLabelPositionEnum getTickLabelPosition() {
        return this.tickLabelPosition;
    }

    public void setTickLabelPosition(TickLabelPositionEnum tickLabelPosition) {
        this.tickLabelPosition = tickLabelPosition;
    }

    public Axis tickLabelRotationAngle(Double tickLabelRotationAngle) {
        this.tickLabelRotationAngle = tickLabelRotationAngle;
        return this;
    }

    @ApiModelProperty(value="Represents the rotation angle of tick labels.")
    public Double getTickLabelRotationAngle() {
        return this.tickLabelRotationAngle;
    }

    public void setTickLabelRotationAngle(Double tickLabelRotationAngle) {
        this.tickLabelRotationAngle = tickLabelRotationAngle;
    }

    public Axis fillFormat(FillFormat fillFormat) {
        this.fillFormat = fillFormat;
        return this;
    }

    @ApiModelProperty(value="Get or sets the fill format.")
    public FillFormat getFillFormat() {
        return this.fillFormat;
    }

    public void setFillFormat(FillFormat fillFormat) {
        this.fillFormat = fillFormat;
    }

    public Axis effectFormat(EffectFormat effectFormat) {
        this.effectFormat = effectFormat;
        return this;
    }

    @ApiModelProperty(value="Get or sets the effect format.")
    public EffectFormat getEffectFormat() {
        return this.effectFormat;
    }

    public void setEffectFormat(EffectFormat effectFormat) {
        this.effectFormat = effectFormat;
    }

    public Axis lineFormat(LineFormat lineFormat) {
        this.lineFormat = lineFormat;
        return this;
    }

    @ApiModelProperty(value="Get or sets the line format.")
    public LineFormat getLineFormat() {
        return this.lineFormat;
    }

    public void setLineFormat(LineFormat lineFormat) {
        this.lineFormat = lineFormat;
    }

    public Axis majorGridLinesFormat(ChartLinesFormat majorGridLinesFormat) {
        this.majorGridLinesFormat = majorGridLinesFormat;
        return this;
    }

    @ApiModelProperty(value="Get or sets the format of major grid lines.")
    public ChartLinesFormat getMajorGridLinesFormat() {
        return this.majorGridLinesFormat;
    }

    public void setMajorGridLinesFormat(ChartLinesFormat majorGridLinesFormat) {
        this.majorGridLinesFormat = majorGridLinesFormat;
    }

    public Axis minorGridLinesFormat(ChartLinesFormat minorGridLinesFormat) {
        this.minorGridLinesFormat = minorGridLinesFormat;
        return this;
    }

    @ApiModelProperty(value="Get or sets the format of major grid lines.")
    public ChartLinesFormat getMinorGridLinesFormat() {
        return this.minorGridLinesFormat;
    }

    public void setMinorGridLinesFormat(ChartLinesFormat minorGridLinesFormat) {
        this.minorGridLinesFormat = minorGridLinesFormat;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Axis axis = (Axis)o;
        return Objects.equals(this.isVisible, axis.isVisible) && Objects.equals(this.hasTitle, axis.hasTitle) && Objects.equals(this.title, axis.title) && Objects.equals((Object)this.position, (Object)axis.position) && Objects.equals((Object)this.displayUnit, (Object)axis.displayUnit) && Objects.equals((Object)this.baseUnitScale, (Object)axis.baseUnitScale) && Objects.equals(this.isAutomaticMajorUnit, axis.isAutomaticMajorUnit) && Objects.equals(this.majorUnit, axis.majorUnit) && Objects.equals((Object)this.majorUnitScale, (Object)axis.majorUnitScale) && Objects.equals((Object)this.majorTickMark, (Object)axis.majorTickMark) && Objects.equals(this.isAutomaticMinorUnit, axis.isAutomaticMinorUnit) && Objects.equals(this.minorUnit, axis.minorUnit) && Objects.equals((Object)this.minorUnitScale, (Object)axis.minorUnitScale) && Objects.equals((Object)this.minorTickMark, (Object)axis.minorTickMark) && Objects.equals(this.isAutomaticMaxValue, axis.isAutomaticMaxValue) && Objects.equals(this.maxValue, axis.maxValue) && Objects.equals(this.isAutomaticMinValue, axis.isAutomaticMinValue) && Objects.equals(this.minValue, axis.minValue) && Objects.equals(this.isLogarithmic, axis.isLogarithmic) && Objects.equals(this.logBase, axis.logBase) && Objects.equals((Object)this.categoryAxisType, (Object)axis.categoryAxisType) && Objects.equals(this.axisBetweenCategories, axis.axisBetweenCategories) && Objects.equals(this.labelOffset, axis.labelOffset) && Objects.equals(this.isPlotOrderReversed, axis.isPlotOrderReversed) && Objects.equals(this.isNumberFormatLinkedToSource, axis.isNumberFormatLinkedToSource) && Objects.equals(this.numberFormat, axis.numberFormat) && Objects.equals((Object)this.crossType, (Object)axis.crossType) && Objects.equals(this.crossAt, axis.crossAt) && Objects.equals(this.isAutomaticTickMarksSpacing, axis.isAutomaticTickMarksSpacing) && Objects.equals(this.tickMarksSpacing, axis.tickMarksSpacing) && Objects.equals(this.isAutomaticTickLabelSpacing, axis.isAutomaticTickLabelSpacing) && Objects.equals(this.tickLabelSpacing, axis.tickLabelSpacing) && Objects.equals((Object)this.tickLabelPosition, (Object)axis.tickLabelPosition) && Objects.equals(this.tickLabelRotationAngle, axis.tickLabelRotationAngle) && Objects.equals(this.fillFormat, axis.fillFormat) && Objects.equals(this.effectFormat, axis.effectFormat) && Objects.equals(this.lineFormat, axis.lineFormat) && Objects.equals(this.majorGridLinesFormat, axis.majorGridLinesFormat) && Objects.equals(this.minorGridLinesFormat, axis.minorGridLinesFormat);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.isVisible, this.hasTitle, this.title, this.position, this.displayUnit, this.baseUnitScale, this.isAutomaticMajorUnit, this.majorUnit, this.majorUnitScale, this.majorTickMark, this.isAutomaticMinorUnit, this.minorUnit, this.minorUnitScale, this.minorTickMark, this.isAutomaticMaxValue, this.maxValue, this.isAutomaticMinValue, this.minValue, this.isLogarithmic, this.logBase, this.categoryAxisType, this.axisBetweenCategories, this.labelOffset, this.isPlotOrderReversed, this.isNumberFormatLinkedToSource, this.numberFormat, this.crossType, this.crossAt, this.isAutomaticTickMarksSpacing, this.tickMarksSpacing, this.isAutomaticTickLabelSpacing, this.tickLabelSpacing, this.tickLabelPosition, this.tickLabelRotationAngle, this.fillFormat, this.effectFormat, this.lineFormat, this.majorGridLinesFormat, this.minorGridLinesFormat});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Axis {\n");
        sb.append("    isVisible: ").append(this.toIndentedString(this.isVisible)).append("\n");
        sb.append("    hasTitle: ").append(this.toIndentedString(this.hasTitle)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    position: ").append(this.toIndentedString((Object)this.position)).append("\n");
        sb.append("    displayUnit: ").append(this.toIndentedString((Object)this.displayUnit)).append("\n");
        sb.append("    baseUnitScale: ").append(this.toIndentedString((Object)this.baseUnitScale)).append("\n");
        sb.append("    isAutomaticMajorUnit: ").append(this.toIndentedString(this.isAutomaticMajorUnit)).append("\n");
        sb.append("    majorUnit: ").append(this.toIndentedString(this.majorUnit)).append("\n");
        sb.append("    majorUnitScale: ").append(this.toIndentedString((Object)this.majorUnitScale)).append("\n");
        sb.append("    majorTickMark: ").append(this.toIndentedString((Object)this.majorTickMark)).append("\n");
        sb.append("    isAutomaticMinorUnit: ").append(this.toIndentedString(this.isAutomaticMinorUnit)).append("\n");
        sb.append("    minorUnit: ").append(this.toIndentedString(this.minorUnit)).append("\n");
        sb.append("    minorUnitScale: ").append(this.toIndentedString((Object)this.minorUnitScale)).append("\n");
        sb.append("    minorTickMark: ").append(this.toIndentedString((Object)this.minorTickMark)).append("\n");
        sb.append("    isAutomaticMaxValue: ").append(this.toIndentedString(this.isAutomaticMaxValue)).append("\n");
        sb.append("    maxValue: ").append(this.toIndentedString(this.maxValue)).append("\n");
        sb.append("    isAutomaticMinValue: ").append(this.toIndentedString(this.isAutomaticMinValue)).append("\n");
        sb.append("    minValue: ").append(this.toIndentedString(this.minValue)).append("\n");
        sb.append("    isLogarithmic: ").append(this.toIndentedString(this.isLogarithmic)).append("\n");
        sb.append("    logBase: ").append(this.toIndentedString(this.logBase)).append("\n");
        sb.append("    categoryAxisType: ").append(this.toIndentedString((Object)this.categoryAxisType)).append("\n");
        sb.append("    axisBetweenCategories: ").append(this.toIndentedString(this.axisBetweenCategories)).append("\n");
        sb.append("    labelOffset: ").append(this.toIndentedString(this.labelOffset)).append("\n");
        sb.append("    isPlotOrderReversed: ").append(this.toIndentedString(this.isPlotOrderReversed)).append("\n");
        sb.append("    isNumberFormatLinkedToSource: ").append(this.toIndentedString(this.isNumberFormatLinkedToSource)).append("\n");
        sb.append("    numberFormat: ").append(this.toIndentedString(this.numberFormat)).append("\n");
        sb.append("    crossType: ").append(this.toIndentedString((Object)this.crossType)).append("\n");
        sb.append("    crossAt: ").append(this.toIndentedString(this.crossAt)).append("\n");
        sb.append("    isAutomaticTickMarksSpacing: ").append(this.toIndentedString(this.isAutomaticTickMarksSpacing)).append("\n");
        sb.append("    tickMarksSpacing: ").append(this.toIndentedString(this.tickMarksSpacing)).append("\n");
        sb.append("    isAutomaticTickLabelSpacing: ").append(this.toIndentedString(this.isAutomaticTickLabelSpacing)).append("\n");
        sb.append("    tickLabelSpacing: ").append(this.toIndentedString(this.tickLabelSpacing)).append("\n");
        sb.append("    tickLabelPosition: ").append(this.toIndentedString((Object)this.tickLabelPosition)).append("\n");
        sb.append("    tickLabelRotationAngle: ").append(this.toIndentedString(this.tickLabelRotationAngle)).append("\n");
        sb.append("    fillFormat: ").append(this.toIndentedString(this.fillFormat)).append("\n");
        sb.append("    effectFormat: ").append(this.toIndentedString(this.effectFormat)).append("\n");
        sb.append("    lineFormat: ").append(this.toIndentedString(this.lineFormat)).append("\n");
        sb.append("    majorGridLinesFormat: ").append(this.toIndentedString(this.majorGridLinesFormat)).append("\n");
        sb.append("    minorGridLinesFormat: ").append(this.toIndentedString(this.minorGridLinesFormat)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TickLabelPositionEnum {
        HIGH("High"),
        LOW("Low"),
        NEXTTO("NextTo"),
        NONE("None");

        private String value;

        private TickLabelPositionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TickLabelPositionEnum fromValue(String text) {
            for (TickLabelPositionEnum b : TickLabelPositionEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TickLabelPositionEnum> {
            public void write(JsonWriter jsonWriter, TickLabelPositionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TickLabelPositionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TickLabelPositionEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CrossTypeEnum {
        AXISCROSSESATZERO("AxisCrossesAtZero"),
        MAXIMUM("Maximum"),
        CUSTOM("Custom");

        private String value;

        private CrossTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CrossTypeEnum fromValue(String text) {
            for (CrossTypeEnum b : CrossTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<CrossTypeEnum> {
            public void write(JsonWriter jsonWriter, CrossTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public CrossTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CrossTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CategoryAxisTypeEnum {
        TEXT("Text"),
        DATE("Date");

        private String value;

        private CategoryAxisTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CategoryAxisTypeEnum fromValue(String text) {
            for (CategoryAxisTypeEnum b : CategoryAxisTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<CategoryAxisTypeEnum> {
            public void write(JsonWriter jsonWriter, CategoryAxisTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public CategoryAxisTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CategoryAxisTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum MinorTickMarkEnum {
        CROSS("Cross"),
        INSIDE("Inside"),
        NONE("None"),
        OUTSIDE("Outside");

        private String value;

        private MinorTickMarkEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static MinorTickMarkEnum fromValue(String text) {
            for (MinorTickMarkEnum b : MinorTickMarkEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<MinorTickMarkEnum> {
            public void write(JsonWriter jsonWriter, MinorTickMarkEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public MinorTickMarkEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return MinorTickMarkEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum MinorUnitScaleEnum {
        NONE("None"),
        DAYS("Days"),
        MONTHS("Months"),
        YEARS("Years");

        private String value;

        private MinorUnitScaleEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static MinorUnitScaleEnum fromValue(String text) {
            for (MinorUnitScaleEnum b : MinorUnitScaleEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<MinorUnitScaleEnum> {
            public void write(JsonWriter jsonWriter, MinorUnitScaleEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public MinorUnitScaleEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return MinorUnitScaleEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum MajorTickMarkEnum {
        CROSS("Cross"),
        INSIDE("Inside"),
        NONE("None"),
        OUTSIDE("Outside");

        private String value;

        private MajorTickMarkEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static MajorTickMarkEnum fromValue(String text) {
            for (MajorTickMarkEnum b : MajorTickMarkEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<MajorTickMarkEnum> {
            public void write(JsonWriter jsonWriter, MajorTickMarkEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public MajorTickMarkEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return MajorTickMarkEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum MajorUnitScaleEnum {
        NONE("None"),
        DAYS("Days"),
        MONTHS("Months"),
        YEARS("Years");

        private String value;

        private MajorUnitScaleEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static MajorUnitScaleEnum fromValue(String text) {
            for (MajorUnitScaleEnum b : MajorUnitScaleEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<MajorUnitScaleEnum> {
            public void write(JsonWriter jsonWriter, MajorUnitScaleEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public MajorUnitScaleEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return MajorUnitScaleEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum BaseUnitScaleEnum {
        NONE("None"),
        DAYS("Days"),
        MONTHS("Months"),
        YEARS("Years");

        private String value;

        private BaseUnitScaleEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static BaseUnitScaleEnum fromValue(String text) {
            for (BaseUnitScaleEnum b : BaseUnitScaleEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<BaseUnitScaleEnum> {
            public void write(JsonWriter jsonWriter, BaseUnitScaleEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public BaseUnitScaleEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return BaseUnitScaleEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DisplayUnitEnum {
        NONE("None"),
        HUNDREDS("Hundreds"),
        THOUSANDS("Thousands"),
        TENTHOUSANDS("TenThousands"),
        HUNDREDTHOUSANDS("HundredThousands"),
        MILLIONS("Millions"),
        TENMILLIONS("TenMillions"),
        HUNDREDMILLIONS("HundredMillions"),
        BILLIONS("Billions"),
        TRILLIONS("Trillions"),
        CUSTOMVALUE("CustomValue");

        private String value;

        private DisplayUnitEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DisplayUnitEnum fromValue(String text) {
            for (DisplayUnitEnum b : DisplayUnitEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<DisplayUnitEnum> {
            public void write(JsonWriter jsonWriter, DisplayUnitEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public DisplayUnitEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DisplayUnitEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PositionEnum {
        BOTTOM("Bottom"),
        LEFT("Left"),
        RIGHT("Right"),
        TOP("Top");

        private String value;

        private PositionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PositionEnum fromValue(String text) {
            for (PositionEnum b : PositionEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<PositionEnum> {
            public void write(JsonWriter jsonWriter, PositionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PositionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PositionEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

