/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.MathElement;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Specifies an instance of mathematical text that contained within a MathParagraph and starts on its own line.")
public class BlockElement
extends MathElement {
    @SerializedName(value="mathElementList", alternate={"MathElementList"})
    private List<MathElement> mathElementList = null;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public BlockElement() {
        this.setType(MathElement.TypeEnum.BLOCK);
    }

    public BlockElement mathElementList(List<MathElement> mathElementList) {
        this.mathElementList = mathElementList;
        return this;
    }

    public BlockElement addMathElementListItem(MathElement mathElementListItem) {
        if (this.mathElementList == null) {
            this.mathElementList = new ArrayList<MathElement>();
        }
        this.mathElementList.add(mathElementListItem);
        return this;
    }

    @ApiModelProperty(value="List of math elements.")
    public List<MathElement> getMathElementList() {
        return this.mathElementList;
    }

    public void setMathElementList(List<MathElement> mathElementList) {
        this.mathElementList = mathElementList;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockElement blockElement = (BlockElement)o;
        return Objects.equals(this.mathElementList, blockElement.mathElementList) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.mathElementList, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BlockElement {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    mathElementList: ").append(this.toIndentedString(this.mathElementList)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    static {
        typeDeterminers.put("Type", (Object)MathElement.TypeEnum.BLOCK);
    }
}

