/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.ImageTransformEffect;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Represents a Blur effect that is applied to the entire shape, including its fill. All color channels, including alpha, are affected.")
public class BlurImageEffect
extends ImageTransformEffect {
    @SerializedName(value="radius", alternate={"Radius"})
    private Double radius;
    @SerializedName(value="grow", alternate={"Grow"})
    private Boolean grow;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public BlurImageEffect() {
        this.setType(ImageTransformEffect.TypeEnum.BLUR);
    }

    public BlurImageEffect radius(Double radius) {
        this.radius = radius;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns or sets blur radius.")
    public Double getRadius() {
        return this.radius;
    }

    public void setRadius(Double radius) {
        this.radius = radius;
    }

    public BlurImageEffect grow(Boolean grow) {
        this.grow = grow;
        return this;
    }

    @ApiModelProperty(required=true, value="Determines whether the bounds of the object should be grown as a result of the blurring. True indicates the bounds are grown while false indicates that they are not.")
    public Boolean isGrow() {
        return this.grow;
    }

    public void setGrow(Boolean grow) {
        this.grow = grow;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlurImageEffect blurImageEffect = (BlurImageEffect)o;
        return Objects.equals(this.radius, blurImageEffect.radius) && Objects.equals(this.grow, blurImageEffect.grow) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.radius, this.grow, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BlurImageEffect {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    radius: ").append(this.toIndentedString(this.radius)).append("\n");
        sb.append("    grow: ").append(this.toIndentedString(this.grow)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    static {
        typeDeterminers.put("Type", (Object)ImageTransformEffect.TypeEnum.BLUR);
    }
}

