/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.MathElement;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Box element.")
public class BoxElement
extends MathElement {
    @SerializedName(value="base", alternate={"Base"})
    private MathElement base;
    @SerializedName(value="operatorEmulator", alternate={"OperatorEmulator"})
    private Boolean operatorEmulator;
    @SerializedName(value="noBreak", alternate={"NoBreak"})
    private Boolean noBreak;
    @SerializedName(value="differential", alternate={"Differential"})
    private Boolean differential;
    @SerializedName(value="alignmentPoint", alternate={"AlignmentPoint"})
    private Boolean alignmentPoint;
    @SerializedName(value="explicitBreak", alternate={"ExplicitBreak"})
    private Integer explicitBreak;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public BoxElement() {
        this.setType(MathElement.TypeEnum.BOX);
    }

    public BoxElement base(MathElement base) {
        this.base = base;
        return this;
    }

    @ApiModelProperty(value="Base")
    public MathElement getBase() {
        return this.base;
    }

    public void setBase(MathElement base) {
        this.base = base;
    }

    public BoxElement operatorEmulator(Boolean operatorEmulator) {
        this.operatorEmulator = operatorEmulator;
        return this;
    }

    @ApiModelProperty(value="Operator emulator")
    public Boolean isOperatorEmulator() {
        return this.operatorEmulator;
    }

    public void setOperatorEmulator(Boolean operatorEmulator) {
        this.operatorEmulator = operatorEmulator;
    }

    public BoxElement noBreak(Boolean noBreak) {
        this.noBreak = noBreak;
        return this;
    }

    @ApiModelProperty(value="No break")
    public Boolean isNoBreak() {
        return this.noBreak;
    }

    public void setNoBreak(Boolean noBreak) {
        this.noBreak = noBreak;
    }

    public BoxElement differential(Boolean differential) {
        this.differential = differential;
        return this;
    }

    @ApiModelProperty(value="Differential")
    public Boolean isDifferential() {
        return this.differential;
    }

    public void setDifferential(Boolean differential) {
        this.differential = differential;
    }

    public BoxElement alignmentPoint(Boolean alignmentPoint) {
        this.alignmentPoint = alignmentPoint;
        return this;
    }

    @ApiModelProperty(value="Alignment point")
    public Boolean isAlignmentPoint() {
        return this.alignmentPoint;
    }

    public void setAlignmentPoint(Boolean alignmentPoint) {
        this.alignmentPoint = alignmentPoint;
    }

    public BoxElement explicitBreak(Integer explicitBreak) {
        this.explicitBreak = explicitBreak;
        return this;
    }

    @ApiModelProperty(value="Explicit break")
    public Integer getExplicitBreak() {
        return this.explicitBreak;
    }

    public void setExplicitBreak(Integer explicitBreak) {
        this.explicitBreak = explicitBreak;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoxElement boxElement = (BoxElement)o;
        return Objects.equals(this.base, boxElement.base) && Objects.equals(this.operatorEmulator, boxElement.operatorEmulator) && Objects.equals(this.noBreak, boxElement.noBreak) && Objects.equals(this.differential, boxElement.differential) && Objects.equals(this.alignmentPoint, boxElement.alignmentPoint) && Objects.equals(this.explicitBreak, boxElement.explicitBreak) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.base, this.operatorEmulator, this.noBreak, this.differential, this.alignmentPoint, this.explicitBreak, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BoxElement {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    base: ").append(this.toIndentedString(this.base)).append("\n");
        sb.append("    operatorEmulator: ").append(this.toIndentedString(this.operatorEmulator)).append("\n");
        sb.append("    noBreak: ").append(this.toIndentedString(this.noBreak)).append("\n");
        sb.append("    differential: ").append(this.toIndentedString(this.differential)).append("\n");
        sb.append("    alignmentPoint: ").append(this.toIndentedString(this.alignmentPoint)).append("\n");
        sb.append("    explicitBreak: ").append(this.toIndentedString(this.explicitBreak)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    static {
        typeDeterminers.put("Type", (Object)MathElement.TypeEnum.BOX);
    }
}

