/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.DataPoint;
import com.aspose.slides.model.ScatterChartDataPoint;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Bubble chart data point.")
public class BubbleChartDataPoint
extends ScatterChartDataPoint {
    @SerializedName(value="bubbleSize", alternate={"BubbleSize"})
    private Double bubbleSize;
    @SerializedName(value="bubbleSizeFormula", alternate={"BubbleSizeFormula"})
    private String bubbleSizeFormula;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public BubbleChartDataPoint() {
        this.setType(DataPoint.TypeEnum.BUBBLE);
    }

    public BubbleChartDataPoint bubbleSize(Double bubbleSize) {
        this.bubbleSize = bubbleSize;
        return this;
    }

    @ApiModelProperty(value="Bubble size.")
    public Double getBubbleSize() {
        return this.bubbleSize;
    }

    public void setBubbleSize(Double bubbleSize) {
        this.bubbleSize = bubbleSize;
    }

    public BubbleChartDataPoint bubbleSizeFormula(String bubbleSizeFormula) {
        this.bubbleSizeFormula = bubbleSizeFormula;
        return this;
    }

    @ApiModelProperty(value="Spreadsheet formula in A1-style.")
    public String getBubbleSizeFormula() {
        return this.bubbleSizeFormula;
    }

    public void setBubbleSizeFormula(String bubbleSizeFormula) {
        this.bubbleSizeFormula = bubbleSizeFormula;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BubbleChartDataPoint bubbleChartDataPoint = (BubbleChartDataPoint)o;
        return Objects.equals(this.bubbleSize, bubbleChartDataPoint.bubbleSize) && Objects.equals(this.bubbleSizeFormula, bubbleChartDataPoint.bubbleSizeFormula) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.bubbleSize, this.bubbleSizeFormula, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BubbleChartDataPoint {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    bubbleSize: ").append(this.toIndentedString(this.bubbleSize)).append("\n");
        sb.append("    bubbleSizeFormula: ").append(this.toIndentedString(this.bubbleSizeFormula)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    static {
        typeDeterminers.put("Type", (Object)DataPoint.TypeEnum.BUBBLE);
    }
}

