/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Camera")
public class Camera {
    @SerializedName(value="cameraType", alternate={"CameraType"})
    private CameraTypeEnum cameraType;
    @SerializedName(value="fieldOfViewAngle", alternate={"FieldOfViewAngle"})
    private Double fieldOfViewAngle;
    @SerializedName(value="zoom", alternate={"Zoom"})
    private Double zoom;
    @SerializedName(value="xrotation", alternate={"XRotation"})
    private Double xrotation;
    @SerializedName(value="yrotation", alternate={"YRotation"})
    private Double yrotation;
    @SerializedName(value="zrotation", alternate={"ZRotation"})
    private Double zrotation;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public Camera cameraType(CameraTypeEnum cameraType) {
        this.cameraType = cameraType;
        return this;
    }

    @ApiModelProperty(value="Camera type")
    public CameraTypeEnum getCameraType() {
        return this.cameraType;
    }

    public void setCameraType(CameraTypeEnum cameraType) {
        this.cameraType = cameraType;
    }

    public Camera fieldOfViewAngle(Double fieldOfViewAngle) {
        this.fieldOfViewAngle = fieldOfViewAngle;
        return this;
    }

    @ApiModelProperty(value="Camera FOV")
    public Double getFieldOfViewAngle() {
        return this.fieldOfViewAngle;
    }

    public void setFieldOfViewAngle(Double fieldOfViewAngle) {
        this.fieldOfViewAngle = fieldOfViewAngle;
    }

    public Camera zoom(Double zoom) {
        this.zoom = zoom;
        return this;
    }

    @ApiModelProperty(value="Camera zoom")
    public Double getZoom() {
        return this.zoom;
    }

    public void setZoom(Double zoom) {
        this.zoom = zoom;
    }

    public Camera xrotation(Double xrotation) {
        this.xrotation = xrotation;
        return this;
    }

    @ApiModelProperty(value="XRotation")
    public Double getXrotation() {
        return this.xrotation;
    }

    public void setXrotation(Double xrotation) {
        this.xrotation = xrotation;
    }

    public Camera yrotation(Double yrotation) {
        this.yrotation = yrotation;
        return this;
    }

    @ApiModelProperty(value="YRotation")
    public Double getYrotation() {
        return this.yrotation;
    }

    public void setYrotation(Double yrotation) {
        this.yrotation = yrotation;
    }

    public Camera zrotation(Double zrotation) {
        this.zrotation = zrotation;
        return this;
    }

    @ApiModelProperty(value="ZRotation")
    public Double getZrotation() {
        return this.zrotation;
    }

    public void setZrotation(Double zrotation) {
        this.zrotation = zrotation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Camera camera = (Camera)o;
        return Objects.equals((Object)this.cameraType, (Object)camera.cameraType) && Objects.equals(this.fieldOfViewAngle, camera.fieldOfViewAngle) && Objects.equals(this.zoom, camera.zoom) && Objects.equals(this.xrotation, camera.xrotation) && Objects.equals(this.yrotation, camera.yrotation) && Objects.equals(this.zrotation, camera.zrotation);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.cameraType, this.fieldOfViewAngle, this.zoom, this.xrotation, this.yrotation, this.zrotation});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Camera {\n");
        sb.append("    cameraType: ").append(this.toIndentedString((Object)this.cameraType)).append("\n");
        sb.append("    fieldOfViewAngle: ").append(this.toIndentedString(this.fieldOfViewAngle)).append("\n");
        sb.append("    zoom: ").append(this.toIndentedString(this.zoom)).append("\n");
        sb.append("    xrotation: ").append(this.toIndentedString(this.xrotation)).append("\n");
        sb.append("    yrotation: ").append(this.toIndentedString(this.yrotation)).append("\n");
        sb.append("    zrotation: ").append(this.toIndentedString(this.zrotation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CameraTypeEnum {
        ISOMETRICBOTTOMDOWN("IsometricBottomDown"),
        ISOMETRICBOTTOMUP("IsometricBottomUp"),
        ISOMETRICLEFTDOWN("IsometricLeftDown"),
        ISOMETRICLEFTUP("IsometricLeftUp"),
        ISOMETRICOFFAXIS1LEFT("IsometricOffAxis1Left"),
        ISOMETRICOFFAXIS1RIGHT("IsometricOffAxis1Right"),
        ISOMETRICOFFAXIS1TOP("IsometricOffAxis1Top"),
        ISOMETRICOFFAXIS2LEFT("IsometricOffAxis2Left"),
        ISOMETRICOFFAXIS2RIGHT("IsometricOffAxis2Right"),
        ISOMETRICOFFAXIS2TOP("IsometricOffAxis2Top"),
        ISOMETRICOFFAXIS3BOTTOM("IsometricOffAxis3Bottom"),
        ISOMETRICOFFAXIS3LEFT("IsometricOffAxis3Left"),
        ISOMETRICOFFAXIS3RIGHT("IsometricOffAxis3Right"),
        ISOMETRICOFFAXIS4BOTTOM("IsometricOffAxis4Bottom"),
        ISOMETRICOFFAXIS4LEFT("IsometricOffAxis4Left"),
        ISOMETRICOFFAXIS4RIGHT("IsometricOffAxis4Right"),
        ISOMETRICRIGHTDOWN("IsometricRightDown"),
        ISOMETRICRIGHTUP("IsometricRightUp"),
        ISOMETRICTOPDOWN("IsometricTopDown"),
        ISOMETRICTOPUP("IsometricTopUp"),
        LEGACYOBLIQUEBOTTOM("LegacyObliqueBottom"),
        LEGACYOBLIQUEBOTTOMLEFT("LegacyObliqueBottomLeft"),
        LEGACYOBLIQUEBOTTOMRIGHT("LegacyObliqueBottomRight"),
        LEGACYOBLIQUEFRONT("LegacyObliqueFront"),
        LEGACYOBLIQUELEFT("LegacyObliqueLeft"),
        LEGACYOBLIQUERIGHT("LegacyObliqueRight"),
        LEGACYOBLIQUETOP("LegacyObliqueTop"),
        LEGACYOBLIQUETOPLEFT("LegacyObliqueTopLeft"),
        LEGACYOBLIQUETOPRIGHT("LegacyObliqueTopRight"),
        LEGACYPERSPECTIVEBOTTOM("LegacyPerspectiveBottom"),
        LEGACYPERSPECTIVEBOTTOMLEFT("LegacyPerspectiveBottomLeft"),
        LEGACYPERSPECTIVEBOTTOMRIGHT("LegacyPerspectiveBottomRight"),
        LEGACYPERSPECTIVEFRONT("LegacyPerspectiveFront"),
        LEGACYPERSPECTIVELEFT("LegacyPerspectiveLeft"),
        LEGACYPERSPECTIVERIGHT("LegacyPerspectiveRight"),
        LEGACYPERSPECTIVETOP("LegacyPerspectiveTop"),
        LEGACYPERSPECTIVETOPLEFT("LegacyPerspectiveTopLeft"),
        LEGACYPERSPECTIVETOPRIGHT("LegacyPerspectiveTopRight"),
        OBLIQUEBOTTOM("ObliqueBottom"),
        OBLIQUEBOTTOMLEFT("ObliqueBottomLeft"),
        OBLIQUEBOTTOMRIGHT("ObliqueBottomRight"),
        OBLIQUELEFT("ObliqueLeft"),
        OBLIQUERIGHT("ObliqueRight"),
        OBLIQUETOP("ObliqueTop"),
        OBLIQUETOPLEFT("ObliqueTopLeft"),
        OBLIQUETOPRIGHT("ObliqueTopRight"),
        ORTHOGRAPHICFRONT("OrthographicFront"),
        PERSPECTIVEABOVE("PerspectiveAbove"),
        PERSPECTIVEABOVELEFTFACING("PerspectiveAboveLeftFacing"),
        PERSPECTIVEABOVERIGHTFACING("PerspectiveAboveRightFacing"),
        PERSPECTIVEBELOW("PerspectiveBelow"),
        PERSPECTIVECONTRASTINGLEFTFACING("PerspectiveContrastingLeftFacing"),
        PERSPECTIVECONTRASTINGRIGHTFACING("PerspectiveContrastingRightFacing"),
        PERSPECTIVEFRONT("PerspectiveFront"),
        PERSPECTIVEHEROICEXTREMELEFTFACING("PerspectiveHeroicExtremeLeftFacing"),
        PERSPECTIVEHEROICEXTREMERIGHTFACING("PerspectiveHeroicExtremeRightFacing"),
        PERSPECTIVEHEROICLEFTFACING("PerspectiveHeroicLeftFacing"),
        PERSPECTIVEHEROICRIGHTFACING("PerspectiveHeroicRightFacing"),
        PERSPECTIVELEFT("PerspectiveLeft"),
        PERSPECTIVERELAXED("PerspectiveRelaxed"),
        PERSPECTIVERELAXEDMODERATELY("PerspectiveRelaxedModerately"),
        PERSPECTIVERIGHT("PerspectiveRight"),
        NOTDEFINED("NotDefined");

        private String value;

        private CameraTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CameraTypeEnum fromValue(String text) {
            for (CameraTypeEnum b : CameraTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<CameraTypeEnum> {
            public void write(JsonWriter jsonWriter, CameraTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public CameraTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CameraTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

