/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.EffectFormat;
import com.aspose.slides.model.FillFormat;
import com.aspose.slides.model.LineFormat;
import com.aspose.slides.model.OneValueChartDataPoint;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Represents chart category resource")
public class ChartCategory {
    @SerializedName(value="parentCategories", alternate={"ParentCategories"})
    private List<String> parentCategories = null;
    @SerializedName(value="level", alternate={"Level"})
    private Integer level;
    @SerializedName(value="value", alternate={"Value"})
    private String value;
    @SerializedName(value="fillFormat", alternate={"FillFormat"})
    private FillFormat fillFormat;
    @SerializedName(value="effectFormat", alternate={"EffectFormat"})
    private EffectFormat effectFormat;
    @SerializedName(value="lineFormat", alternate={"LineFormat"})
    private LineFormat lineFormat;
    @SerializedName(value="dataPoints", alternate={"DataPoints"})
    private List<OneValueChartDataPoint> dataPoints = null;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public ChartCategory parentCategories(List<String> parentCategories) {
        this.parentCategories = parentCategories;
        return this;
    }

    public ChartCategory addParentCategoriesItem(String parentCategoriesItem) {
        if (this.parentCategories == null) {
            this.parentCategories = new ArrayList<String>();
        }
        this.parentCategories.add(parentCategoriesItem);
        return this;
    }

    @ApiModelProperty(value="Gets or sets the parent categories. Used with Sunburst &amp; treemap categories; ignored for other chart types.")
    public List<String> getParentCategories() {
        return this.parentCategories;
    }

    public void setParentCategories(List<String> parentCategories) {
        this.parentCategories = parentCategories;
    }

    public ChartCategory level(Integer level) {
        this.level = level;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the grouping level for the category. Used with Sunburst &amp; treemap categories; ignored for other chart types.")
    public Integer getLevel() {
        return this.level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public ChartCategory value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(value="Category value")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public ChartCategory fillFormat(FillFormat fillFormat) {
        this.fillFormat = fillFormat;
        return this;
    }

    @ApiModelProperty(value="Get or sets the fill format.")
    public FillFormat getFillFormat() {
        return this.fillFormat;
    }

    public void setFillFormat(FillFormat fillFormat) {
        this.fillFormat = fillFormat;
    }

    public ChartCategory effectFormat(EffectFormat effectFormat) {
        this.effectFormat = effectFormat;
        return this;
    }

    @ApiModelProperty(value="Get or sets the effect format.")
    public EffectFormat getEffectFormat() {
        return this.effectFormat;
    }

    public void setEffectFormat(EffectFormat effectFormat) {
        this.effectFormat = effectFormat;
    }

    public ChartCategory lineFormat(LineFormat lineFormat) {
        this.lineFormat = lineFormat;
        return this;
    }

    @ApiModelProperty(value="Get or sets the line format.")
    public LineFormat getLineFormat() {
        return this.lineFormat;
    }

    public void setLineFormat(LineFormat lineFormat) {
        this.lineFormat = lineFormat;
    }

    public ChartCategory dataPoints(List<OneValueChartDataPoint> dataPoints) {
        this.dataPoints = dataPoints;
        return this;
    }

    public ChartCategory addDataPointsItem(OneValueChartDataPoint dataPointsItem) {
        if (this.dataPoints == null) {
            this.dataPoints = new ArrayList<OneValueChartDataPoint>();
        }
        this.dataPoints.add(dataPointsItem);
        return this;
    }

    @ApiModelProperty(value="Gets or sets the data points for chart data")
    public List<OneValueChartDataPoint> getDataPoints() {
        return this.dataPoints;
    }

    public void setDataPoints(List<OneValueChartDataPoint> dataPoints) {
        this.dataPoints = dataPoints;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChartCategory chartCategory = (ChartCategory)o;
        return Objects.equals(this.parentCategories, chartCategory.parentCategories) && Objects.equals(this.level, chartCategory.level) && Objects.equals(this.value, chartCategory.value) && Objects.equals(this.fillFormat, chartCategory.fillFormat) && Objects.equals(this.effectFormat, chartCategory.effectFormat) && Objects.equals(this.lineFormat, chartCategory.lineFormat) && Objects.equals(this.dataPoints, chartCategory.dataPoints);
    }

    public int hashCode() {
        return Objects.hash(this.parentCategories, this.level, this.value, this.fillFormat, this.effectFormat, this.lineFormat, this.dataPoints);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ChartCategory {\n");
        sb.append("    parentCategories: ").append(this.toIndentedString(this.parentCategories)).append("\n");
        sb.append("    level: ").append(this.toIndentedString(this.level)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    fillFormat: ").append(this.toIndentedString(this.fillFormat)).append("\n");
        sb.append("    effectFormat: ").append(this.toIndentedString(this.effectFormat)).append("\n");
        sb.append("    lineFormat: ").append(this.toIndentedString(this.lineFormat)).append("\n");
        sb.append("    dataPoints: ").append(this.toIndentedString(this.dataPoints)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

