/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.EffectFormat;
import com.aspose.slides.model.FillFormat;
import com.aspose.slides.model.LineFormat;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Represents a chart wall")
public class ChartWall {
    @SerializedName(value="fillFormat", alternate={"FillFormat"})
    private FillFormat fillFormat;
    @SerializedName(value="effectFormat", alternate={"EffectFormat"})
    private EffectFormat effectFormat;
    @SerializedName(value="lineFormat", alternate={"LineFormat"})
    private LineFormat lineFormat;
    @SerializedName(value="thickness", alternate={"Thickness"})
    private Integer thickness;
    @SerializedName(value="pictureType", alternate={"PictureType"})
    private PictureTypeEnum pictureType;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public ChartWall fillFormat(FillFormat fillFormat) {
        this.fillFormat = fillFormat;
        return this;
    }

    @ApiModelProperty(value="Get or sets the fill format.")
    public FillFormat getFillFormat() {
        return this.fillFormat;
    }

    public void setFillFormat(FillFormat fillFormat) {
        this.fillFormat = fillFormat;
    }

    public ChartWall effectFormat(EffectFormat effectFormat) {
        this.effectFormat = effectFormat;
        return this;
    }

    @ApiModelProperty(value="Get or sets the effect format.")
    public EffectFormat getEffectFormat() {
        return this.effectFormat;
    }

    public void setEffectFormat(EffectFormat effectFormat) {
        this.effectFormat = effectFormat;
    }

    public ChartWall lineFormat(LineFormat lineFormat) {
        this.lineFormat = lineFormat;
        return this;
    }

    @ApiModelProperty(value="Get or sets the line format.")
    public LineFormat getLineFormat() {
        return this.lineFormat;
    }

    public void setLineFormat(LineFormat lineFormat) {
        this.lineFormat = lineFormat;
    }

    public ChartWall thickness(Integer thickness) {
        this.thickness = thickness;
        return this;
    }

    @ApiModelProperty(value="Get or sets wall thickness as a percentage of the largest dimension of the plot volume.")
    public Integer getThickness() {
        return this.thickness;
    }

    public void setThickness(Integer thickness) {
        this.thickness = thickness;
    }

    public ChartWall pictureType(PictureTypeEnum pictureType) {
        this.pictureType = pictureType;
        return this;
    }

    @ApiModelProperty(value="Get or sets mode of bar picture filling.")
    public PictureTypeEnum getPictureType() {
        return this.pictureType;
    }

    public void setPictureType(PictureTypeEnum pictureType) {
        this.pictureType = pictureType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChartWall chartWall = (ChartWall)o;
        return Objects.equals(this.fillFormat, chartWall.fillFormat) && Objects.equals(this.effectFormat, chartWall.effectFormat) && Objects.equals(this.lineFormat, chartWall.lineFormat) && Objects.equals(this.thickness, chartWall.thickness) && Objects.equals((Object)this.pictureType, (Object)chartWall.pictureType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fillFormat, this.effectFormat, this.lineFormat, this.thickness, this.pictureType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ChartWall {\n");
        sb.append("    fillFormat: ").append(this.toIndentedString(this.fillFormat)).append("\n");
        sb.append("    effectFormat: ").append(this.toIndentedString(this.effectFormat)).append("\n");
        sb.append("    lineFormat: ").append(this.toIndentedString(this.lineFormat)).append("\n");
        sb.append("    thickness: ").append(this.toIndentedString(this.thickness)).append("\n");
        sb.append("    pictureType: ").append(this.toIndentedString((Object)this.pictureType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PictureTypeEnum {
        STACK("Stack"),
        STACKSCALE("StackScale"),
        STRETCH("Stretch"),
        NOTDEFINED("NotDefined");

        private String value;

        private PictureTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PictureTypeEnum fromValue(String text) {
            for (PictureTypeEnum b : PictureTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<PictureTypeEnum> {
            public void write(JsonWriter jsonWriter, PictureTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PictureTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PictureTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

