/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.DrawingGuide;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Slide view properties.")
public class CommonSlideViewProperties {
    @SerializedName(value="scale", alternate={"Scale"})
    private Integer scale;
    @SerializedName(value="variableScale", alternate={"VariableScale"})
    private Boolean variableScale;
    @SerializedName(value="drawingGuides", alternate={"DrawingGuides"})
    private List<DrawingGuide> drawingGuides = null;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public CommonSlideViewProperties scale(Integer scale) {
        this.scale = scale;
        return this;
    }

    @ApiModelProperty(value="The view scaling ratio (percentage).")
    public Integer getScale() {
        return this.scale;
    }

    public void setScale(Integer scale) {
        this.scale = scale;
    }

    public CommonSlideViewProperties variableScale(Boolean variableScale) {
        this.variableScale = variableScale;
        return this;
    }

    @ApiModelProperty(value="True if the view content should automatically scale to best fit the current window size.")
    public Boolean isVariableScale() {
        return this.variableScale;
    }

    public void setVariableScale(Boolean variableScale) {
        this.variableScale = variableScale;
    }

    public CommonSlideViewProperties drawingGuides(List<DrawingGuide> drawingGuides) {
        this.drawingGuides = drawingGuides;
        return this;
    }

    public CommonSlideViewProperties addDrawingGuidesItem(DrawingGuide drawingGuidesItem) {
        if (this.drawingGuides == null) {
            this.drawingGuides = new ArrayList<DrawingGuide>();
        }
        this.drawingGuides.add(drawingGuidesItem);
        return this;
    }

    @ApiModelProperty(value="Drawing guides")
    public List<DrawingGuide> getDrawingGuides() {
        return this.drawingGuides;
    }

    public void setDrawingGuides(List<DrawingGuide> drawingGuides) {
        this.drawingGuides = drawingGuides;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommonSlideViewProperties commonSlideViewProperties = (CommonSlideViewProperties)o;
        return Objects.equals(this.scale, commonSlideViewProperties.scale) && Objects.equals(this.variableScale, commonSlideViewProperties.variableScale) && Objects.equals(this.drawingGuides, commonSlideViewProperties.drawingGuides);
    }

    public int hashCode() {
        return Objects.hash(this.scale, this.variableScale, this.drawingGuides);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CommonSlideViewProperties {\n");
        sb.append("    scale: ").append(this.toIndentedString(this.scale)).append("\n");
        sb.append("    variableScale: ").append(this.toIndentedString(this.variableScale)).append("\n");
        sb.append("    drawingGuides: ").append(this.toIndentedString(this.drawingGuides)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

