/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.MathElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Delimiter element")
public class DelimiterElement
extends MathElement {
    @SerializedName(value="arguments", alternate={"Arguments"})
    private List<MathElement> arguments = null;
    @SerializedName(value="beginningCharacter", alternate={"BeginningCharacter"})
    private String beginningCharacter;
    @SerializedName(value="separatorCharacter", alternate={"SeparatorCharacter"})
    private String separatorCharacter;
    @SerializedName(value="endingCharacter", alternate={"EndingCharacter"})
    private String endingCharacter;
    @SerializedName(value="growToMatchOperandHeight", alternate={"GrowToMatchOperandHeight"})
    private Boolean growToMatchOperandHeight;
    @SerializedName(value="delimiterShape", alternate={"DelimiterShape"})
    private DelimiterShapeEnum delimiterShape;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public DelimiterElement() {
        this.setType(MathElement.TypeEnum.DELIMITER);
    }

    public DelimiterElement arguments(List<MathElement> arguments) {
        this.arguments = arguments;
        return this;
    }

    public DelimiterElement addArgumentsItem(MathElement argumentsItem) {
        if (this.arguments == null) {
            this.arguments = new ArrayList<MathElement>();
        }
        this.arguments.add(argumentsItem);
        return this;
    }

    @ApiModelProperty(value="Arguments")
    public List<MathElement> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<MathElement> arguments) {
        this.arguments = arguments;
    }

    public DelimiterElement beginningCharacter(String beginningCharacter) {
        this.beginningCharacter = beginningCharacter;
        return this;
    }

    @ApiModelProperty(value="Beginning character")
    public String getBeginningCharacter() {
        return this.beginningCharacter;
    }

    public void setBeginningCharacter(String beginningCharacter) {
        this.beginningCharacter = beginningCharacter;
    }

    public DelimiterElement separatorCharacter(String separatorCharacter) {
        this.separatorCharacter = separatorCharacter;
        return this;
    }

    @ApiModelProperty(value="Separator character")
    public String getSeparatorCharacter() {
        return this.separatorCharacter;
    }

    public void setSeparatorCharacter(String separatorCharacter) {
        this.separatorCharacter = separatorCharacter;
    }

    public DelimiterElement endingCharacter(String endingCharacter) {
        this.endingCharacter = endingCharacter;
        return this;
    }

    @ApiModelProperty(value="Ending character")
    public String getEndingCharacter() {
        return this.endingCharacter;
    }

    public void setEndingCharacter(String endingCharacter) {
        this.endingCharacter = endingCharacter;
    }

    public DelimiterElement growToMatchOperandHeight(Boolean growToMatchOperandHeight) {
        this.growToMatchOperandHeight = growToMatchOperandHeight;
        return this;
    }

    @ApiModelProperty(value="Grow to match operand height")
    public Boolean isGrowToMatchOperandHeight() {
        return this.growToMatchOperandHeight;
    }

    public void setGrowToMatchOperandHeight(Boolean growToMatchOperandHeight) {
        this.growToMatchOperandHeight = growToMatchOperandHeight;
    }

    public DelimiterElement delimiterShape(DelimiterShapeEnum delimiterShape) {
        this.delimiterShape = delimiterShape;
        return this;
    }

    @ApiModelProperty(value="Delimiter shape")
    public DelimiterShapeEnum getDelimiterShape() {
        return this.delimiterShape;
    }

    public void setDelimiterShape(DelimiterShapeEnum delimiterShape) {
        this.delimiterShape = delimiterShape;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DelimiterElement delimiterElement = (DelimiterElement)o;
        return Objects.equals(this.arguments, delimiterElement.arguments) && Objects.equals(this.beginningCharacter, delimiterElement.beginningCharacter) && Objects.equals(this.separatorCharacter, delimiterElement.separatorCharacter) && Objects.equals(this.endingCharacter, delimiterElement.endingCharacter) && Objects.equals(this.growToMatchOperandHeight, delimiterElement.growToMatchOperandHeight) && Objects.equals((Object)this.delimiterShape, (Object)delimiterElement.delimiterShape) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.arguments, this.beginningCharacter, this.separatorCharacter, this.endingCharacter, this.growToMatchOperandHeight, this.delimiterShape, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DelimiterElement {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    arguments: ").append(this.toIndentedString(this.arguments)).append("\n");
        sb.append("    beginningCharacter: ").append(this.toIndentedString(this.beginningCharacter)).append("\n");
        sb.append("    separatorCharacter: ").append(this.toIndentedString(this.separatorCharacter)).append("\n");
        sb.append("    endingCharacter: ").append(this.toIndentedString(this.endingCharacter)).append("\n");
        sb.append("    growToMatchOperandHeight: ").append(this.toIndentedString(this.growToMatchOperandHeight)).append("\n");
        sb.append("    delimiterShape: ").append(this.toIndentedString((Object)this.delimiterShape)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    static {
        typeDeterminers.put("Type", (Object)MathElement.TypeEnum.DELIMITER);
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DelimiterShapeEnum {
        CENTERED("Centered"),
        MATCH("Match");

        private String value;

        private DelimiterShapeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DelimiterShapeEnum fromValue(String text) {
            for (DelimiterShapeEnum b : DelimiterShapeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<DelimiterShapeEnum> {
            public void write(JsonWriter jsonWriter, DelimiterShapeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public DelimiterShapeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DelimiterShapeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

