/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.FontFallbackRule;
import com.aspose.slides.model.FontSubstRule;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Represents export options for whole presentation.")
public class ExportOptions {
    @SerializedName(value="defaultRegularFont", alternate={"DefaultRegularFont"})
    private String defaultRegularFont;
    @SerializedName(value="deleteEmbeddedBinaryObjects", alternate={"DeleteEmbeddedBinaryObjects"})
    private Boolean deleteEmbeddedBinaryObjects;
    @SerializedName(value="gradientStyle", alternate={"GradientStyle"})
    private GradientStyleEnum gradientStyle;
    @SerializedName(value="fontFallbackRules", alternate={"FontFallbackRules"})
    private List<FontFallbackRule> fontFallbackRules = null;
    @SerializedName(value="fontSubstRules", alternate={"FontSubstRules"})
    private List<FontSubstRule> fontSubstRules = null;
    @SerializedName(value="skipJavaScriptLinks", alternate={"SkipJavaScriptLinks"})
    private Boolean skipJavaScriptLinks;
    @SerializedName(value="format", alternate={"Format"})
    private String format;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public ExportOptions defaultRegularFont(String defaultRegularFont) {
        this.defaultRegularFont = defaultRegularFont;
        return this;
    }

    @ApiModelProperty(value="Default regular font for rendering the presentation. ")
    public String getDefaultRegularFont() {
        return this.defaultRegularFont;
    }

    public void setDefaultRegularFont(String defaultRegularFont) {
        this.defaultRegularFont = defaultRegularFont;
    }

    public ExportOptions deleteEmbeddedBinaryObjects(Boolean deleteEmbeddedBinaryObjects) {
        this.deleteEmbeddedBinaryObjects = deleteEmbeddedBinaryObjects;
        return this;
    }

    @ApiModelProperty(value="True to delete delete all embedded binary objects.")
    public Boolean isDeleteEmbeddedBinaryObjects() {
        return this.deleteEmbeddedBinaryObjects;
    }

    public void setDeleteEmbeddedBinaryObjects(Boolean deleteEmbeddedBinaryObjects) {
        this.deleteEmbeddedBinaryObjects = deleteEmbeddedBinaryObjects;
    }

    public ExportOptions gradientStyle(GradientStyleEnum gradientStyle) {
        this.gradientStyle = gradientStyle;
        return this;
    }

    @ApiModelProperty(value="Default regular font for rendering the presentation. ")
    public GradientStyleEnum getGradientStyle() {
        return this.gradientStyle;
    }

    public void setGradientStyle(GradientStyleEnum gradientStyle) {
        this.gradientStyle = gradientStyle;
    }

    public ExportOptions fontFallbackRules(List<FontFallbackRule> fontFallbackRules) {
        this.fontFallbackRules = fontFallbackRules;
        return this;
    }

    public ExportOptions addFontFallbackRulesItem(FontFallbackRule fontFallbackRulesItem) {
        if (this.fontFallbackRules == null) {
            this.fontFallbackRules = new ArrayList<FontFallbackRule>();
        }
        this.fontFallbackRules.add(fontFallbackRulesItem);
        return this;
    }

    @ApiModelProperty(value="Gets of sets list of font fallback rules.")
    public List<FontFallbackRule> getFontFallbackRules() {
        return this.fontFallbackRules;
    }

    public void setFontFallbackRules(List<FontFallbackRule> fontFallbackRules) {
        this.fontFallbackRules = fontFallbackRules;
    }

    public ExportOptions fontSubstRules(List<FontSubstRule> fontSubstRules) {
        this.fontSubstRules = fontSubstRules;
        return this;
    }

    public ExportOptions addFontSubstRulesItem(FontSubstRule fontSubstRulesItem) {
        if (this.fontSubstRules == null) {
            this.fontSubstRules = new ArrayList<FontSubstRule>();
        }
        this.fontSubstRules.add(fontSubstRulesItem);
        return this;
    }

    @ApiModelProperty(value="Gets of sets list of font substitution rules.")
    public List<FontSubstRule> getFontSubstRules() {
        return this.fontSubstRules;
    }

    public void setFontSubstRules(List<FontSubstRule> fontSubstRules) {
        this.fontSubstRules = fontSubstRules;
    }

    public ExportOptions skipJavaScriptLinks(Boolean skipJavaScriptLinks) {
        this.skipJavaScriptLinks = skipJavaScriptLinks;
        return this;
    }

    @ApiModelProperty(value="True to skip hyperlinks with javascript calls when saving the presentation.")
    public Boolean isSkipJavaScriptLinks() {
        return this.skipJavaScriptLinks;
    }

    public void setSkipJavaScriptLinks(Boolean skipJavaScriptLinks) {
        this.skipJavaScriptLinks = skipJavaScriptLinks;
    }

    @ApiModelProperty(value="")
    public String getFormat() {
        return this.format;
    }

    protected void setFormat(String format) {
        this.format = format;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExportOptions exportOptions = (ExportOptions)o;
        return Objects.equals(this.defaultRegularFont, exportOptions.defaultRegularFont) && Objects.equals(this.deleteEmbeddedBinaryObjects, exportOptions.deleteEmbeddedBinaryObjects) && Objects.equals((Object)this.gradientStyle, (Object)exportOptions.gradientStyle) && Objects.equals(this.fontFallbackRules, exportOptions.fontFallbackRules) && Objects.equals(this.fontSubstRules, exportOptions.fontSubstRules) && Objects.equals(this.skipJavaScriptLinks, exportOptions.skipJavaScriptLinks) && Objects.equals(this.format, exportOptions.format);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.defaultRegularFont, this.deleteEmbeddedBinaryObjects, this.gradientStyle, this.fontFallbackRules, this.fontSubstRules, this.skipJavaScriptLinks, this.format});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExportOptions {\n");
        sb.append("    defaultRegularFont: ").append(this.toIndentedString(this.defaultRegularFont)).append("\n");
        sb.append("    deleteEmbeddedBinaryObjects: ").append(this.toIndentedString(this.deleteEmbeddedBinaryObjects)).append("\n");
        sb.append("    gradientStyle: ").append(this.toIndentedString((Object)this.gradientStyle)).append("\n");
        sb.append("    fontFallbackRules: ").append(this.toIndentedString(this.fontFallbackRules)).append("\n");
        sb.append("    fontSubstRules: ").append(this.toIndentedString(this.fontSubstRules)).append("\n");
        sb.append("    skipJavaScriptLinks: ").append(this.toIndentedString(this.skipJavaScriptLinks)).append("\n");
        sb.append("    format: ").append(this.toIndentedString(this.format)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum GradientStyleEnum {
        DEFAULT("Default"),
        POWERPOINTUI("PowerPointUI");

        private String value;

        private GradientStyleEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static GradientStyleEnum fromValue(String text) {
            for (GradientStyleEnum b : GradientStyleEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<GradientStyleEnum> {
            public void write(JsonWriter jsonWriter, GradientStyleEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public GradientStyleEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return GradientStyleEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

