/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.PathSegment;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Represents GeometryPath of the shape")
public class GeometryPath {
    @SerializedName(value="fillMode", alternate={"FillMode"})
    private FillModeEnum fillMode;
    @SerializedName(value="stroke", alternate={"Stroke"})
    private Boolean stroke;
    @SerializedName(value="pathData", alternate={"PathData"})
    private List<PathSegment> pathData = null;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public GeometryPath fillMode(FillModeEnum fillMode) {
        this.fillMode = fillMode;
        return this;
    }

    @ApiModelProperty(value="Path fill mode")
    public FillModeEnum getFillMode() {
        return this.fillMode;
    }

    public void setFillMode(FillModeEnum fillMode) {
        this.fillMode = fillMode;
    }

    public GeometryPath stroke(Boolean stroke) {
        this.stroke = stroke;
        return this;
    }

    @ApiModelProperty(value="Stroke")
    public Boolean isStroke() {
        return this.stroke;
    }

    public void setStroke(Boolean stroke) {
        this.stroke = stroke;
    }

    public GeometryPath pathData(List<PathSegment> pathData) {
        this.pathData = pathData;
        return this;
    }

    public GeometryPath addPathDataItem(PathSegment pathDataItem) {
        if (this.pathData == null) {
            this.pathData = new ArrayList<PathSegment>();
        }
        this.pathData.add(pathDataItem);
        return this;
    }

    @ApiModelProperty(value="List of PathSegmen objects")
    public List<PathSegment> getPathData() {
        return this.pathData;
    }

    public void setPathData(List<PathSegment> pathData) {
        this.pathData = pathData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeometryPath geometryPath = (GeometryPath)o;
        return Objects.equals((Object)this.fillMode, (Object)geometryPath.fillMode) && Objects.equals(this.stroke, geometryPath.stroke) && Objects.equals(this.pathData, geometryPath.pathData);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fillMode, this.stroke, this.pathData});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GeometryPath {\n");
        sb.append("    fillMode: ").append(this.toIndentedString((Object)this.fillMode)).append("\n");
        sb.append("    stroke: ").append(this.toIndentedString(this.stroke)).append("\n");
        sb.append("    pathData: ").append(this.toIndentedString(this.pathData)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum FillModeEnum {
        NONE("None"),
        NORMAL("Normal"),
        LIGHTEN("Lighten"),
        LIGHTENLESS("LightenLess"),
        DARKEN("Darken"),
        DARKENLESS("DarkenLess");

        private String value;

        private FillModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static FillModeEnum fromValue(String text) {
            for (FillModeEnum b : FillModeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<FillModeEnum> {
            public void write(JsonWriter jsonWriter, FillModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public FillModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return FillModeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

