/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.ImageExportOptionsBase;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Provides options that control how a presentation is saved in Gif format.")
public class GifExportOptions
extends ImageExportOptionsBase {
    @SerializedName(value="exportHiddenSlides", alternate={"ExportHiddenSlides"})
    private Boolean exportHiddenSlides;
    @SerializedName(value="transitionFps", alternate={"TransitionFps"})
    private Integer transitionFps;
    @SerializedName(value="defaultDelay", alternate={"DefaultDelay"})
    private Integer defaultDelay;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public GifExportOptions() {
        this.setFormat("GIF");
    }

    public GifExportOptions exportHiddenSlides(Boolean exportHiddenSlides) {
        this.exportHiddenSlides = exportHiddenSlides;
        return this;
    }

    @ApiModelProperty(value="Determines whether hidden slides will be exported.")
    public Boolean isExportHiddenSlides() {
        return this.exportHiddenSlides;
    }

    public void setExportHiddenSlides(Boolean exportHiddenSlides) {
        this.exportHiddenSlides = exportHiddenSlides;
    }

    public GifExportOptions transitionFps(Integer transitionFps) {
        this.transitionFps = transitionFps;
        return this;
    }

    @ApiModelProperty(value="Gets or sets transition FPS [frames/sec]")
    public Integer getTransitionFps() {
        return this.transitionFps;
    }

    public void setTransitionFps(Integer transitionFps) {
        this.transitionFps = transitionFps;
    }

    public GifExportOptions defaultDelay(Integer defaultDelay) {
        this.defaultDelay = defaultDelay;
        return this;
    }

    @ApiModelProperty(value="Gets or sets default delay time [ms].")
    public Integer getDefaultDelay() {
        return this.defaultDelay;
    }

    public void setDefaultDelay(Integer defaultDelay) {
        this.defaultDelay = defaultDelay;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GifExportOptions gifExportOptions = (GifExportOptions)o;
        return Objects.equals(this.exportHiddenSlides, gifExportOptions.exportHiddenSlides) && Objects.equals(this.transitionFps, gifExportOptions.transitionFps) && Objects.equals(this.defaultDelay, gifExportOptions.defaultDelay) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.exportHiddenSlides, this.transitionFps, this.defaultDelay, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GifExportOptions {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    exportHiddenSlides: ").append(this.toIndentedString(this.exportHiddenSlides)).append("\n");
        sb.append("    transitionFps: ").append(this.toIndentedString(this.transitionFps)).append("\n");
        sb.append("    defaultDelay: ").append(this.toIndentedString(this.defaultDelay)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

