/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.model;

import com.aspose.slides.model.MathElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Specifies a grouping symbol above or below an expression, usually to highlight the relationship between elements ")
public class GroupingCharacterElement
extends MathElement {
    @SerializedName(value="base", alternate={"Base"})
    private MathElement base;
    @SerializedName(value="character", alternate={"Character"})
    private String character;
    @SerializedName(value="position", alternate={"Position"})
    private PositionEnum position;
    @SerializedName(value="verticalJustification", alternate={"VerticalJustification"})
    private VerticalJustificationEnum verticalJustification;
    private static final Map<String, Object> typeDeterminers = new Hashtable<String, Object>();

    public GroupingCharacterElement() {
        this.setType(MathElement.TypeEnum.GROUPINGCHARACTER);
    }

    public GroupingCharacterElement base(MathElement base) {
        this.base = base;
        return this;
    }

    @ApiModelProperty(value="Base")
    public MathElement getBase() {
        return this.base;
    }

    public void setBase(MathElement base) {
        this.base = base;
    }

    public GroupingCharacterElement character(String character) {
        this.character = character;
        return this;
    }

    @ApiModelProperty(value="Grouping character")
    public String getCharacter() {
        return this.character;
    }

    public void setCharacter(String character) {
        this.character = character;
    }

    public GroupingCharacterElement position(PositionEnum position) {
        this.position = position;
        return this;
    }

    @ApiModelProperty(value="Position of grouping character.")
    public PositionEnum getPosition() {
        return this.position;
    }

    public void setPosition(PositionEnum position) {
        this.position = position;
    }

    public GroupingCharacterElement verticalJustification(VerticalJustificationEnum verticalJustification) {
        this.verticalJustification = verticalJustification;
        return this;
    }

    @ApiModelProperty(value="Vertical justification of group character.")
    public VerticalJustificationEnum getVerticalJustification() {
        return this.verticalJustification;
    }

    public void setVerticalJustification(VerticalJustificationEnum verticalJustification) {
        this.verticalJustification = verticalJustification;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupingCharacterElement groupingCharacterElement = (GroupingCharacterElement)o;
        return Objects.equals(this.base, groupingCharacterElement.base) && Objects.equals(this.character, groupingCharacterElement.character) && Objects.equals((Object)this.position, (Object)groupingCharacterElement.position) && Objects.equals((Object)this.verticalJustification, (Object)groupingCharacterElement.verticalJustification) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.base, this.character, this.position, this.verticalJustification, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GroupingCharacterElement {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    base: ").append(this.toIndentedString(this.base)).append("\n");
        sb.append("    character: ").append(this.toIndentedString(this.character)).append("\n");
        sb.append("    position: ").append(this.toIndentedString((Object)this.position)).append("\n");
        sb.append("    verticalJustification: ").append(this.toIndentedString((Object)this.verticalJustification)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    static {
        typeDeterminers.put("Type", (Object)MathElement.TypeEnum.GROUPINGCHARACTER);
    }

    @JsonAdapter(value=Adapter.class)
    public static enum VerticalJustificationEnum {
        NOTDEFINED("NotDefined"),
        TOP("Top"),
        BOTTOM("Bottom");

        private String value;

        private VerticalJustificationEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static VerticalJustificationEnum fromValue(String text) {
            for (VerticalJustificationEnum b : VerticalJustificationEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<VerticalJustificationEnum> {
            public void write(JsonWriter jsonWriter, VerticalJustificationEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public VerticalJustificationEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return VerticalJustificationEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PositionEnum {
        NOTDEFINED("NotDefined"),
        TOP("Top"),
        BOTTOM("Bottom");

        private String value;

        private PositionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PositionEnum fromValue(String text) {
            for (PositionEnum b : PositionEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<PositionEnum> {
            public void write(JsonWriter jsonWriter, PositionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PositionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PositionEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

